/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Buffer;
import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.Field;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseIO;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.OperationNotSupportedException;
import com.gbase.jdbc.ResultSetImpl;
import com.gbase.jdbc.ResultSetRow;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.exceptions.CustomException;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class BufferRow
extends ResultSetRow {
    private Buffer rowFromServer;
    private int homePosition = 0;
    private int preNullBitmaskHomePosition = 0;
    private int lastRequestedIndex = -1;
    private int lastRequestedPos;
    private Field[] metadata;
    private boolean isBinaryEncoded;
    private boolean[] isNull;
    private List openStreams;
    private GBaseIO io;
    private final long maxPacketLength = 0xFFFFFFL;
    private boolean isFirstPacket = true;

    public BufferRow(Buffer buf, Field[] fields, boolean isBinaryEncoded, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        super(exceptionInterceptor);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.rowFromServer = buf;
        this.metadata = fields;
        this.isBinaryEncoded = isBinaryEncoded;
        this.preNullBitmaskHomePosition = this.homePosition = this.rowFromServer.getPosition();
        if (fields != null) {
            this.setMetadata(fields);
        }
    }

    public synchronized void closeOpenStreams() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.openStreams != null) {
            Iterator iter = this.openStreams.iterator();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (iter.hasNext()) {
                try {
                    ((InputStream)iter.next()).close();
                }
                catch (IOException iOException) {}
            }
            this.openStreams.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    private int findAndSeekToOffset(int index) throws SQLException {
        if (!this.isBinaryEncoded) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (index == 0) {
                this.lastRequestedIndex = 0;
                this.lastRequestedPos = this.homePosition;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.rowFromServer.setPosition(this.homePosition);
                return 0;
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (index == this.lastRequestedIndex) {
                this.rowFromServer.setPosition(this.lastRequestedPos);
                return this.lastRequestedPos;
            }
            int startingIndex = 0;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (index > this.lastRequestedIndex) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.lastRequestedIndex >= 0) {
                    startingIndex = this.lastRequestedIndex;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    startingIndex = 0;
                }
                this.rowFromServer.setPosition(this.lastRequestedPos);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                this.rowFromServer.setPosition(this.homePosition);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            for (int i = startingIndex; i < index; ++i) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.rowFromServer.fastSkipLenByteArray();
            }
            this.lastRequestedIndex = index;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.lastRequestedPos = this.rowFromServer.getPosition();
            return this.lastRequestedPos;
        }
        return this.findAndSeekToOffsetForBinaryEncoding(index);
    }

    private int findAndSeekToOffsetForBinaryEncoding(int index) throws SQLException {
        if (index == 0) {
            this.lastRequestedIndex = 0;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.lastRequestedPos = this.homePosition;
            this.rowFromServer.setPosition(this.homePosition);
            return 0;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (index == this.lastRequestedIndex) {
            this.rowFromServer.setPosition(this.lastRequestedPos);
            return this.lastRequestedPos;
        }
        int startingIndex = 0;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (index > this.lastRequestedIndex) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.lastRequestedIndex >= 0) {
                startingIndex = this.lastRequestedIndex;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                startingIndex = 0;
                this.lastRequestedPos = this.homePosition;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            this.rowFromServer.setPosition(this.lastRequestedPos);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            this.rowFromServer.setPosition(this.homePosition);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        block13: for (int i = startingIndex; i < index; ++i) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.isNull[i]) continue;
            int curPosition = this.rowFromServer.getPosition();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            switch (this.metadata[i].getGBaseType()) {
                case 6: {
                    continue block13;
                }
                case 1: {
                    this.rowFromServer.setPosition(curPosition + 1);
                    continue block13;
                }
                case 2: 
                case 13: {
                    this.rowFromServer.setPosition(curPosition + 2);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue block13;
                }
                case 3: 
                case 9: {
                    this.rowFromServer.setPosition(curPosition + 4);
                    continue block13;
                }
                case 8: {
                    this.rowFromServer.setPosition(curPosition + 8);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue block13;
                }
                case 4: {
                    this.rowFromServer.setPosition(curPosition + 4);
                    continue block13;
                }
                case 5: {
                    this.rowFromServer.setPosition(curPosition + 8);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue block13;
                }
                case 11: {
                    this.rowFromServer.fastSkipLenByteArray();
                    continue block13;
                }
                case 10: {
                    this.rowFromServer.fastSkipLenByteArray();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue block13;
                }
                case 7: 
                case 12: {
                    this.rowFromServer.fastSkipLenByteArray();
                    continue block13;
                }
                case 0: 
                case 15: 
                case 16: 
                case 246: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (this.metadata[i].isDataAvailable()) {
                        this.rowFromServer.setIo(this.io);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        this.rowFromServer.fastSkipLenByteArray();
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!this.rowFromServer.wasMultiPacket()) continue block13;
                    this.metadata[i].setDataAvailable(false);
                    continue block13;
                }
                default: {
                    throw SQLError.createSQLException(Messages.getString("GBaseIO.97") + this.metadata[i].getGBaseType() + Messages.getString("GBaseIO.98") + (i + 1) + Messages.getString("GBaseIO.99") + this.metadata.length + Messages.getString("GBaseIO.100"), "S1000", this.exceptionInterceptor);
                }
            }
        }
        this.lastRequestedIndex = index;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.lastRequestedPos = this.rowFromServer.getPosition();
        return this.lastRequestedPos;
    }

    public synchronized InputStream getBinaryInputStream(int columnIndex) throws SQLException {
        if (this.isBinaryEncoded) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.isNull(columnIndex)) {
                return null;
            }
        }
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(this.rowFromServer.getByteBuffer(), offset, (int)length);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.openStreams == null) {
            this.openStreams = new LinkedList();
        }
        return stream;
    }

    public synchronized InputStream getBlobBinaryInputStream(int columnIndex) throws SQLException {
        long length;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.metadata[columnIndex].isDataAvailable()) {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw new CustomException("this column value is not avaliable");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isBinaryEncoded && this.isNull(columnIndex)) {
            return null;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isFirstPacket()) {
            this.findAndSeekToOffset(columnIndex);
            length = this.rowFromServer.readFieldLength();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.metadata[columnIndex].setDataLength(length);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            length = this.metadata[columnIndex].getDataLength();
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return null;
        }
        long readLength = this.rowFromServer.getAlreadyRead();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (readLength < length) {
            ByteArrayInputStream stream;
            if (this.io != null && this.rowFromServer.getTempPosition() == this.rowFromServer.getByteBuffer().length) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    this.io.readNextPackets(this.rowFromServer);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.setFirstPacket(false);
                    this.rowFromServer.setTempPosition(0);
                    offset = this.rowFromServer.getPosition();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            int tempPosition = this.rowFromServer.getPosition() > this.rowFromServer.getTempPosition() ? this.rowFromServer.getPosition() : this.rowFromServer.getTempPosition();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (length - readLength <= (long)(this.rowFromServer.getByteBuffer().length - tempPosition)) {
                int thisRoundReadLength = (int)(length - readLength);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.rowFromServer.setAlreadyRead(0L);
                stream = new ByteArrayInputStream(this.rowFromServer.getByteBuffer(), this.rowFromServer.getPosition(), thisRoundReadLength);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.rowFromServer.setPosition(thisRoundReadLength + this.rowFromServer.getPosition());
                if (!this.isFirstPacket()) {
                    this.lastRequestedPos = this.rowFromServer.getPosition();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.metadata[columnIndex].setDataAvailable(false);
                }
                this.rowFromServer.setTempPosition(thisRoundReadLength);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if ((long)this.rowFromServer.getByteBuffer().length > 0xFFFFFFL) {
                length = 0xFFFFFFL;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                byte[] tempBytes = new byte[(int)length];
                System.arraycopy(this.rowFromServer.getByteBuffer(), 0, tempBytes, 0, (int)length);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                stream = new ByteArrayInputStream(tempBytes, offset, (int)length);
                this.rowFromServer.setByteBuffer(tempBytes);
                this.rowFromServer.setTempPosition((int)length);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                int actuallyRead = this.rowFromServer.getByteBuffer().length - tempPosition;
                stream = new ByteArrayInputStream(this.rowFromServer.getByteBuffer(), offset, actuallyRead);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.rowFromServer.setTempPosition(this.rowFromServer.getByteBuffer().length);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.openStreams == null) {
                this.openStreams = new LinkedList();
            }
            return stream;
        }
        return null;
    }

    public byte[] getColumnValue(int index) throws SQLException {
        this.findAndSeekToOffset(index);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.isBinaryEncoded) {
            return this.rowFromServer.readLenByteArray(0);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull[index]) {
            return null;
        }
        switch (this.metadata[index].getGBaseType()) {
            case 6: {
                return null;
            }
            case 1: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return new byte[]{this.rowFromServer.readByte()};
            }
            case 2: 
            case 13: {
                return this.rowFromServer.getBytes(2);
            }
            case 3: 
            case 9: {
                return this.rowFromServer.getBytes(4);
            }
            case 8: {
                return this.rowFromServer.getBytes(8);
            }
            case 4: {
                return this.rowFromServer.getBytes(4);
            }
            case 5: {
                return this.rowFromServer.getBytes(8);
            }
            case 0: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 246: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return this.rowFromServer.readLenByteArray(0);
            }
        }
        throw SQLError.createSQLException(Messages.getString("GBaseIO.97") + this.metadata[index].getGBaseType() + Messages.getString("GBaseIO.98") + (index + 1) + Messages.getString("GBaseIO.99") + this.metadata.length + Messages.getString("GBaseIO.100"), "S1000", this.exceptionInterceptor);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return 0;
        }
        return StringUtils.getInt(this.rowFromServer.getByteBuffer(), offset, offset + (int)length);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return 0L;
        }
        return StringUtils.getLong(this.rowFromServer.getByteBuffer(), offset, offset + (int)length);
    }

    public double getNativeDouble(int columnIndex) throws SQLException {
        if (this.isNull(columnIndex)) {
            return 0.0;
        }
        this.findAndSeekToOffset(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeDouble(this.rowFromServer.getByteBuffer(), offset);
    }

    public float getNativeFloat(int columnIndex) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return 0.0f;
        }
        this.findAndSeekToOffset(columnIndex);
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getNativeFloat(this.rowFromServer.getByteBuffer(), offset);
    }

    public int getNativeInt(int columnIndex) throws SQLException {
        if (this.isNull(columnIndex)) {
            return 0;
        }
        this.findAndSeekToOffset(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeInt(this.rowFromServer.getByteBuffer(), offset);
    }

    public long getNativeLong(int columnIndex) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return 0L;
        }
        this.findAndSeekToOffset(columnIndex);
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getNativeLong(this.rowFromServer.getByteBuffer(), offset);
    }

    public short getNativeShort(int columnIndex) throws SQLException {
        if (this.isNull(columnIndex)) {
            return 0;
        }
        this.findAndSeekToOffset(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeShort(this.rowFromServer.getByteBuffer(), offset);
    }

    public Timestamp getNativeTimestamp(int columnIndex, Calendar targetCalendar, TimeZone tz, boolean rollForward, GBaseConnection conn, ResultSetImpl rs) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeTimestamp(this.rowFromServer.getByteBuffer(), offset, (int)length, targetCalendar, tz, rollForward, conn, rs);
    }

    public Reader getReader(int columnIndex) throws SQLException {
        InputStream stream = this.getBinaryInputStream(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (stream == null) {
            return null;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            return new InputStreamReader(stream, this.metadata[columnIndex].getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            SQLException sqlEx = SQLError.createSQLException("", this.exceptionInterceptor);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            sqlEx.initCause(e);
            throw sqlEx;
        }
    }

    public String getString(int columnIndex, String encoding, GBaseConnection conn) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isBinaryEncoded && this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return null;
        }
        if (length == 0L) {
            return "";
        }
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getString(encoding, conn, this.rowFromServer.getByteBuffer(), offset, (int)length);
    }

    public Time getTimeFast(int columnIndex, Calendar targetCalendar, TimeZone tz, boolean rollForward, GBaseConnection conn, ResultSetImpl rs) throws SQLException {
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long length = this.rowFromServer.readFieldLength();
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getTimeFast(columnIndex, this.rowFromServer.getByteBuffer(), offset, (int)length, targetCalendar, tz, rollForward, conn, rs);
    }

    public Timestamp getTimestampFast(int columnIndex, Calendar targetCalendar, TimeZone tz, boolean rollForward, GBaseConnection conn, ResultSetImpl rs) throws SQLException {
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long length = this.rowFromServer.readFieldLength();
        int offset = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getTimestampFast(columnIndex, this.rowFromServer.getByteBuffer(), offset, (int)length, targetCalendar, tz, rollForward, conn, rs);
    }

    public boolean isFloatingPointNumber(int index) throws SQLException {
        if (this.isBinaryEncoded) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            switch (this.metadata[index].getSQLType()) {
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        this.findAndSeekToOffset(index);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return false;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == 0L) {
            return false;
        }
        int offset = this.rowFromServer.getPosition();
        byte[] buffer = this.rowFromServer.getByteBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < (int)length; ++i) {
            char c = (char)buffer[offset + i];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (c != 'e' && c != 'E') continue;
            return true;
        }
        return false;
    }

    public boolean isNull(int index) throws SQLException {
        if (!this.isBinaryEncoded) {
            this.findAndSeekToOffset(index);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.rowFromServer.readFieldLength() == -1L;
        }
        return this.isNull[index];
    }

    public long length(int index) throws SQLException {
        this.findAndSeekToOffset(index);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (length == -1L) {
            return 0L;
        }
        return length;
    }

    public void setColumnValue(int index, byte[] value) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        throw new OperationNotSupportedException();
    }

    public ResultSetRow setMetadata(Field[] f) throws SQLException {
        super.setMetadata(f);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isBinaryEncoded) {
            this.setupIsNullBitmask();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return this;
    }

    private void setupIsNullBitmask() throws SQLException {
        if (this.isNull != null) {
            return;
        }
        this.rowFromServer.setPosition(this.preNullBitmaskHomePosition);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int nullCount = (this.metadata.length + 9) / 8;
        byte[] nullBitMask = new byte[nullCount];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < nullCount; ++i) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            nullBitMask[i] = this.rowFromServer.readByte();
        }
        this.homePosition = this.rowFromServer.getPosition();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.isNull = new boolean[this.metadata.length];
        int nullMaskPos = 0;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int bit = 4;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < this.metadata.length; ++i) {
            this.isNull[i] = (nullBitMask[nullMaskPos] & bit) != 0;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (((bit <<= 1) & 0xFF) != 0) continue;
            bit = 1;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            ++nullMaskPos;
        }
    }

    public Date getDateFast(int columnIndex, GBaseConnection conn, ResultSetImpl rs, Calendar targetCalendar) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getDateFast(columnIndex, this.rowFromServer.getByteBuffer(), offset, (int)length, conn, rs, targetCalendar);
    }

    public Date getNativeDate(int columnIndex, GBaseConnection conn, ResultSetImpl rs, Calendar cal) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeDate(columnIndex, this.rowFromServer.getByteBuffer(), offset, (int)length, conn, rs, cal);
    }

    public Object getNativeDateTimeValue(int columnIndex, Calendar targetCalendar, int jdbcType, int gbaseType, TimeZone tz, boolean rollForward, GBaseConnection conn, ResultSetImpl rs) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeDateTimeValue(columnIndex, this.rowFromServer.getByteBuffer(), offset, (int)length, targetCalendar, jdbcType, gbaseType, tz, rollForward, conn, rs);
    }

    public Time getNativeTime(int columnIndex, Calendar targetCalendar, TimeZone tz, boolean rollForward, GBaseConnection conn, ResultSetImpl rs) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isNull(columnIndex)) {
            return null;
        }
        this.findAndSeekToOffset(columnIndex);
        long length = this.rowFromServer.readFieldLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offset = this.rowFromServer.getPosition();
        return this.getNativeTime(columnIndex, this.rowFromServer.getByteBuffer(), offset, (int)length, targetCalendar, tz, rollForward, conn, rs);
    }

    public int getBytesSize() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.rowFromServer.getBufLength();
    }

    public void setAlreadyRead(long position, GBaseIO io) {
        this.rowFromServer.setAlreadyRead(position);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.setIO(io);
    }

    public void getAlreadyRead() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.rowFromServer.getAlreadyRead();
    }

    public long getColumnLength(int index) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            if (!this.metadata[index].isDataAvailable()) {
                throw new CustomException();
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.findAndSeekToOffset(index);
        }
        catch (SQLException e) {
            e.printStackTrace();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (Exception e) {
            e.printStackTrace();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        long colLength = this.rowFromServer.readFieldLength();
        this.metadata[index].setDataLength(colLength);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return colLength;
    }

    public void setIO(GBaseIO io) {
        this.io = io;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    private void setFirstPacket(boolean bool) {
        this.isFirstPacket = bool;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    private boolean isFirstPacket() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.isFirstPacket;
    }
}

