/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.LoadBalancingConnectionProxy;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionGroup {
    private String groupName;
    private long connections = 0L;
    private long activeConnections = 0L;
    private HashMap<Long, LoadBalancingConnectionProxy> connectionProxies = new HashMap();
    private Set<String> hostList = new HashSet<String>();
    private boolean isInitialized = false;
    private long closedProxyTotalPhysicalConnections = 0L;
    private long closedProxyTotalTransactions = 0L;
    private int activeHosts = 0;
    private Set<String> closedHosts = new HashSet<String>();

    ConnectionGroup(String groupName) {
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerConnectionProxy(LoadBalancingConnectionProxy proxy, List<String> localHostList) {
        long currentConnectionId;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ConnectionGroup connectionGroup = this;
        synchronized (connectionGroup) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!this.isInitialized) {
                this.hostList.addAll(localHostList);
                this.isInitialized = true;
                this.activeHosts = localHostList.size();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            currentConnectionId = ++this.connections;
            this.connectionProxies.put(new Long(currentConnectionId), proxy);
        }
        ++this.activeConnections;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return currentConnectionId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Collection<String> getInitialHosts() {
        return this.hostList;
    }

    public int getActiveHostCount() {
        return this.activeHosts;
    }

    public Collection<String> getClosedHosts() {
        return this.closedHosts;
    }

    public long getTotalLogicalConnectionCount() {
        return this.connections;
    }

    public long getActiveLogicalConnectionCount() {
        return this.activeConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActivePhysicalConnectionCount() {
        long connections = 0L;
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i = proxyMap.entrySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i.hasNext()) {
            LoadBalancingConnectionProxy proxy = (LoadBalancingConnectionProxy)i.next().getValue();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            connections += proxy.getActivePhysicalConnectionCount();
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPhysicalConnectionCount() {
        long allConnections = this.closedProxyTotalPhysicalConnections;
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i = proxyMap.entrySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i.hasNext()) {
            LoadBalancingConnectionProxy proxy = (LoadBalancingConnectionProxy)i.next().getValue();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            allConnections += proxy.getTotalPhysicalConnectionCount();
        }
        return allConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalTransactionCount() {
        long transactions = this.closedProxyTotalTransactions;
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i = proxyMap.entrySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i.hasNext()) {
            LoadBalancingConnectionProxy proxy = (LoadBalancingConnectionProxy)i.next().getValue();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            transactions += proxy.getTransactionCount();
        }
        return transactions;
    }

    public void closeConnectionProxy(LoadBalancingConnectionProxy proxy) {
        --this.activeConnections;
        this.connectionProxies.remove(new Long(proxy.getConnectionGroupProxyID()));
        this.closedProxyTotalPhysicalConnections += proxy.getTotalPhysicalConnectionCount();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.closedProxyTotalTransactions += proxy.getTransactionCount();
    }

    public void removeHost(String host) throws SQLException {
        this.removeHost(host, false);
    }

    public void removeHost(String host, boolean killExistingConnections) throws SQLException {
        this.removeHost(host, killExistingConnections, true);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHost(String host, boolean killExistingConnections, boolean waitForGracefulFailover) throws SQLException {
        if (this.activeHosts == 1) {
            throw SQLError.createSQLException("Cannot remove host, only one configured host active.", null);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.hostList.remove(host)) {
            --this.activeHosts;
        } else {
            throw SQLError.createSQLException("Host is not configured: " + host, null);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (killExistingConnections) {
            HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
            synchronized (hashMap) {
                proxyMap.putAll(this.connectionProxies);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            Iterator i = proxyMap.entrySet().iterator();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (i.hasNext()) {
                LoadBalancingConnectionProxy proxy = (LoadBalancingConnectionProxy)i.next().getValue();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (waitForGracefulFailover) {
                    proxy.removeHostWhenNotInUse(host);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue;
                }
                proxy.removeHost(host);
            }
        }
        this.closedHosts.add(host);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public void addHost(String host) {
        this.addHost(host, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHost(String host, boolean forExisting) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ConnectionGroup connectionGroup = this;
        synchronized (connectionGroup) {
            if (this.hostList.add(host)) {
                ++this.activeHosts;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
        if (!forExisting) {
            return;
        }
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        Iterator i = proxyMap.entrySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i.hasNext()) {
            LoadBalancingConnectionProxy proxy = (LoadBalancingConnectionProxy)i.next().getValue();
            proxy.addHost(host);
        }
    }
}

