/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.AssertionFailedException;
import com.gbase.jdbc.ByteArrayRow;
import com.gbase.jdbc.Constants;
import com.gbase.jdbc.DatabaseMetaDataUsingInfoSchema;
import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.Field;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseDefs;
import com.gbase.jdbc.GBaseIO;
import com.gbase.jdbc.IterateBlock;
import com.gbase.jdbc.NonRegisteringDriver;
import com.gbase.jdbc.ResultSetImpl;
import com.gbase.jdbc.ResultSetRow;
import com.gbase.jdbc.RowDataStatic;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.SystemDataBase;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.exceptions.CustomRuntimeException;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static String gbaseKeywordsThatArentSQL92;
    protected static final int MAX_IDENTIFIER_LENGTH = 64;
    private static final int DEFERRABILITY = 13;
    private static final int DELETE_RULE = 10;
    private static final int FK_NAME = 11;
    private static final int FKCOLUMN_NAME = 7;
    private static final int FKTABLE_CAT = 4;
    private static final int FKTABLE_NAME = 6;
    private static final int FKTABLE_SCHEM = 5;
    private static final int KEY_SEQ = 8;
    private static final int PK_NAME = 12;
    private static final int PKCOLUMN_NAME = 3;
    private static final int PKTABLE_CAT = 0;
    private static final int PKTABLE_NAME = 2;
    private static final int PKTABLE_SCHEM = 1;
    private static final String SUPPORTS_FK = "SUPPORTS_FK";
    private static final byte[] TABLE_AS_BYTES;
    private static final byte[] SYSTEM_TABLE_AS_BYTES;
    private static final int UPDATE_RULE = 9;
    private static final byte[] VIEW_AS_BYTES;
    private static final Constructor JDBC_4_DBMD_SHOW_CTOR;
    private static final Constructor JDBC_4_DBMD_IS_CTOR;
    protected GBaseConnection conn;
    protected String database = null;
    protected String quotedId = null;
    private ExceptionInterceptor exceptionInterceptor;

    protected static DatabaseMetaData getInstance(GBaseConnection connToSet, String databaseToSet, boolean checkForInfoSchema) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (connToSet == null) {
            return null;
        }
        if (!Util.isJdbc4()) {
            if (checkForInfoSchema && connToSet != null && connToSet.getUseInformationSchema() && connToSet.versionMeetsMinimum(8, 0, 0)) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return new DatabaseMetaDataUsingInfoSchema(connToSet, databaseToSet);
            }
            return new DatabaseMetaData(connToSet, databaseToSet);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (checkForInfoSchema && connToSet != null && connToSet.getUseInformationSchema() && connToSet.versionMeetsMinimum(8, 0, 0)) {
            return (DatabaseMetaData)Util.handleNewInstance(JDBC_4_DBMD_IS_CTOR, new Object[]{connToSet, databaseToSet}, connToSet.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return (DatabaseMetaData)Util.handleNewInstance(JDBC_4_DBMD_SHOW_CTOR, new Object[]{connToSet, databaseToSet}, connToSet.getExceptionInterceptor());
    }

    protected DatabaseMetaData(GBaseConnection connToSet, String databaseToSet) {
        this.conn = connToSet;
        this.database = databaseToSet;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.exceptionInterceptor = this.conn.getExceptionInterceptor();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            this.quotedId = this.conn.supportsQuotedIdentifiers() ? this.getIdentifierQuoteString() : "";
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (SQLException sqlEx) {
            AssertionFailedException.shouldNotHappen(sqlEx);
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    private ResultSet buildResultSet(Field[] fields, ArrayList rows) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return DatabaseMetaData.buildResultSet(fields, rows, this.conn);
    }

    static ResultSet buildResultSet(Field[] fields, ArrayList rows, GBaseConnection c) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int fieldsLength = fields.length;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < fieldsLength; ++i) {
            int jdbcType = fields[i].getSQLType();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            switch (jdbcType) {
                case -1: 
                case 1: 
                case 12: {
                    fields[i].setCharacterSet(c.getCharacterSetMetadata());
                    break;
                }
            }
            fields[i].setConnection(c);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[i].setUseOldNameMetadata(true);
        }
        return ResultSetImpl.getInstance(c.getCatalog(), fields, new RowDataStatic(rows), c, null, false);
    }

    private void convertToJdbcFunctionList(String catalog, ResultSet proceduresRs, boolean needsClientFiltering, String db, List<ComparableWrapper<String, ResultSetRow>> procedureRows, int nameIndex, Field[] fields) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (proceduresRs.next()) {
            boolean shouldAdd = true;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (needsClientFiltering) {
                shouldAdd = false;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                String procDb = proceduresRs.getString(1);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (db == null && procDb == null) {
                    shouldAdd = true;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (db != null && db.equals(procDb)) {
                    shouldAdd = true;
                }
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!shouldAdd) continue;
            String functionName = proceduresRs.getString(nameIndex);
            Object rowData = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (fields != null && fields.length == 9) {
                rowData = new byte[9][];
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[0] = catalog == null ? null : this.s2b(catalog);
                rowData[1] = null;
                rowData[2] = this.s2b(functionName);
                rowData[3] = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[4] = null;
                rowData[5] = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[6] = this.s2b(proceduresRs.getString("comment"));
                rowData[7] = this.s2b(Integer.toString(2));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[8] = this.s2b(functionName);
            } else {
                rowData = new byte[6][];
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[0] = catalog == null ? null : this.s2b(catalog);
                rowData[1] = null;
                rowData[2] = this.s2b(functionName);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[3] = this.s2b(proceduresRs.getString("comment"));
                rowData[4] = this.s2b(Integer.toString(this.getJDBC4FunctionNoTableConstant()));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rowData[5] = this.s2b(functionName);
            }
            procedureRows.add(new ComparableWrapper<String, ByteArrayRow>(this.getFullyQualifiedName(catalog, functionName), new ByteArrayRow((byte[][])rowData, this.getExceptionInterceptor())));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    protected int getJDBC4FunctionNoTableConstant() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    protected String getFullyQualifiedName(String catalog, String entity) {
        StringBuilder fullyQualifiedName = new StringBuilder(StringUtils.quoteIdentifier(catalog == null ? "" : catalog, this.quotedId, this.conn.getPedantic()));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fullyQualifiedName.append('.');
        fullyQualifiedName.append(StringUtils.quoteIdentifier(entity, this.quotedId, this.conn.getPedantic()));
        return fullyQualifiedName.toString();
    }

    private void convertToJdbcProcedureList(boolean fromSelect, String catalog, ResultSet proceduresRs, boolean needsClientFiltering, String db, List<ComparableWrapper<String, ResultSetRow>> procedureRows, int nameIndex) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (proceduresRs.next()) {
            boolean shouldAdd = true;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (needsClientFiltering) {
                shouldAdd = false;
                String procDb = proceduresRs.getString(1);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (db == null && procDb == null) {
                    shouldAdd = true;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (db != null && db.equals(procDb)) {
                    shouldAdd = true;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
            if (!shouldAdd) continue;
            String procedureName = proceduresRs.getString(nameIndex);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            byte[][] rowData = new byte[9][];
            rowData[0] = catalog == null ? null : this.s2b(catalog);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            rowData[1] = null;
            rowData[2] = this.s2b(procedureName);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            rowData[3] = null;
            rowData[4] = null;
            rowData[5] = null;
            rowData[6] = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            boolean isFunction = fromSelect ? "FUNCTION".equalsIgnoreCase(proceduresRs.getString("type")) : false;
            rowData[7] = this.s2b(isFunction ? Integer.toString(2) : Integer.toString(0));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            rowData[8] = this.s2b(procedureName);
            procedureRows.add(new ComparableWrapper<String, ByteArrayRow>(this.getFullyQualifiedName(catalog, procedureName), new ByteArrayRow(rowData, this.getExceptionInterceptor())));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    private ResultSetRow convertTypeDescriptorToProcedureRow(byte[] procNameAsBytes, byte[] procCatAsBytes, String paramName, boolean isOutParam, boolean isInParam, boolean isReturnParam, TypeDescriptor typeDesc, boolean forGetFunctionColumns, int ordinal) throws SQLException {
        byte[][] row = forGetFunctionColumns ? new byte[17][] : new byte[14][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        row[0] = procCatAsBytes;
        row[1] = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        row[2] = procNameAsBytes;
        row[3] = this.s2b(paramName);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (isInParam && isOutParam) {
            row[4] = this.s2b(String.valueOf(2));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else if (isInParam) {
            row[4] = this.s2b(String.valueOf(1));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else if (isOutParam) {
            row[4] = this.s2b(String.valueOf(4));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else if (isReturnParam) {
            row[4] = this.s2b(String.valueOf(5));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            row[4] = this.s2b(String.valueOf(0));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        row[5] = this.s2b(Short.toString(typeDesc.dataType));
        row[6] = this.s2b(typeDesc.typeName);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        row[7] = typeDesc.columnSize == null ? null : this.s2b(typeDesc.columnSize.toString());
        row[8] = row[7];
        row[9] = typeDesc.decimalDigits == null ? null : this.s2b(typeDesc.decimalDigits.toString());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        row[10] = this.s2b(Integer.toString(typeDesc.numPrecRadix));
        switch (typeDesc.nullability) {
            case 0: {
                row[11] = this.s2b(String.valueOf(0));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                break;
            }
            case 1: {
                row[11] = this.s2b(String.valueOf(1));
                break;
            }
            case 2: {
                row[11] = this.s2b(String.valueOf(2));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                break;
            }
            default: {
                throw SQLError.createSQLException("Internal error while parsing callable statement metadata (unknown nullability value fount)", "S1000", this.getExceptionInterceptor());
            }
        }
        row[12] = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (forGetFunctionColumns) {
            row[13] = null;
            row[14] = this.s2b(String.valueOf(ordinal));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            row[15] = Constants.EMPTY_BYTE_ARRAY;
            row[16] = this.s2b(paramName);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return new ByteArrayRow(row, this.getExceptionInterceptor());
    }

    protected ExceptionInterceptor getExceptionInterceptor() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.exceptionInterceptor;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    public List extractForeignKeyForTable(ArrayList rows, ResultSet rs, String catalog) throws SQLException {
        byte[][] row = new byte[3][];
        row[0] = rs.getBytes(1);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        row[1] = this.s2b(SUPPORTS_FK);
        String createTableString = rs.getString(2);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        StringTokenizer lineTokenizer = new StringTokenizer(createTableString, "\n");
        StringBuffer commentBuf = new StringBuffer("comment; ");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        boolean firstTime = true;
        String quoteChar = this.getIdentifierQuoteString();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (quoteChar == null) {
            quoteChar = "`";
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken().trim();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String constraintName = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (StringUtils.startsWithIgnoreCase(line, "CONSTRAINT")) {
                boolean usingBackTicks = true;
                int beginPos = line.indexOf(quoteChar);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (beginPos == -1) {
                    beginPos = line.indexOf("\"");
                    usingBackTicks = false;
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (beginPos != -1) {
                    int endPos = -1;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (usingBackTicks) {
                        endPos = line.indexOf(quoteChar, beginPos + 1);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        endPos = line.indexOf("\"", beginPos + 1);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (endPos != -1) {
                        constraintName = line.substring(beginPos + 1, endPos);
                        line = line.substring(endPos + 1, line.length()).trim();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                }
            }
            if (!line.startsWith("FOREIGN KEY")) continue;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            char quote = this.quotedId.charAt(0);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            int indexOfFK = line.indexOf("FOREIGN KEY");
            String localColumnName = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String referencedCatalogName = this.quotedId + catalog + this.quotedId;
            String referencedTableName = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String referencedColumnName = null;
            if (indexOfFK != -1) {
                int afterFk = indexOfFK + "FOREIGN KEY".length();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int indexOfRef = StringUtils.indexOfIgnoreCase(afterFk, line, "REFERENCES", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (indexOfRef != -1) {
                    int indexOfParenOpen = line.indexOf(40, afterFk);
                    int indexOfParenClose = StringUtils.indexOfIgnoreCase(indexOfParenOpen, line, ")", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (indexOfParenOpen == -1 || indexOfParenClose == -1) {
                        // empty if block
                    }
                    localColumnName = line.substring(indexOfParenOpen + 1, indexOfParenClose);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    int afterRef = indexOfRef + "REFERENCES".length();
                    int referencedColumnBegin = StringUtils.indexOfIgnoreCase(afterRef, line, "(", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (referencedColumnBegin != -1) {
                        referencedTableName = line.substring(afterRef, referencedColumnBegin);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        int referencedColumnEnd = StringUtils.indexOfIgnoreCase(referencedColumnBegin + 1, line, ")", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (referencedColumnEnd != -1) {
                            referencedColumnName = line.substring(referencedColumnBegin + 1, referencedColumnEnd);
                        }
                        int indexOfCatalogSep = StringUtils.indexOfIgnoreCase(0, referencedTableName, ".", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (indexOfCatalogSep != -1) {
                            referencedCatalogName = referencedTableName.substring(0, indexOfCatalogSep);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            referencedTableName = referencedTableName.substring(indexOfCatalogSep + 1);
                        }
                    }
                }
            }
            if (!firstTime) {
                commentBuf.append("; ");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                firstTime = false;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (constraintName != null) {
                commentBuf.append(constraintName);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                commentBuf.append("not_available");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            commentBuf.append("(");
            commentBuf.append(localColumnName);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            commentBuf.append(") REFER ");
            commentBuf.append(referencedCatalogName);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            commentBuf.append("/");
            commentBuf.append(referencedTableName);
            commentBuf.append("(");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            commentBuf.append(referencedColumnName);
            commentBuf.append(")");
            int lastParenIndex = line.lastIndexOf(")");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (lastParenIndex == line.length() - 1) continue;
            String cascadeOptions = line.substring(lastParenIndex + 1);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            commentBuf.append(" ");
            commentBuf.append(cascadeOptions);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        row[2] = this.s2b(commentBuf.toString());
        rows.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet extractForeignKeyFromCreateTable(String catalog, String tableName) throws SQLException {
        Field[] fields;
        ArrayList rows;
        java.sql.Statement stmt;
        ResultSet rs;
        block23: {
            ArrayList<String> tableList = new ArrayList<String>();
            rs = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            stmt = null;
            if (tableName != null) {
                tableList.add(tableName);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                block21: {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        rs = this.getTables(catalog, "", "%", new String[]{"TABLE"});
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        while (rs.next()) {
                            tableList.add(rs.getString("TABLE_NAME"));
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        Object var7_6 = null;
                        if (rs == null) break block21;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        rs = null;
                        throw throwable;
                    }
                    rs.close();
                }
                rs = null;
            }
            rows = new ArrayList();
            fields = new Field[3];
            fields[0] = new Field("", "Name", 1, Integer.MAX_VALUE);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[1] = new Field("", "Type", 1, 255);
            fields[2] = new Field("", "Comment", 1, Integer.MAX_VALUE);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            int numTables = tableList.size();
            stmt = this.conn.getMetadataSafeStatement();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String quoteChar = this.getIdentifierQuoteString();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (quoteChar == null) {
                quoteChar = "`";
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                for (int i = 0; i < numTables; ++i) {
                    block22: {
                        Object var16_17;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String tableToExtract = (String)tableList.get(i);
                        String query = new StringBuffer("SHOW CREATE TABLE ").append(quoteChar).append(catalog).append(quoteChar).append(".").append(quoteChar).append(tableToExtract).append(quoteChar).toString();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            try {
                                rs = stmt.executeQuery(query);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (rs.next()) {
                                    this.extractForeignKeyForTable(rows, rs, catalog);
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            catch (SQLException sqlEx) {
                                String sqlState = sqlEx.getSQLState();
                                if (!"42S02".equals(sqlState) && sqlEx.getErrorCode() != 1146) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    throw sqlEx;
                                }
                                var16_17 = null;
                                if (rs != null) {
                                    rs.close();
                                }
                                rs = null;
                                continue;
                            }
                            var16_17 = null;
                            if (rs == null) break block22;
                        }
                        catch (Throwable throwable) {
                            var16_17 = null;
                            if (rs != null) {
                                rs.close();
                            }
                            rs = null;
                            throw throwable;
                        }
                        rs.close();
                    }
                    rs = null;
                }
                Object var18_19 = null;
                if (rs == null) break block23;
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                if (rs != null) {
                    rs.close();
                }
                rs = null;
                if (stmt != null) {
                    stmt.close();
                }
                stmt = null;
                throw throwable;
            }
            rs.close();
        }
        rs = null;
        if (stmt != null) {
            stmt.close();
        }
        stmt = null;
        return this.buildResultSet(fields, rows);
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[21];
        fields[0] = new Field("", "TYPE_CAT", 1, 32);
        fields[1] = new Field("", "TYPE_SCHEM", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[2] = new Field("", "TYPE_NAME", 1, 32);
        fields[3] = new Field("", "ATTR_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[4] = new Field("", "DATA_TYPE", 5, 32);
        fields[5] = new Field("", "ATTR_TYPE_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[6] = new Field("", "ATTR_SIZE", 4, 32);
        fields[7] = new Field("", "DECIMAL_DIGITS", 4, 32);
        fields[8] = new Field("", "NUM_PREC_RADIX", 4, 32);
        fields[9] = new Field("", "NULLABLE ", 4, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[10] = new Field("", "REMARKS", 1, 32);
        fields[11] = new Field("", "ATTR_DEF", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[12] = new Field("", "SQL_DATA_TYPE", 4, 32);
        fields[13] = new Field("", "SQL_DATETIME_SUB", 4, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[14] = new Field("", "CHAR_OCTET_LENGTH", 4, 32);
        fields[15] = new Field("", "ORDINAL_POSITION", 4, 32);
        fields[16] = new Field("", "IS_NULLABLE", 1, 32);
        fields[17] = new Field("", "SCOPE_CATALOG", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[18] = new Field("", "SCOPE_SCHEMA", 1, 32);
        fields[19] = new Field("", "SCOPE_TABLE", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[20] = new Field("", "SOURCE_DATA_TYPE", 5, 32);
        return this.buildResultSet(fields, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, final String table, int scope, boolean nullable) throws SQLException {
        ArrayList rows;
        Field[] fields;
        block4: {
            if (table == null) {
                throw SQLError.createSQLException("Table not specified.", "S1009", this.getExceptionInterceptor());
            }
            fields = new Field[8];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[0] = new Field("", "SCOPE", 5, 5);
            fields[1] = new Field("", "COLUMN_NAME", 1, 32);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[2] = new Field("", "DATA_TYPE", 4, 32);
            fields[3] = new Field("", "TYPE_NAME", 1, 32);
            fields[4] = new Field("", "COLUMN_SIZE", 4, 10);
            fields[5] = new Field("", "BUFFER_LENGTH", 4, 10);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[6] = new Field("", "DECIMAL_DIGITS", 5, 10);
            fields[7] = new Field("", "PSEUDO_COLUMN", 5, 5);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            rows = new ArrayList();
            final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                new IterateBlock(this.getCatalogIterator(catalog)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    void forEach(Object catalogStr) throws SQLException {
                        block17: {
                            ResultSet results = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            StringBuffer queryBuf = new StringBuffer("SHOW COLUMNS FROM ");
                            queryBuf.append(DatabaseMetaData.this.quotedId);
                            queryBuf.append(table);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            queryBuf.append(DatabaseMetaData.this.quotedId);
                            queryBuf.append(" FROM ");
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            queryBuf.append(DatabaseMetaData.this.quotedId);
                            queryBuf.append(catalogStr.toString());
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            queryBuf.append(DatabaseMetaData.this.quotedId);
                            results = stmt.executeQuery(queryBuf.toString());
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            while (results.next()) {
                                String keyType = results.getString("Key");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (keyType == null || !StringUtils.startsWithIgnoreCase(keyType, "PRI")) continue;
                                byte[][] rowVal = new byte[8][];
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                rowVal[0] = Integer.toString(2).getBytes();
                                rowVal[1] = results.getBytes("Field");
                                String type = results.getString("Type");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                int size = GBaseIO.getMaxBuf();
                                int decimals = 0;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (type.indexOf("enum") != -1) {
                                    String temp = type.substring(type.indexOf("("), type.indexOf(")"));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                                    int maxLength = 0;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    while (tokenizer.hasMoreTokens()) {
                                        maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    size = maxLength;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    decimals = 0;
                                    type = "enum";
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                } else if (type.indexOf("(") != -1) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (type.indexOf(",") != -1) {
                                        size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(",")));
                                        decimals = Integer.parseInt(type.substring(type.indexOf(",") + 1, type.indexOf(")")));
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(")")));
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    type = type.substring(0, type.indexOf("("));
                                }
                                rowVal[2] = DatabaseMetaData.this.s2b(String.valueOf(GBaseDefs.gbaseToJavaType(type)));
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                rowVal[3] = DatabaseMetaData.this.s2b(type);
                                rowVal[4] = Integer.toString(size + decimals).getBytes();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                rowVal[5] = Integer.toString(size + decimals).getBytes();
                                rowVal[6] = Integer.toString(decimals).getBytes();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                rowVal[7] = Integer.toString(1).getBytes();
                                rows.add(new ByteArrayRow(rowVal, DatabaseMetaData.this.getExceptionInterceptor()));
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            Object var13_13 = null;
                            if (results == null) break block17;
                            try {
                                results.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            results = null;
                            {
                                break block17;
                                catch (SQLException sqlEx) {
                                    if (!"42S02".equals(sqlEx.getSQLState())) {
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        throw sqlEx;
                                    }
                                    Object var13_14 = null;
                                    if (results == null) break block17;
                                    try {
                                        results.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    results = null;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var13_15 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    results = null;
                                }
                                throw throwable;
                            }
                        }
                    }
                }.doForAll();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var10_9 = null;
                if (stmt == null) break block4;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        ResultSet results = this.buildResultSet(fields, rows);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return results;
    }

    private void getCallStmtParameterTypes(String catalog, String procName, String parameterNamePattern, List resultRows) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.getCallStmtParameterTypes(catalog, procName, parameterNamePattern, resultRows, false);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getCallStmtParameterTypes(String catalog, String procName, String parameterNamePattern, List resultRows, boolean forGetFunctionColumns) throws SQLException {
        SQLException sqlEx32;
        SQLException sqlExRethrow2;
        String storageDefnClosures;
        String storageDefnDelims;
        boolean isProcedureInAnsiMode;
        byte[] procCatAsBytes;
        byte[] procNameAsBytes;
        String parameterDef;
        java.sql.Statement paramRetrievalStmt;
        block54: {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            paramRetrievalStmt = null;
            ResultSet paramRetrievalRs = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (parameterNamePattern == null) {
                if (!this.conn.getNullNamePatternMatchesAll()) throw SQLError.createSQLException("Parameter/Column name pattern can not be NULL or empty.", "S1009", this.getExceptionInterceptor());
                parameterNamePattern = "%";
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            String quoteChar = this.getIdentifierQuoteString();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            parameterDef = null;
            procNameAsBytes = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            procCatAsBytes = null;
            isProcedureInAnsiMode = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            storageDefnDelims = null;
            storageDefnClosures = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                paramRetrievalStmt = this.conn.getMetadataSafeStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.conn.lowerCaseTableNames() && catalog != null && catalog.length() != 0) {
                    String oldCatalog = this.conn.getCatalog();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    ResultSet rs = null;
                    try {
                        this.conn.setCatalog(catalog.replaceAll(quoteChar, ""));
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        rs = paramRetrievalStmt.executeQuery("SELECT DATABASE()");
                        rs.next();
                        catalog = rs.getString(1);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        Object var18_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_19 = null;
                        this.conn.setCatalog(oldCatalog);
                        if (rs == null) throw throwable;
                        rs.close();
                        throw throwable;
                    }
                    this.conn.setCatalog(oldCatalog);
                    if (rs != null) {
                        rs.close();
                    }
                }
                if (paramRetrievalStmt.getMaxRows() != 0) {
                    paramRetrievalStmt.setMaxRows(0);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                int dotIndex = -1;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!" ".equals(quoteChar)) {
                    dotIndex = StringUtils.indexOfIgnoreCase(0, procName, ".", this.quotedId, this.quotedId, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    dotIndex = procName.indexOf(".");
                }
                String dbName = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (dotIndex != -1 && dotIndex + 1 < procName.length()) {
                    dbName = procName.substring(0, dotIndex);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    procName = procName.substring(dotIndex + 1);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    dbName = catalog;
                }
                String tmpProcName = procName;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                tmpProcName = tmpProcName.replaceAll(quoteChar, "");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    procNameAsBytes = tmpProcName.getBytes("UTF-8");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (UnsupportedEncodingException ueEx) {
                    procNameAsBytes = this.s2b(tmpProcName);
                }
                tmpProcName = dbName;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                tmpProcName = tmpProcName.replaceAll(quoteChar, "");
                try {
                    procCatAsBytes = tmpProcName.getBytes("UTF-8");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (UnsupportedEncodingException ueEx) {
                    procCatAsBytes = this.s2b(tmpProcName);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                StringBuffer procNameBuf = new StringBuffer();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (dbName != null) {
                    if (!" ".equals(quoteChar) && !dbName.startsWith(quoteChar)) {
                        procNameBuf.append(quoteChar);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    procNameBuf.append(dbName);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!" ".equals(quoteChar) && !dbName.startsWith(quoteChar)) {
                        procNameBuf.append(quoteChar);
                    }
                    procNameBuf.append(".");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                boolean procNameIsNotQuoted = !procName.startsWith(quoteChar);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!" ".equals(quoteChar) && procNameIsNotQuoted) {
                    procNameBuf.append(quoteChar);
                }
                procNameBuf.append(procName);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!" ".equals(quoteChar) && procNameIsNotQuoted) {
                    procNameBuf.append(quoteChar);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                boolean parsingFunction = false;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    paramRetrievalRs = paramRetrievalStmt.executeQuery("SHOW CREATE PROCEDURE " + procNameBuf.toString());
                    parsingFunction = false;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (SQLException sqlEx2) {
                    paramRetrievalRs = paramRetrievalStmt.executeQuery("SHOW CREATE FUNCTION " + procNameBuf.toString());
                    parsingFunction = true;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                if (paramRetrievalRs.next()) {
                    String procedureDef = parsingFunction ? paramRetrievalRs.getString("Create Function") : paramRetrievalRs.getString("Create Procedure");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (procedureDef == null || procedureDef.length() == 0) {
                        throw SQLError.createSQLException("User does not have access to metadata required to determine stored procedure parameter types. If rights can not be granted, configure connection with \"noAccessToProcedureBodies=true\" to have driver generate parameters that represent INOUT strings irregardless of actual parameter types.", "S1000", this.getExceptionInterceptor());
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        String sqlMode = paramRetrievalRs.getString("sql_mode");
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (StringUtils.indexOfIgnoreCase(sqlMode, "ANSI") != -1) {
                            isProcedureInAnsiMode = true;
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    catch (SQLException sqlMode) {
                        // empty catch block
                    }
                    String identifierMarkers = isProcedureInAnsiMode ? "`\"" : "`";
                    String identifierAndStringMarkers = "'" + identifierMarkers;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    storageDefnDelims = "(" + identifierMarkers;
                    storageDefnClosures = ")" + identifierMarkers;
                    procedureDef = StringUtils.stripComments(procedureDef, identifierAndStringMarkers, identifierAndStringMarkers, true, false, true, true);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    int openParenIndex = StringUtils.indexOfIgnoreCase(0, procedureDef, "(", this.quotedId, this.quotedId, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
                    int endOfParamDeclarationIndex = 0;
                    endOfParamDeclarationIndex = this.endPositionOfParameterDeclaration(openParenIndex, procedureDef, quoteChar);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (parsingFunction) {
                        int declarationStart;
                        int returnsIndex = StringUtils.indexOfIgnoreCase(0, procedureDef, " RETURNS ", this.quotedId, this.quotedId, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
                        int endReturnsDef = this.findEndOfReturnsClause(procedureDef, quoteChar, returnsIndex);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        for (declarationStart = returnsIndex + "RETURNS ".length(); declarationStart < procedureDef.length() && Character.isWhitespace(procedureDef.charAt(declarationStart)); ++declarationStart) {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        String returnsDefn = procedureDef.substring(declarationStart, endReturnsDef).trim();
                        TypeDescriptor returnDescriptor = new TypeDescriptor(returnsDefn, "YES");
                        resultRows.add(this.convertTypeDescriptorToProcedureRow(procNameAsBytes, procCatAsBytes, "", false, false, true, returnDescriptor, forGetFunctionColumns, 0));
                    }
                    if (openParenIndex == -1 || endOfParamDeclarationIndex == -1) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        throw SQLError.createSQLException("Internal error when parsing callable statement metadata", "S1000", this.getExceptionInterceptor());
                    }
                    parameterDef = procedureDef.substring(openParenIndex + 1, endOfParamDeclarationIndex);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                Object var32_48 = null;
                sqlExRethrow2 = null;
                if (paramRetrievalRs == null) break block54;
            }
            catch (Throwable throwable) {
                SQLException sqlEx32;
                Object var32_49 = null;
                SQLException sqlExRethrow2 = null;
                if (paramRetrievalRs != null) {
                    try {
                        paramRetrievalRs.close();
                    }
                    catch (SQLException sqlEx32) {
                        sqlExRethrow2 = sqlEx32;
                    }
                    paramRetrievalRs = null;
                }
                if (paramRetrievalStmt != null) {
                    try {
                        paramRetrievalStmt.close();
                    }
                    catch (SQLException sqlEx32) {
                        sqlExRethrow2 = sqlEx32;
                    }
                    paramRetrievalStmt = null;
                }
                if (sqlExRethrow2 == null) throw throwable;
                throw sqlExRethrow2;
            }
            try {
                paramRetrievalRs.close();
            }
            catch (SQLException sqlEx32) {
                sqlExRethrow2 = sqlEx32;
            }
            paramRetrievalRs = null;
        }
        if (paramRetrievalStmt != null) {
            try {
                paramRetrievalStmt.close();
            }
            catch (SQLException sqlEx32) {
                sqlExRethrow2 = sqlEx32;
            }
            paramRetrievalStmt = null;
        }
        if (sqlExRethrow2 != null) {
            throw sqlExRethrow2;
        }
        if (parameterDef == null) return;
        int ordinal = 1;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        List<String> parseList = StringUtils.split(parameterDef, ",", storageDefnDelims, storageDefnClosures, true);
        int parseListLen = parseList.size();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < parseListLen; ++i) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String declaration = parseList.get(i);
            if (declaration.trim().length() == 0) return;
            declaration = declaration.replaceAll("[\\t\\n\\x0B\\f\\r]", " ");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            StringTokenizer declarationTok = new StringTokenizer(declaration, " \t");
            String paramName = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            boolean isOutParam = false;
            boolean isInParam = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException("Internal error when parsing callable statement metadata (unknown output from 'SHOW CREATE PROCEDURE')", "S1000", this.getExceptionInterceptor());
            String possibleParamName = declarationTok.nextToken();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (possibleParamName.equalsIgnoreCase("OUT")) {
                isOutParam = true;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!declarationTok.hasMoreTokens()) {
                    throw SQLError.createSQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000", this.getExceptionInterceptor());
                }
                paramName = declarationTok.nextToken();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (possibleParamName.equalsIgnoreCase("INOUT")) {
                isOutParam = true;
                isInParam = true;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!declarationTok.hasMoreTokens()) {
                    throw SQLError.createSQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000", this.getExceptionInterceptor());
                }
                paramName = declarationTok.nextToken();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (possibleParamName.equalsIgnoreCase("IN")) {
                isOutParam = false;
                isInParam = true;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000", this.getExceptionInterceptor());
                paramName = declarationTok.nextToken();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                isOutParam = false;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                isInParam = true;
                paramName = possibleParamName;
            }
            TypeDescriptor typeDesc = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!declarationTok.hasMoreTokens()) throw SQLError.createSQLException("Internal error when parsing callable statement metadata (missing parameter type)", "S1000", this.getExceptionInterceptor());
            StringBuffer typeInfoBuf = new StringBuffer(declarationTok.nextToken());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (declarationTok.hasMoreTokens()) {
                typeInfoBuf.append(" ");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                typeInfoBuf.append(declarationTok.nextToken());
            }
            String typeInfo = typeInfoBuf.toString();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            typeDesc = new TypeDescriptor(typeInfo, "YES");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (paramName.startsWith("`") && paramName.endsWith("`") || isProcedureInAnsiMode && paramName.startsWith("\"") && paramName.endsWith("\"")) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                paramName = paramName.substring(1, paramName.length() - 1);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (StringUtils.wildCompareIgnoreCase(paramName, parameterNamePattern)) {
                ResultSetRow row = this.convertTypeDescriptorToProcedureRow(procNameAsBytes, procCatAsBytes, paramName, isOutParam, isInParam, false, typeDesc, forGetFunctionColumns, ordinal++);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                resultRows.add(row);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    private int endPositionOfParameterDeclaration(int beginIndex, String procedureDef, String quoteChar) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int currentPos = beginIndex + 1;
        int parenDepth = 1;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (parenDepth > 0 && currentPos < procedureDef.length()) {
            int closedParenIndex = StringUtils.indexOfIgnoreCase(currentPos, procedureDef, ")", quoteChar, quoteChar, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (closedParenIndex != -1) {
                int nextOpenParenIndex = StringUtils.indexOfIgnoreCase(currentPos, procedureDef, "(", quoteChar, quoteChar, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
                if (nextOpenParenIndex != -1 && nextOpenParenIndex < closedParenIndex) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    ++parenDepth;
                    currentPos = closedParenIndex + 1;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue;
                }
                --parenDepth;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                currentPos = closedParenIndex;
                continue;
            }
            throw SQLError.createSQLException("Internal error when parsing callable statement metadata", "S1000", this.getExceptionInterceptor());
        }
        return currentPos;
    }

    private int findEndOfReturnsClause(String procedureDefn, String quoteChar, int positionOfReturnKeyword) throws SQLException {
        int i;
        String[] tokens = new String[]{"LANGUAGE", "NOT", "DETERMINISTIC", "CONTAINS", "NO", "READ", "MODIFIES", "SQL", "COMMENT", "BEGIN", "RETURN"};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int startLookingAt = positionOfReturnKeyword + "RETURNS".length() + 1;
        int endOfReturn = -1;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String openingMarkers = quoteChar + "(";
        String closingMarkers = quoteChar + ")";
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (i = 0; i < tokens.length; ++i) {
            int nextEndOfReturn = StringUtils.indexOfIgnoreCase(startLookingAt, procedureDefn, tokens[i], openingMarkers, closingMarkers, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (nextEndOfReturn == -1) continue;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (endOfReturn != -1 && nextEndOfReturn >= endOfReturn) continue;
            endOfReturn = nextEndOfReturn;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (endOfReturn != -1) {
            return endOfReturn;
        }
        endOfReturn = StringUtils.indexOfIgnoreCase(startLookingAt, procedureDefn, ":", openingMarkers, closingMarkers, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (endOfReturn != -1) {
            for (i = endOfReturn; i > 0; --i) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!Character.isWhitespace(procedureDefn.charAt(i))) continue;
                return i;
            }
        }
        throw SQLError.createSQLException("Internal error when parsing callable statement metadata", "S1000", this.getExceptionInterceptor());
    }

    private int getCascadeDeleteOption(String cascadeOptions) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int onDeletePos = cascadeOptions.indexOf("ON DELETE");
        if (onDeletePos != -1) {
            String deleteOptions = cascadeOptions.substring(onDeletePos, cascadeOptions.length());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (deleteOptions.startsWith("ON DELETE CASCADE")) {
                return 0;
            }
            if (deleteOptions.startsWith("ON DELETE SET NULL")) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return 2;
            }
            if (deleteOptions.startsWith("ON DELETE RESTRICT")) {
                return 1;
            }
            if (deleteOptions.startsWith("ON DELETE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    private int getCascadeUpdateOption(String cascadeOptions) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int onUpdatePos = cascadeOptions.indexOf("ON UPDATE");
        if (onUpdatePos != -1) {
            String updateOptions = cascadeOptions.substring(onUpdatePos, cascadeOptions.length());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (updateOptions.startsWith("ON UPDATE CASCADE")) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return 0;
            }
            if (updateOptions.startsWith("ON UPDATE SET NULL")) {
                return 2;
            }
            if (updateOptions.startsWith("ON UPDATE RESTRICT")) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return 1;
            }
            if (updateOptions.startsWith("ON UPDATE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    protected IteratorWithCleanup getCatalogIterator(String catalogSpec) throws SQLException {
        IteratorWithCleanup allCatalogsIter;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (catalogSpec != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!catalogSpec.equals("")) {
                allCatalogsIter = new SingleStringIterator(catalogSpec);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                allCatalogsIter = new SingleStringIterator(this.database);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else if (this.conn.getNullCatalogMeansCurrent()) {
            allCatalogsIter = new SingleStringIterator(this.database);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            allCatalogsIter = new ResultSetIterator(this.getCatalogs(), 1);
        }
        return allCatalogsIter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        SQLException sqlEx22;
        ResultSet resultSet;
        java.sql.Statement stmt;
        block13: {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            ResultSet results = null;
            stmt = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                results = stmt.executeQuery("SHOW DATABASES");
                int catalogsCount = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (results.last()) {
                    catalogsCount = results.getRow();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    results.beforeFirst();
                }
                ArrayList<String> resultsAsList = new ArrayList<String>(catalogsCount);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                while (results.next()) {
                    resultsAsList.add(results.getString(1));
                }
                Collections.sort(resultsAsList);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                ResultSetMetaData resultsMD = results.getMetaData();
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, resultsMD.getColumnDisplaySize(1))};
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                ArrayList<ByteArrayRow> tuples = new ArrayList<ByteArrayRow>(catalogsCount);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                for (String cat : resultsAsList) {
                    byte[][] rowVal = new byte[][]{this.s2b(cat)};
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    tuples.add(new ByteArrayRow(rowVal, this.getExceptionInterceptor()));
                }
                resultSet = this.buildResultSet(fields, tuples);
                Object var12_11 = null;
                if (results == null) break block13;
            }
            catch (Throwable throwable) {
                block16: {
                    SQLException sqlEx22;
                    Object var12_12 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlEx22) {
                            AssertionFailedException.shouldNotHappen(sqlEx22);
                        }
                        results = null;
                    }
                    if (stmt == null) break block16;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx22) {
                        AssertionFailedException.shouldNotHappen(sqlEx22);
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx22) {
                AssertionFailedException.shouldNotHappen(sqlEx22);
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqlEx22) {
                AssertionFailedException.shouldNotHappen(sqlEx22);
            }
            stmt = null;
        }
        return resultSet;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ArrayList<ByteArrayRow> grantRows;
        Field[] fields;
        block22: {
            Exception exception3;
            java.sql.Statement stmt;
            block19: {
                fields = new Field[8];
                fields[0] = new Field("", "TABLE_CAT", 1, 64);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fields[1] = new Field("", "TABLE_SCHEM", 1, 1);
                fields[2] = new Field("", "TABLE_NAME", 1, 64);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fields[3] = new Field("", "COLUMN_NAME", 1, 64);
                fields[4] = new Field("", "GRANTOR", 1, 77);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fields[5] = new Field("", "GRANTEE", 1, 77);
                fields[6] = new Field("", "PRIVILEGE", 1, 64);
                fields[7] = new Field("", "IS_GRANTABLE", 1, 3);
                StringBuffer grantQuery = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                String sysDataBaseName = SystemDataBase.getSystemDataBaseName(this.conn);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if ("system".equals(sysDataBaseName)) {
                    grantQuery = new StringBuffer("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv from system.columns_priv c, system.tables_priv t where c.host = t.host and c.db = t.db and c.table_name = t.table_name ");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    grantQuery = new StringBuffer("SELECT trim(c.host) host, trim(c.db) db, trim(t.grantor) grantor, trim(c.user) user, trim(c.table_name) table_name, trim(c.column_name) column_name, trim(c.column_priv) column_privfrom gbase.columns_priv c, gbase.tables_priv t where c.host = t.host and c.db = t.db and c.table_name = t.table_name ");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                if (catalog != null && catalog.length() != 0) {
                    grantQuery.append(" AND c.db='");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    grantQuery.append(catalog);
                    grantQuery.append("' ");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                grantQuery.append(" AND c.table_name ='");
                grantQuery.append(table);
                grantQuery.append("' AND trim(c.column_name) like '");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                grantQuery.append(columnNamePattern);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                grantQuery.append("'");
                stmt = null;
                ResultSet results = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                grantRows = new ArrayList<ByteArrayRow>();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    results = stmt.executeQuery(grantQuery.toString());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    while (results.next()) {
                        String host = results.getString(1);
                        String db = results.getString(2);
                        String grantor = results.getString(3);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String user = results.getString(4);
                        if (user == null || user.length() == 0) {
                            user = "%";
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        StringBuffer fullUser = new StringBuffer(user);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (host != null && this.conn.getUseHostsInPrivileges()) {
                            fullUser.append("@");
                            fullUser.append(host);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        String columnName = results.getString(6);
                        String allPrivileges = results.getString(7);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (allPrivileges == null) continue;
                        allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        while (st.hasMoreTokens()) {
                            String privilege = st.nextToken().trim();
                            byte[][] tuple = new byte[8][];
                            tuple[0] = this.s2b(db);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            tuple[1] = null;
                            tuple[2] = this.s2b(table);
                            tuple[3] = this.s2b(columnName);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (grantor != null) {
                                tuple[4] = this.s2b(grantor);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                tuple[4] = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            tuple[5] = this.s2b(fullUser.toString());
                            tuple[6] = this.s2b(privilege);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            tuple[7] = null;
                            grantRows.add(new ByteArrayRow(tuple, this.getExceptionInterceptor()));
                        }
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    Object var22_21 = null;
                    if (results == null) break block19;
                }
                catch (Throwable throwable) {
                    Exception exception22;
                    Object var22_22 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception exception22) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception22) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    results.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                results = null;
            }
            if (stmt == null) break block22;
            try {
                stmt.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            stmt = null;
            {
            }
        }
        return this.buildResultSet(fields, grantRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getColumns(String catalog, final String schemaPattern, final String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList rows;
        Field[] fields;
        block5: {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (columnNamePattern == null) {
                if (!this.conn.getNullNamePatternMatchesAll()) {
                    throw SQLError.createSQLException("Column name pattern can not be NULL or empty.", "S1009", this.getExceptionInterceptor());
                }
                columnNamePattern = "%";
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            final String colPattern = columnNamePattern;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields = this.createColumnsFields();
            rows = new ArrayList();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                new IterateBlock(this.getCatalogIterator(catalog)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void forEach(Object catalogStr) throws SQLException {
                        ArrayList<String> tableNameList;
                        block41: {
                            String tableNameFromList;
                            ResultSet tables;
                            tableNameList = new ArrayList<String>();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (tableNamePattern == null) {
                                block39: {
                                    tables = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    try {
                                        tables = DatabaseMetaData.this.getTables((String)catalogStr, schemaPattern, "%", new String[0]);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        while (tables.next()) {
                                            tableNameFromList = tables.getString("TABLE_NAME");
                                            tableNameList.add(tableNameFromList);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        }
                                        Object var6_5 = null;
                                        if (tables == null) break block39;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_6 = null;
                                        if (tables != null) {
                                            try {
                                                tables.close();
                                            }
                                            catch (Exception sqlEx) {
                                                AssertionFailedException.shouldNotHappen(sqlEx);
                                            }
                                            tables = null;
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        tables.close();
                                    }
                                    catch (Exception sqlEx) {
                                        AssertionFailedException.shouldNotHappen(sqlEx);
                                    }
                                    tables = null;
                                    {
                                    }
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                tables = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                try {
                                    tables = DatabaseMetaData.this.getTables((String)catalogStr, schemaPattern, tableNamePattern, new String[0]);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    while (tables.next()) {
                                        tableNameFromList = tables.getString("TABLE_NAME");
                                        tableNameList.add(tableNameFromList);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    Object var9_12 = null;
                                    if (tables == null) break block41;
                                }
                                catch (Throwable throwable) {
                                    Object var9_13 = null;
                                    if (tables != null) {
                                        try {
                                            tables.close();
                                        }
                                        catch (SQLException sqlEx) {
                                            AssertionFailedException.shouldNotHappen(sqlEx);
                                        }
                                        tables = null;
                                    }
                                    throw throwable;
                                }
                                try {
                                    tables.close();
                                }
                                catch (SQLException sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                tables = null;
                                {
                                }
                            }
                        }
                        Iterator tableNames = tableNameList.iterator();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        while (tableNames.hasNext()) {
                            Exception exception2;
                            Object var15_25;
                            String tableName = (String)tableNames.next();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            ResultSet results = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            try {
                                StringBuffer queryBuf = new StringBuffer("SHOW ");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                    queryBuf.append("FULL ");
                                }
                                queryBuf.append("COLUMNS FROM ");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append(tableName);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append(" FROM ");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append((String)catalogStr);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append(" LIKE '");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(colPattern);
                                queryBuf.append("'");
                                boolean fixUpOrdinalsRequired = false;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                HashMap<String, Integer> ordinalFixUpMap = null;
                                if (!colPattern.equals("%")) {
                                    fixUpOrdinalsRequired = true;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    StringBuffer fullColumnQueryBuf = new StringBuffer("SHOW ");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                        fullColumnQueryBuf.append("FULL ");
                                    }
                                    fullColumnQueryBuf.append("COLUMNS FROM ");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    fullColumnQueryBuf.append(DatabaseMetaData.this.quotedId);
                                    fullColumnQueryBuf.append(tableName);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    fullColumnQueryBuf.append(DatabaseMetaData.this.quotedId);
                                    fullColumnQueryBuf.append(" FROM ");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    fullColumnQueryBuf.append(DatabaseMetaData.this.quotedId);
                                    fullColumnQueryBuf.append((String)catalogStr);
                                    fullColumnQueryBuf.append(DatabaseMetaData.this.quotedId);
                                    results = stmt.executeQuery(fullColumnQueryBuf.toString());
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    ordinalFixUpMap = new HashMap<String, Integer>();
                                    int fullOrdinalPos = 1;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    while (results.next()) {
                                        String fullOrdColName = results.getString("Field");
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        ordinalFixUpMap.put(fullOrdColName, Constants.integerValueOf(fullOrdinalPos++));
                                    }
                                }
                                results = stmt.executeQuery(queryBuf.toString());
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                int ordPos = 1;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (results.next()) {
                                    byte[][] rowVal = new byte[24][];
                                    rowVal[0] = DatabaseMetaData.this.s2b((String)catalogStr);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[1] = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[2] = DatabaseMetaData.this.s2b(tableName);
                                    rowVal[3] = results.getBytes("Field");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    TypeDescriptor typeDesc = new TypeDescriptor(results.getString("Type"), results.getString("Null"));
                                    rowVal[4] = Short.toString(typeDesc.dataType).getBytes();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[5] = DatabaseMetaData.this.s2b(typeDesc.typeName);
                                    rowVal[6] = typeDesc.columnSize == null ? null : DatabaseMetaData.this.s2b(typeDesc.columnSize.toString());
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[7] = DatabaseMetaData.this.s2b(Integer.toString(typeDesc.bufferLength));
                                    rowVal[8] = typeDesc.decimalDigits == null ? null : DatabaseMetaData.this.s2b(typeDesc.decimalDigits.toString());
                                    rowVal[9] = DatabaseMetaData.this.s2b(Integer.toString(typeDesc.numPrecRadix));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[10] = DatabaseMetaData.this.s2b(Integer.toString(typeDesc.nullability));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    try {
                                        if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                            rowVal[11] = results.getBytes("Comment");
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        } else {
                                            rowVal[11] = results.getBytes("Extra");
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        }
                                    }
                                    catch (Exception E) {
                                        rowVal[11] = new byte[0];
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    rowVal[12] = results.getBytes("Default");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[13] = new byte[]{48};
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[14] = new byte[]{48};
                                    if (StringUtils.indexOfIgnoreCase(typeDesc.typeName, "CHAR") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.typeName, "BLOB") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.typeName, "TEXT") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.typeName, "BINARY") != -1) {
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        rowVal[15] = rowVal[6];
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        rowVal[15] = null;
                                    }
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (!fixUpOrdinalsRequired) {
                                        rowVal[16] = Integer.toString(ordPos++).getBytes();
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        String origColName = results.getString("Field");
                                        Integer realOrdinal = (Integer)ordinalFixUpMap.get(origColName);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (realOrdinal != null) {
                                            rowVal[16] = realOrdinal.toString().getBytes();
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        } else {
                                            throw SQLError.createSQLException("Can not find column in full column list to determine true ordinal position.", "S1000", DatabaseMetaData.this.getExceptionInterceptor());
                                        }
                                    }
                                    rowVal[17] = DatabaseMetaData.this.s2b(typeDesc.isNullable);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[18] = null;
                                    rowVal[19] = null;
                                    rowVal[20] = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    rowVal[21] = null;
                                    rowVal[22] = DatabaseMetaData.this.s2b("");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    String extra = results.getString("Extra");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (extra != null) {
                                        rowVal[22] = DatabaseMetaData.this.s2b(StringUtils.indexOfIgnoreCase(extra, "auto_increment") != -1 ? "YES" : "NO");
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        rowVal[23] = DatabaseMetaData.this.s2b(StringUtils.indexOfIgnoreCase(extra, "generated") != -1 ? "YES" : "NO");
                                    }
                                    rows.add(new ByteArrayRow(rowVal, DatabaseMetaData.this.getExceptionInterceptor()));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                                var15_25 = null;
                                if (results == null) continue;
                            }
                            catch (Throwable throwable) {
                                var15_25 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (Exception exception2) {
                                        // empty catch block
                                    }
                                    results = null;
                                }
                                throw throwable;
                            }
                            try {
                                results.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            results = null;
                            {
                            }
                        }
                    }
                }.doForAll();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var10_9 = null;
                if (stmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        ResultSet results = this.buildResultSet(fields, rows);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return results;
    }

    protected Field[] createColumnsFields() {
        Field[] fields = new Field[24];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[0] = new Field("", "TABLE_CAT", 1, 255);
        fields[1] = new Field("", "TABLE_SCHEM", 1, 0);
        fields[2] = new Field("", "TABLE_NAME", 1, 255);
        fields[3] = new Field("", "COLUMN_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[4] = new Field("", "DATA_TYPE", 4, 5);
        fields[5] = new Field("", "TYPE_NAME", 1, 16);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[6] = new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length());
        fields[7] = new Field("", "BUFFER_LENGTH", 4, 10);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[8] = new Field("", "DECIMAL_DIGITS", 4, 10);
        fields[9] = new Field("", "NUM_PREC_RADIX", 4, 10);
        fields[10] = new Field("", "NULLABLE", 4, 10);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[11] = new Field("", "REMARKS", 1, 0);
        fields[12] = new Field("", "COLUMN_DEF", 1, 0);
        fields[13] = new Field("", "SQL_DATA_TYPE", 4, 10);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[14] = new Field("", "SQL_DATETIME_SUB", 4, 10);
        fields[15] = new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[16] = new Field("", "ORDINAL_POSITION", 4, 10);
        fields[17] = new Field("", "IS_NULLABLE", 1, 3);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[18] = new Field("", "SCOPE_CATALOG", 1, 255);
        fields[19] = new Field("", "SCOPE_SCHEMA", 1, 255);
        fields[20] = new Field("", "SCOPE_TABLE", 1, 255);
        fields[21] = new Field("", "SOURCE_DATA_TYPE", 5, 10);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[22] = new Field("", "IS_AUTOINCREMENT", 1, 3);
        fields[23] = new Field("", "IS_GENERATEDCOLUMN", 1, 3);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return fields;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getCrossReference(final String primaryCatalog, final String primarySchema, final String primaryTable, final String foreignCatalog, final String foreignSchema, final String foreignTable) throws SQLException {
        ArrayList tuples;
        Field[] fields;
        block5: {
            if (primaryTable == null) {
                throw SQLError.createSQLException("Table not specified.", "S1009", this.getExceptionInterceptor());
            }
            fields = this.createFkMetadataFields();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            tuples = new ArrayList();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.conn.versionMeetsMinimum(8, 0, 0)) {
                final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    new IterateBlock(this.getCatalogIterator(foreignCatalog)){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        void forEach(Object catalogStr) throws SQLException {
                            block13: {
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                ResultSet fkresults = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                try {
                                    if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                        fkresults = DatabaseMetaData.this.extractForeignKeyFromCreateTable(catalogStr.toString(), null);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        StringBuffer queryBuf = new StringBuffer("SHOW TABLE STATUS FROM ");
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        queryBuf.append(DatabaseMetaData.this.quotedId);
                                        queryBuf.append(catalogStr.toString());
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        queryBuf.append(DatabaseMetaData.this.quotedId);
                                        fkresults = stmt.executeQuery(queryBuf.toString());
                                    }
                                    String foreignTableWithCase = DatabaseMetaData.this.getTableNameWithCase(foreignTable);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    String primaryTableWithCase = DatabaseMetaData.this.getTableNameWithCase(primaryTable);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    while (fkresults.next()) {
                                        String tableType = fkresults.getString("Type");
                                        if (tableType == null || !tableType.equalsIgnoreCase("gsdb") && !tableType.equalsIgnoreCase(DatabaseMetaData.SUPPORTS_FK)) continue;
                                        String comment = fkresults.getString("Comment").trim();
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (comment == null) continue;
                                        StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (commentTokens.hasMoreTokens()) {
                                            String string = commentTokens.nextToken();
                                        }
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        while (commentTokens.hasMoreTokens()) {
                                            String keys = commentTokens.nextToken();
                                            LocalAndReferencedColumns parsedInfo = DatabaseMetaData.this.parseTableStatusIntoLocalAndReferencedColumns(keys);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            int keySeq = 0;
                                            Iterator referencingColumns = parsedInfo.localColumnsList.iterator();
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            Iterator referencedColumns = parsedInfo.referencedColumnsList.iterator();
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            while (referencingColumns.hasNext()) {
                                                String referencingColumn = DatabaseMetaData.this.removeQuotedId(referencingColumns.next().toString());
                                                byte[][] tuple = new byte[14][];
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                tuple[4] = foreignCatalog == null ? null : DatabaseMetaData.this.s2b(foreignCatalog);
                                                tuple[5] = foreignSchema == null ? null : DatabaseMetaData.this.s2b(foreignSchema);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                String dummy = fkresults.getString("Name");
                                                if (dummy.compareTo(foreignTableWithCase) != 0) continue;
                                                tuple[6] = DatabaseMetaData.this.s2b(dummy);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                tuple[7] = DatabaseMetaData.this.s2b(referencingColumn);
                                                tuple[0] = primaryCatalog == null ? null : DatabaseMetaData.this.s2b(primaryCatalog);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                byte[] byArray = tuple[1] = primarySchema == null ? null : DatabaseMetaData.this.s2b(primarySchema);
                                                if (parsedInfo.referencedTable.compareTo(primaryTableWithCase) != 0) {
                                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                    continue;
                                                }
                                                tuple[2] = DatabaseMetaData.this.s2b(parsedInfo.referencedTable);
                                                tuple[3] = DatabaseMetaData.this.s2b(DatabaseMetaData.this.removeQuotedId(referencedColumns.next().toString()));
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                tuple[8] = Integer.toString(keySeq).getBytes();
                                                int[] actions = DatabaseMetaData.this.getForeignKeyActions(keys);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                tuple[9] = Integer.toString(actions[1]).getBytes();
                                                tuple[10] = Integer.toString(actions[0]).getBytes();
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                tuple[11] = null;
                                                tuple[12] = null;
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                                tuple[13] = Integer.toString(7).getBytes();
                                                tuples.add(new ByteArrayRow(tuple, DatabaseMetaData.this.getExceptionInterceptor()));
                                                ++keySeq;
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            }
                                        }
                                    }
                                    Object var18_17 = null;
                                    if (fkresults == null) break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var18_18 = null;
                                    if (fkresults != null) {
                                        try {
                                            fkresults.close();
                                        }
                                        catch (Exception sqlEx) {
                                            AssertionFailedException.shouldNotHappen(sqlEx);
                                        }
                                        fkresults = null;
                                    }
                                    throw throwable;
                                }
                                try {
                                    fkresults.close();
                                }
                                catch (Exception sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                fkresults = null;
                                {
                                }
                            }
                        }
                    }.doForAll();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    Object var11_10 = null;
                    if (stmt == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                stmt.close();
            }
        }
        ResultSet results = this.buildResultSet(fields, tuples);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return results;
    }

    protected Field[] createFkMetadataFields() {
        Field[] fields = new Field[14];
        fields[0] = new Field("", "PKTABLE_CAT", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[1] = new Field("", "PKTABLE_SCHEM", 1, 0);
        fields[2] = new Field("", "PKTABLE_NAME", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[3] = new Field("", "PKCOLUMN_NAME", 1, 32);
        fields[4] = new Field("", "FKTABLE_CAT", 1, 255);
        fields[5] = new Field("", "FKTABLE_SCHEM", 1, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[6] = new Field("", "FKTABLE_NAME", 1, 255);
        fields[7] = new Field("", "FKCOLUMN_NAME", 1, 32);
        fields[8] = new Field("", "KEY_SEQ", 5, 2);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[9] = new Field("", "UPDATE_RULE", 5, 2);
        fields[10] = new Field("", "DELETE_RULE", 5, 2);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[11] = new Field("", "FK_NAME", 1, 0);
        fields[12] = new Field("", "PK_NAME", 1, 0);
        fields[13] = new Field("", "DEFERRABILITY", 5, 2);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return fields;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.getServerMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.getServerMinorVersion();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "GBase";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.getServerVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            return 2;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    @Override
    public int getDriverMinorVersion() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    @Override
    public String getDriverName() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "GBase JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "gbase-connector-java-9.5.0.7-build1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, final String table) throws SQLException {
        if (table == null) {
            throw SQLError.createSQLException("Table not specified.", "S1009", this.getExceptionInterceptor());
        }
        Field[] fields = this.createFkMetadataFields();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        final ArrayList rows = new ArrayList();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.conn.versionMeetsMinimum(8, 0, 0)) return this.buildResultSet(fields, rows);
        final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            new IterateBlock(this.getCatalogIterator(catalog)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void forEach(Object catalogStr) throws SQLException {
                    block10: {
                        ResultSet fkresults = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                fkresults = DatabaseMetaData.this.extractForeignKeyFromCreateTable(catalogStr.toString(), null);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                StringBuffer queryBuf = new StringBuffer("SHOW TABLE STATUS FROM ");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append(catalogStr.toString());
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                fkresults = stmt.executeQuery(queryBuf.toString());
                            }
                            String tableNameWithCase = DatabaseMetaData.this.getTableNameWithCase(table);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            while (fkresults.next()) {
                                String tableType = fkresults.getString("Type");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (tableType == null || !tableType.equalsIgnoreCase("gsdb") && !tableType.equalsIgnoreCase(DatabaseMetaData.SUPPORTS_FK)) continue;
                                String comment = fkresults.getString("Comment").trim();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (comment == null) continue;
                                StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (!commentTokens.hasMoreTokens()) continue;
                                commentTokens.nextToken();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (commentTokens.hasMoreTokens()) {
                                    String keys = commentTokens.nextToken();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    DatabaseMetaData.this.getExportKeyResults(catalogStr.toString(), tableNameWithCase, keys, rows, fkresults.getString("Name"));
                                }
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            Object var9_8 = null;
                            if (fkresults == null) break block10;
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (fkresults != null) {
                                try {
                                    fkresults.close();
                                }
                                catch (SQLException sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                fkresults = null;
                            }
                            throw throwable;
                        }
                        try {
                            fkresults.close();
                        }
                        catch (SQLException sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        fkresults = null;
                        {
                        }
                    }
                }
            }.doForAll();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Object var8_7 = null;
            if (stmt == null) return this.buildResultSet(fields, rows);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return this.buildResultSet(fields, rows);
    }

    private void getExportKeyResults(String catalog, String exportingTable, String keysComment, List tuples, String fkTableName) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.getResultsImpl(catalog, exportingTable, keysComment, tuples, fkTableName, true);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "#@";
    }

    private int[] getForeignKeyActions(String commentString) {
        int[] actions = new int[]{3, 3};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int lastParenIndex = commentString.lastIndexOf(")");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (lastParenIndex != commentString.length() - 1) {
            String cascadeOptions = commentString.substring(lastParenIndex + 1).trim().toUpperCase(Locale.ENGLISH);
            actions[0] = this.getCascadeDeleteOption(cascadeOptions);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            actions[1] = this.getCascadeUpdateOption(cascadeOptions);
        }
        return actions;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn.supportsQuotedIdentifiers()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!this.conn.useAnsiQuotedIdentifiers()) {
                return "`";
            }
            return "\"";
        }
        return " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, final String table) throws SQLException {
        ArrayList rows;
        Field[] fields;
        block5: {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (table == null) {
                throw SQLError.createSQLException("Table not specified.", "S1009", this.getExceptionInterceptor());
            }
            fields = this.createFkMetadataFields();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            rows = new ArrayList();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.conn.versionMeetsMinimum(8, 0, 0)) {
                final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    new IterateBlock(this.getCatalogIterator(catalog)){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        void forEach(Object catalogStr) throws SQLException {
                            block10: {
                                ResultSet fkresults = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                try {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                        fkresults = DatabaseMetaData.this.extractForeignKeyFromCreateTable(catalogStr.toString(), table);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        StringBuffer queryBuf = new StringBuffer("SHOW TABLE STATUS ");
                                        queryBuf.append(" FROM ");
                                        queryBuf.append(DatabaseMetaData.this.quotedId);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        queryBuf.append(catalogStr.toString());
                                        queryBuf.append(DatabaseMetaData.this.quotedId);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        queryBuf.append(" LIKE '");
                                        queryBuf.append(table);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        queryBuf.append("'");
                                        fkresults = stmt.executeQuery(queryBuf.toString());
                                    }
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    while (fkresults.next()) {
                                        String tableType = fkresults.getString("Type");
                                        if (tableType == null || !tableType.equalsIgnoreCase("gsdb") && !tableType.equalsIgnoreCase(DatabaseMetaData.SUPPORTS_FK)) continue;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        String comment = fkresults.getString("Comment").trim();
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (comment == null) continue;
                                        StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (!commentTokens.hasMoreTokens()) continue;
                                        commentTokens.nextToken();
                                        while (commentTokens.hasMoreTokens()) {
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            String keys = commentTokens.nextToken();
                                            DatabaseMetaData.this.getImportKeyResults(catalogStr.toString(), table, keys, rows);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        }
                                    }
                                    Object var8_7 = null;
                                    if (fkresults == null) break block10;
                                }
                                catch (Throwable throwable) {
                                    Object var8_8 = null;
                                    if (fkresults != null) {
                                        try {
                                            fkresults.close();
                                        }
                                        catch (SQLException sqlEx) {
                                            AssertionFailedException.shouldNotHappen(sqlEx);
                                        }
                                        fkresults = null;
                                    }
                                    throw throwable;
                                }
                                try {
                                    fkresults.close();
                                }
                                catch (SQLException sqlEx) {
                                    AssertionFailedException.shouldNotHappen(sqlEx);
                                }
                                fkresults = null;
                                {
                                }
                            }
                        }
                    }.doForAll();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    Object var8_7 = null;
                    if (stmt == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                stmt.close();
            }
        }
        ResultSet results = this.buildResultSet(fields, rows);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return results;
    }

    private void getImportKeyResults(String catalog, String importingTable, String keysComment, List tuples) throws SQLException {
        this.getResultsImpl(catalog, importingTable, keysComment, tuples, null, false);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, final String table, final boolean unique, boolean approximate) throws SQLException {
        ResultSet resultSet;
        block2: {
            Field[] fields = this.createIndexInfoFields();
            final ArrayList rows = new ArrayList();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                new IterateBlock(this.getCatalogIterator(catalog)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void forEach(Object catalogStr) throws SQLException {
                        block13: {
                            ResultSet results = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            try {
                                block12: {
                                    StringBuffer queryBuf = new StringBuffer("SHOW INDEX FROM ");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    queryBuf.append(DatabaseMetaData.this.quotedId);
                                    queryBuf.append(table);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    queryBuf.append(DatabaseMetaData.this.quotedId);
                                    queryBuf.append(" FROM ");
                                    queryBuf.append(DatabaseMetaData.this.quotedId);
                                    queryBuf.append(catalogStr.toString());
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    queryBuf.append(DatabaseMetaData.this.quotedId);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    try {
                                        results = stmt.executeQuery(queryBuf.toString());
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    catch (SQLException sqlEx) {
                                        int errorCode = sqlEx.getErrorCode();
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if ("42S02".equals(sqlEx.getSQLState()) || errorCode == 1146) break block12;
                                        throw sqlEx;
                                    }
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (results != null && results.next()) {
                                    byte[][] row = new byte[14][];
                                    row[0] = catalogStr.toString() == null ? new byte[]{} : DatabaseMetaData.this.s2b(catalogStr.toString());
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    row[1] = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    row[2] = results.getBytes("Table");
                                    boolean indexIsUnique = results.getInt("Non_unique") == 0;
                                    row[3] = !indexIsUnique ? DatabaseMetaData.this.s2b("true") : DatabaseMetaData.this.s2b("false");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    row[4] = new byte[0];
                                    row[5] = results.getBytes("Key_name");
                                    row[6] = Integer.toString(3).getBytes();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    row[7] = results.getBytes("Seq_in_index");
                                    row[8] = results.getBytes("Column_name");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    row[9] = results.getBytes("Collation");
                                    long cardinality = results.getLong("Cardinality");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (!Util.isJdbc42() && cardinality > Integer.MAX_VALUE) {
                                        cardinality = Integer.MAX_VALUE;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    row[10] = DatabaseMetaData.this.s2b(String.valueOf(cardinality));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    row[11] = DatabaseMetaData.this.s2b("0");
                                    row[12] = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (unique) {
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (indexIsUnique) {
                                            rows.add(new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                        }
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        continue;
                                    }
                                    rows.add(new ByteArrayRow(row, DatabaseMetaData.this.getExceptionInterceptor()));
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                Object var9_8 = null;
                                if (results == null) break block13;
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                if (results != null) {
                                    try {
                                        results.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    results = null;
                                }
                                throw throwable;
                            }
                            try {
                                results.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            results = null;
                            {
                            }
                        }
                    }
                }.doForAll();
                ResultSet indexInfo = this.buildResultSet(fields, rows);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                resultSet = indexInfo;
                Object var12_11 = null;
                if (stmt == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var12_12 = null;
                    if (stmt == null) break block3;
                    stmt.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        return resultSet;
    }

    protected Field[] createIndexInfoFields() {
        Field[] fields = new Field[13];
        fields[0] = new Field("", "TABLE_CAT", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[1] = new Field("", "TABLE_SCHEM", 1, 0);
        fields[2] = new Field("", "TABLE_NAME", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[3] = new Field("", "NON_UNIQUE", 16, 4);
        fields[4] = new Field("", "INDEX_QUALIFIER", 1, 1);
        fields[5] = new Field("", "INDEX_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[6] = new Field("", "TYPE", 5, 32);
        fields[7] = new Field("", "ORDINAL_POSITION", 5, 5);
        fields[8] = new Field("", "COLUMN_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[9] = new Field("", "ASC_OR_DESC", 1, 1);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (Util.isJdbc42()) {
            fields[10] = new Field("", "CARDINALITY", -5, 20);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[11] = new Field("", "PAGES", -5, 20);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            fields[10] = new Field("", "CARDINALITY", 4, 20);
            fields[11] = new Field("", "PAGES", 4, 10);
        }
        fields[12] = new Field("", "FILTER_CONDITION", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return fields;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0xFFFFF8;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 32;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0xFFFFF8;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 64;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 64;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 256;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 512;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 64;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 256;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0x7FFFFFF7;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return GBaseIO.getMaxBuf() - 4;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 256;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 16;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, final String table) throws SQLException {
        ArrayList rows;
        Field[] fields;
        block4: {
            fields = new Field[6];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[0] = new Field("", "TABLE_CAT", 1, 255);
            fields[1] = new Field("", "TABLE_SCHEM", 1, 0);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[2] = new Field("", "TABLE_NAME", 1, 255);
            fields[3] = new Field("", "COLUMN_NAME", 1, 32);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            fields[4] = new Field("", "KEY_SEQ", 5, 5);
            fields[5] = new Field("", "PK_NAME", 1, 32);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (table == null) {
                throw SQLError.createSQLException("Table not specified.", "S1009", this.getExceptionInterceptor());
            }
            rows = new ArrayList();
            final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                new IterateBlock(this.getCatalogIterator(catalog)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void forEach(Object catalogStr) throws SQLException {
                        block8: {
                            ResultSet rs = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            try {
                                StringBuffer queryBuf = new StringBuffer("SHOW KEYS FROM ");
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(table);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append(" FROM ");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                queryBuf.append(catalogStr.toString());
                                queryBuf.append(DatabaseMetaData.this.quotedId);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                rs = stmt.executeQuery(queryBuf.toString());
                                TreeMap<String, byte[][]> sortMap = new TreeMap<String, byte[][]>();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (rs.next()) {
                                    String keyType = rs.getString("Key_name");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (keyType == null || !keyType.equalsIgnoreCase("PRIMARY") && !keyType.equalsIgnoreCase("PRI")) continue;
                                    byte[][] tuple = new byte[6][];
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    tuple[0] = catalogStr.toString() == null ? new byte[]{} : DatabaseMetaData.this.s2b(catalogStr.toString());
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    tuple[1] = null;
                                    tuple[2] = DatabaseMetaData.this.s2b(table);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    String columnName = rs.getString("Column_name");
                                    tuple[3] = DatabaseMetaData.this.s2b(columnName);
                                    tuple[4] = DatabaseMetaData.this.s2b(rs.getString("Seq_in_index"));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    tuple[5] = DatabaseMetaData.this.s2b(keyType);
                                    sortMap.put(columnName, tuple);
                                }
                                Iterator sortedIterator = sortMap.values().iterator();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (sortedIterator.hasNext()) {
                                    rows.add(new ByteArrayRow((byte[][])sortedIterator.next(), DatabaseMetaData.this.getExceptionInterceptor()));
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                                Object var9_8 = null;
                                if (rs == null) break block8;
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    rs = null;
                                }
                                throw throwable;
                            }
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            rs = null;
                            {
                            }
                        }
                    }
                }.doForAll();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var8_7 = null;
                if (stmt == null) break block4;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        ResultSet results = this.buildResultSet(fields, rows);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return results;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Field[] fields = this.createProcedureColumnsFields();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getProcedureOrFunctionColumns(fields, catalog, schemaPattern, procedureNamePattern, columnNamePattern, true, true);
    }

    protected Field[] createProcedureColumnsFields() {
        Field[] fields = new Field[13];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[0] = new Field("", "PROCEDURE_CAT", 1, 0);
        fields[1] = new Field("", "PROCEDURE_SCHEM", 1, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[2] = new Field("", "PROCEDURE_NAME", 1, 0);
        fields[3] = new Field("", "COLUMN_NAME", 1, 0);
        fields[4] = new Field("", "COLUMN_TYPE", 1, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[5] = new Field("", "DATA_TYPE", 5, 0);
        fields[6] = new Field("", "TYPE_NAME", 1, 0);
        fields[7] = new Field("", "PRECISION", 4, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[8] = new Field("", "LENGTH", 4, 0);
        fields[9] = new Field("", "SCALE", 5, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[10] = new Field("", "RADIX", 5, 0);
        fields[11] = new Field("", "NULLABLE", 5, 0);
        fields[12] = new Field("", "REMARKS", 1, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getProcedureOrFunctionColumns(Field[] fields, String catalog, String schemaPattern, String procedureOrFunctionNamePattern, String columnNamePattern, boolean returnProcedures, boolean returnFunctions) throws SQLException {
        ArrayList<String> proceduresToExtractList = new ArrayList<String>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.supportsStoredProcedures()) {
            SQLException rethrowSqlEx2;
            block18: {
                ResultSet procedureNameRs = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    procedureNameRs = this.getProceduresAndOrFunctions(this.createFieldMetadataForGetProcedures(), catalog, schemaPattern, procedureOrFunctionNamePattern, returnProcedures, returnFunctions);
                    StringBuilder tmpstrPNameRs = null;
                    StringBuilder tmpstrCatNameRs = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    while (procedureNameRs.next()) {
                        tmpstrCatNameRs = new StringBuilder(procedureNameRs.getString(1));
                        tmpstrPNameRs = new StringBuilder(procedureNameRs.getString(3));
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (!(tmpstrCatNameRs.toString().startsWith(this.quotedId) && tmpstrCatNameRs.toString().endsWith(this.quotedId) || tmpstrCatNameRs.toString().startsWith("\"") && tmpstrCatNameRs.toString().endsWith("\""))) {
                            tmpstrCatNameRs.insert(0, this.quotedId).append(this.quotedId);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        if (!(tmpstrPNameRs.toString().startsWith(this.quotedId) && tmpstrPNameRs.toString().endsWith(this.quotedId) || tmpstrPNameRs.toString().startsWith("\"") && tmpstrPNameRs.toString().endsWith("\""))) {
                            tmpstrPNameRs.insert(0, this.quotedId).append(this.quotedId);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        if (proceduresToExtractList.indexOf(tmpstrCatNameRs + "." + tmpstrPNameRs) >= 0) continue;
                        proceduresToExtractList.add(tmpstrCatNameRs + "." + tmpstrPNameRs);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    Collections.sort(proceduresToExtractList);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    Object var13_13 = null;
                    rethrowSqlEx2 = null;
                    if (procedureNameRs == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    SQLException rethrowSqlEx2 = null;
                    if (procedureNameRs != null) {
                        try {
                            procedureNameRs.close();
                        }
                        catch (SQLException sqlEx) {
                            rethrowSqlEx2 = sqlEx;
                        }
                    }
                    if (rethrowSqlEx2 != null) {
                        throw rethrowSqlEx2;
                    }
                    throw throwable;
                }
                try {
                    procedureNameRs.close();
                }
                catch (SQLException sqlEx) {
                    rethrowSqlEx2 = sqlEx;
                }
            }
            if (rethrowSqlEx2 != null) {
                throw rethrowSqlEx2;
            }
        }
        ArrayList resultRows = new ArrayList();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int idx = 0;
        String procNameToCall = "";
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Iterator iter = proceduresToExtractList.iterator();
        while (iter.hasNext()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String procName = (String)iter.next();
            if (!" ".equals(this.quotedId)) {
                idx = StringUtils.indexOfIgnoreCase(0, procName, ".", this.quotedId, this.quotedId, this.conn.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__COM_WS : StringUtils.SEARCH_MODE__ALL);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                idx = procName.indexOf(".");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (idx > 0) {
                catalog = procName.substring(0, idx);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.quotedId != " " && catalog.startsWith(this.quotedId) && catalog.endsWith(this.quotedId)) {
                    catalog = procName.substring(1, catalog.length() - 1);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                procNameToCall = procName;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                procNameToCall = procName;
            }
            this.getCallStmtParameterTypes(catalog, procNameToCall, columnNamePattern, resultRows, fields.length == 17);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return this.buildResultSet(fields, resultRows);
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Field[] fields = this.createFieldMetadataForGetProcedures();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getProceduresAndOrFunctions(fields, catalog, schemaPattern, procedureNamePattern, true, true);
    }

    private Field[] createFieldMetadataForGetProcedures() {
        Field[] fields = new Field[9];
        fields[0] = new Field("", "PROCEDURE_CAT", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[1] = new Field("", "PROCEDURE_SCHEM", 1, 255);
        fields[2] = new Field("", "PROCEDURE_NAME", 1, 255);
        fields[3] = new Field("", "reserved1", 1, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[4] = new Field("", "reserved2", 1, 0);
        fields[5] = new Field("", "reserved3", 1, 0);
        fields[6] = new Field("", "REMARKS", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[7] = new Field("", "PROCEDURE_TYPE", 5, 6);
        fields[8] = new Field("", "SPECIFIC_NAME", 1, 255);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return fields;
    }

    protected ResultSet getProceduresAndOrFunctions(final Field[] fields, String catalog, String schemaPattern, String procedureNamePattern, final boolean returnProcedures, final boolean returnFunctions) throws SQLException {
        if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.conn.getNullNamePatternMatchesAll()) {
                procedureNamePattern = "%";
            } else {
                throw SQLError.createSQLException("Procedure name pattern can not be NULL or empty.", "S1009", this.getExceptionInterceptor());
            }
        }
        String quoteChar = "`";
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (catalog != null) {
            catalog = catalog.replace(quoteChar, "");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        procedureNamePattern = procedureNamePattern.replace(quoteChar, "");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ArrayList procedureRows = new ArrayList();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        final ArrayList procedureRowsToSort = new ArrayList();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.supportsStoredProcedures()) {
            final String procNamePattern = procedureNamePattern;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            new IterateBlock(this.getCatalogIterator(catalog)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                void forEach(Object catalogStr) throws SQLException {
                    Exception rethrowSqlEx2222;
                    String db = catalogStr.toString().toLowerCase();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    boolean fromSelect = false;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    ResultSet proceduresRs = null;
                    boolean needsClientFiltering = true;
                    PreparedStatement proceduresStmt = null;
                    String sysDataBaseName = SystemDataBase.getSystemDataBaseName(DatabaseMetaData.this.conn);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if ("system".equals(sysDataBaseName)) {
                        proceduresStmt = DatabaseMetaData.this.conn.clientPrepareStatement("SELECT name, type, comment FROM system.proc WHERE name like ? and db <=> ? ORDER BY name");
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        proceduresStmt = DatabaseMetaData.this.conn.clientPrepareStatement("SELECT trim(ROUTINE_NAME) name, trim(ROUTINE_TYPE) type, trim(ROUTINE_COMMENT) comment FROM information_schema.ROUTINES  WHERE trim(ROUTINE_NAME) like ? and trim(ROUTINE_SCHEMA) <=> ? ORDER BY name");
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        block33: {
                            boolean hasTypeColumn = false;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (db != null) {
                                proceduresStmt.setString(2, db);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                proceduresStmt.setNull(2, 12);
                            }
                            int nameIndex = 1;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (proceduresStmt.getMaxRows() != 0) {
                                proceduresStmt.setMaxRows(0);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            proceduresStmt.setString(1, procNamePattern);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            proceduresRs = proceduresStmt.executeQuery();
                            fromSelect = true;
                            needsClientFiltering = false;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            hasTypeColumn = true;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            DatabaseMetaData.this.useProceduresRs(returnProcedures, fromSelect, db, proceduresRs, needsClientFiltering, procedureRowsToSort, nameIndex, hasTypeColumn, proceduresStmt, procNamePattern, returnFunctions, fields);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            Object var12_10 = null;
                            try {
                                if (proceduresRs != null) {
                                    proceduresRs.close();
                                }
                                break block33;
                            }
                            catch (Exception exception) {}
                            break block33;
                            {
                                catch (SQLException sqlEx) {
                                    proceduresStmt.close();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    fromSelect = false;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                        nameIndex = 2;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        nameIndex = 1;
                                    }
                                    proceduresStmt = DatabaseMetaData.this.conn.clientPrepareStatement("SHOW PROCEDURE STATUS LIKE ?");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (proceduresStmt.getMaxRows() != 0) {
                                        proceduresStmt.setMaxRows(0);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    proceduresStmt.setString(1, procNamePattern);
                                    proceduresRs = proceduresStmt.executeQuery();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    DatabaseMetaData.this.useProceduresRs(returnProcedures, fromSelect, db, proceduresRs, needsClientFiltering, procedureRowsToSort, nameIndex, hasTypeColumn, proceduresStmt, procNamePattern, returnFunctions, fields);
                                    Object var12_11 = null;
                                    try {
                                        if (proceduresRs != null) {
                                            proceduresRs.close();
                                        }
                                        break block33;
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            catch (Throwable throwable) {
                                Object var12_12 = null;
                                try {
                                    if (proceduresRs != null) {
                                        proceduresRs.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        Object var15_18 = null;
                        rethrowSqlEx2222 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_19 = null;
                        Exception rethrowSqlEx2222 = null;
                        try {
                            if (proceduresRs != null) {
                                proceduresRs.close();
                            }
                        }
                        catch (Exception sqlEx) {
                            rethrowSqlEx2222 = sqlEx;
                        }
                        try {
                            if (proceduresStmt != null) {
                                proceduresStmt.close();
                            }
                        }
                        catch (Exception sqlEx) {
                            rethrowSqlEx2222 = sqlEx;
                        }
                        if (rethrowSqlEx2222 != null) {
                            throw new SQLException(rethrowSqlEx2222);
                        }
                        throw throwable;
                    }
                    try {
                        if (proceduresRs != null) {
                            proceduresRs.close();
                        }
                    }
                    catch (Exception sqlEx) {
                        rethrowSqlEx2222 = sqlEx;
                    }
                    try {
                        if (proceduresStmt != null) {
                            proceduresStmt.close();
                        }
                    }
                    catch (Exception sqlEx) {
                        rethrowSqlEx2222 = sqlEx;
                    }
                    if (rethrowSqlEx2222 != null) {
                        throw new SQLException(rethrowSqlEx2222);
                    }
                }
            }.doForAll();
            Collections.sort(procedureRowsToSort);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (ComparableWrapper procRow : procedureRowsToSort) {
                procedureRows.add(procRow.getValue());
            }
        }
        return this.buildResultSet(fields, procedureRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void useProceduresRs(boolean returnProcedures, boolean fromSelect, String db, ResultSet proceduresRs, boolean needsClientFiltering, List<ComparableWrapper<String, ResultSetRow>> procedureRowsToSort, int nameIndex, boolean hasTypeColumn, PreparedStatement proceduresStmt, String procNamePattern, boolean returnFunctions, Field[] fields) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (returnProcedures) {
            this.convertToJdbcProcedureList(fromSelect, db, proceduresRs, needsClientFiltering, db, procedureRowsToSort, nameIndex);
        }
        if (!hasTypeColumn) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (proceduresStmt != null) {
                proceduresStmt.close();
            }
            proceduresStmt = this.conn.clientPrepareStatement("SHOW FUNCTION STATUS LIKE ?");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (proceduresStmt.getMaxRows() != 0) {
                proceduresStmt.setMaxRows(0);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            proceduresStmt.setString(1, procNamePattern);
            try {
                proceduresRs = proceduresStmt.executeQuery();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (returnFunctions) {
                    this.convertToJdbcFunctionList(db, proceduresRs, needsClientFiltering, db, procedureRowsToSort, nameIndex, fields);
                }
                Object var14_13 = null;
                if (proceduresRs == null) return;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (proceduresRs == null) throw throwable;
                try {
                    proceduresRs.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                proceduresRs.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!returnFunctions) return;
        this.convertToJdbcFunctionList(db, proceduresRs, needsClientFiltering, db, procedureRowsToSort, nameIndex, fields);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "PROCEDURE";
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 1;
    }

    private void getResultsImpl(String catalog, String table, String keysComment, List tuples, String fkTableName, boolean isExport) throws SQLException {
        LocalAndReferencedColumns parsedInfo = this.parseTableStatusIntoLocalAndReferencedColumns(keysComment);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (isExport && !parsedInfo.referencedTable.equals(table)) {
            return;
        }
        if (parsedInfo.localColumnsList.size() != parsedInfo.referencedColumnsList.size()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw SQLError.createSQLException("Error parsing foreign keys definition,number of local and referenced columns is not the same.", "S1000", this.getExceptionInterceptor());
        }
        Iterator localColumnNames = parsedInfo.localColumnsList.iterator();
        Iterator referColumnNames = parsedInfo.referencedColumnsList.iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int keySeqIndex = 1;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (localColumnNames.hasNext()) {
            byte[][] tuple = new byte[14][];
            String lColumnName = this.removeQuotedId(localColumnNames.next().toString());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String rColumnName = this.removeQuotedId(referColumnNames.next().toString());
            tuple[4] = catalog == null ? new byte[]{} : this.s2b(catalog);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            tuple[5] = null;
            tuple[6] = this.s2b(isExport ? fkTableName : table);
            tuple[7] = this.s2b(lColumnName);
            tuple[0] = this.s2b(parsedInfo.referencedCatalog);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            tuple[1] = null;
            tuple[2] = this.s2b(isExport ? table : parsedInfo.referencedTable);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            tuple[3] = this.s2b(rColumnName);
            tuple[8] = this.s2b(Integer.toString(keySeqIndex++));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            int[] actions = this.getForeignKeyActions(keysComment);
            tuple[9] = this.s2b(Integer.toString(actions[1]));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            tuple[10] = this.s2b(Integer.toString(actions[0]));
            tuple[11] = this.s2b(parsedInfo.constraintName);
            tuple[12] = null;
            tuple[13] = this.s2b(Integer.toString(7));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            tuples.add(new ByteArrayRow(tuple, this.getExceptionInterceptor()));
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_CATALOG", 1, 0)};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ArrayList tuples = new ArrayList();
        ResultSet results = this.buildResultSet(fields, tuples);
        return results;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "\\";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return gbaseKeywordsThatArentSQL92;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.conn.versionMeetsMinimum(8, 0, 0)) {
            return 2;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.conn.getUseSqlStateCodes()) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,BIN,BIT_LENGTH,CHAR,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONV,ELT,EXPORT_SET,FIELD,FIND_IN_SET,HEX,INSERT,INSTR,LCASE,LEFT,LENGTH,LOAD_FILE,LOCATE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH,MID,OCT,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SPACE,STRCMP,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    @Override
    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[4];
        fields[0] = new Field("", "TABLE_CAT", 1, 32);
        fields[1] = new Field("", "TABLE_SCHEM", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[2] = new Field("", "TABLE_NAME", 1, 32);
        fields[3] = new Field("", "SUPERTABLE_NAME", 1, 32);
        return this.buildResultSet(fields, new ArrayList());
    }

    @Override
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[6];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[0] = new Field("", "TYPE_CAT", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[1] = new Field("", "TYPE_SCHEM", 1, 32);
        fields[2] = new Field("", "TYPE_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[3] = new Field("", "SUPERTYPE_CAT", 1, 32);
        fields[4] = new Field("", "SUPERTYPE_SCHEM", 1, 32);
        fields[5] = new Field("", "SUPERTYPE_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.buildResultSet(fields, new ArrayList());
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    private String getTableNameWithCase(String table) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String tableNameWithCase = this.conn.lowerCaseTableNames() ? table.toLowerCase() : table;
        return tableNameWithCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList<ByteArrayRow> grantRows;
        Field[] fields;
        block32: {
            Exception exception4;
            java.sql.Statement stmt;
            block29: {
                if (tableNamePattern == null) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (this.conn.getNullNamePatternMatchesAll()) {
                        tableNamePattern = "%";
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        throw SQLError.createSQLException("Table name pattern can not be NULL or empty.", "S1009", this.getExceptionInterceptor());
                    }
                }
                fields = new Field[7];
                fields[0] = new Field("", "TABLE_CAT", 1, 64);
                fields[1] = new Field("", "TABLE_SCHEM", 1, 1);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fields[2] = new Field("", "TABLE_NAME", 1, 64);
                fields[3] = new Field("", "GRANTOR", 1, 77);
                fields[4] = new Field("", "GRANTEE", 1, 77);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fields[5] = new Field("", "PRIVILEGE", 1, 64);
                fields[6] = new Field("", "IS_GRANTABLE", 1, 3);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                StringBuffer grantQuery = null;
                String sysDataBaseName = SystemDataBase.getSystemDataBaseName(this.conn);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if ("system".equals(sysDataBaseName)) {
                    grantQuery = new StringBuffer("SELECT host,db,table_name,grantor,user,table_priv from system.tables_priv ");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    grantQuery = new StringBuffer("SELECT trim(host) host,trim(db) db,trim(table_name) table_name, trim(grantor) grantor, trim(user) user,trim(table_priv) table_priv from gbase.tables_priv ");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                grantQuery.append(" WHERE ");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (catalog != null && catalog.length() != 0) {
                    grantQuery.append(" db='");
                    grantQuery.append(catalog);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    grantQuery.append("' AND ");
                }
                grantQuery.append(" trim(table_name) like '");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                grantQuery.append(tableNamePattern);
                grantQuery.append("'");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                ResultSet results = null;
                grantRows = new ArrayList<ByteArrayRow>();
                stmt = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    stmt = this.conn.createStatement();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    stmt.setEscapeProcessing(false);
                    results = stmt.executeQuery(grantQuery.toString());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    while (results.next()) {
                        String host = results.getString(1);
                        String db = results.getString(2);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String table = results.getString(3);
                        String grantor = results.getString(4);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String user = results.getString(5);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (user == null || user.length() == 0) {
                            user = "%";
                        }
                        StringBuffer fullUser = new StringBuffer(user);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (host != null && this.conn.getUseHostsInPrivileges()) {
                            fullUser.append("@");
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            fullUser.append(host);
                        }
                        String allPrivileges = results.getString(6);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (allPrivileges == null) continue;
                        allPrivileges = allPrivileges.toUpperCase(Locale.ENGLISH);
                        StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        while (st.hasMoreTokens()) {
                            Exception exception22;
                            Object var22_21;
                            String privilege = st.nextToken().trim();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            ResultSet columnResults = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            try {
                                columnResults = this.getColumns(catalog, schemaPattern, table, "%");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (columnResults.next()) {
                                    byte[][] tuple = new byte[8][];
                                    tuple[0] = this.s2b(db);
                                    tuple[1] = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    tuple[2] = this.s2b(table);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (grantor != null) {
                                        tuple[3] = this.s2b(grantor);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        tuple[3] = null;
                                    }
                                    tuple[4] = this.s2b(fullUser.toString());
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    tuple[5] = this.s2b(privilege);
                                    tuple[6] = null;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    grantRows.add(new ByteArrayRow(tuple, this.getExceptionInterceptor()));
                                }
                                var22_21 = null;
                                if (columnResults == null) continue;
                            }
                            catch (Throwable throwable) {
                                var22_21 = null;
                                if (columnResults != null) {
                                    try {
                                        columnResults.close();
                                    }
                                    catch (Exception exception22) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                columnResults.close();
                            }
                            catch (Exception exception22) {}
                        }
                    }
                    Object var25_24 = null;
                    if (results == null) break block29;
                }
                catch (Throwable throwable) {
                    Exception exception32;
                    Object var25_25 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception exception32) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception32) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    results.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                results = null;
            }
            if (stmt == null) break block32;
            try {
                stmt.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
            stmt = null;
            {
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.buildResultSet(fields, grantRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, final String[] types) throws SQLException {
        if (tableNamePattern == null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!this.conn.getNullNamePatternMatchesAll()) throw SQLError.createSQLException("Table name pattern can not be NULL or empty.", "S1009", this.getExceptionInterceptor());
            tableNamePattern = "%";
        }
        Field[] fields = new Field[5];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[0] = new Field("", "TABLE_CAT", 12, 255);
        fields[1] = new Field("", "TABLE_SCHEM", 12, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[2] = new Field("", "TABLE_NAME", 12, 255);
        fields[3] = new Field("", "TABLE_TYPE", 12, 5);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[4] = new Field("", "REMARKS", 12, 0);
        final ArrayList tuples = new ArrayList();
        final java.sql.Statement stmt = this.conn.getMetadataSafeStatement();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        final String tableNamePat = tableNamePattern;
        final boolean operatingOnInformationSchema = "information_schema".equalsIgnoreCase(catalog);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            new IterateBlock(this.getCatalogIterator(catalog)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void forEach(Object catalogStr) throws SQLException {
                    block53: {
                        ResultSet results = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            if (!DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                try {
                                    results = stmt.executeQuery("SHOW TABLES FROM " + DatabaseMetaData.this.quotedId + catalogStr.toString() + DatabaseMetaData.this.quotedId + " LIKE '" + tableNamePat + "'");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                                catch (SQLException sqlEx) {
                                    if ("08S01".equals(sqlEx.getSQLState())) {
                                        throw sqlEx;
                                    }
                                    Object var14_6 = null;
                                    if (results != null) {
                                        try {
                                            results.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        results = null;
                                    }
                                    return;
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                try {
                                    results = stmt.executeQuery("SHOW FULL TABLES FROM " + DatabaseMetaData.this.quotedId + catalogStr.toString() + DatabaseMetaData.this.quotedId + " LIKE '" + tableNamePat + "'");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                                catch (SQLException sqlEx) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if ("08S01".equals(sqlEx.getSQLState())) {
                                        throw sqlEx;
                                    }
                                    Object var14_7 = null;
                                    if (results != null) {
                                        try {
                                            results.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        results = null;
                                    }
                                    return;
                                }
                            }
                            boolean shouldReportTables = false;
                            boolean shouldReportViews = false;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            boolean shouldReportSystemTables = false;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (types == null || types.length == 0) {
                                shouldReportTables = true;
                                shouldReportViews = true;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                shouldReportSystemTables = true;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                for (int i = 0; i < types.length; ++i) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if ("TABLE".equalsIgnoreCase(types[i])) {
                                        shouldReportTables = true;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    if ("VIEW".equalsIgnoreCase(types[i])) {
                                        shouldReportViews = true;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    if (!"SYSTEM TABLE".equalsIgnoreCase(types[i])) continue;
                                    shouldReportSystemTables = true;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                            }
                            int typeColumnIndex = 0;
                            boolean hasTableTypes = false;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (DatabaseMetaData.this.conn.versionMeetsMinimum(8, 0, 0)) {
                                try {
                                    typeColumnIndex = results.findColumn("table_type");
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    hasTableTypes = true;
                                }
                                catch (SQLException sqlEx) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    try {
                                        typeColumnIndex = results.findColumn("Type");
                                        hasTableTypes = true;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                    catch (SQLException sqlEx2) {
                                        hasTableTypes = false;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    }
                                }
                            }
                            TreeMap<String, byte[][]> tablesOrderedByName = null;
                            TreeMap<String, byte[][]> viewsOrderedByName = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            while (results.next()) {
                                byte[][] row = new byte[5][];
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                row[0] = catalogStr.toString() == null ? null : DatabaseMetaData.this.s2b(catalogStr.toString());
                                row[1] = null;
                                row[2] = results.getBytes(1);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                row[4] = new byte[0];
                                if (hasTableTypes) {
                                    String tableType = results.getString(typeColumnIndex);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (("table".equalsIgnoreCase(tableType) || "base table".equalsIgnoreCase(tableType)) && shouldReportTables || "system view".equalsIgnoreCase(tableType) && !shouldReportSystemTables) {
                                        boolean reportTable = false;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (!operatingOnInformationSchema && shouldReportTables) {
                                            row[3] = TABLE_AS_BYTES;
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            reportTable = true;
                                        } else if (operatingOnInformationSchema && shouldReportSystemTables) {
                                            row[3] = SYSTEM_TABLE_AS_BYTES;
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            reportTable = true;
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        } else {
                                            row[3] = TABLE_AS_BYTES;
                                            reportTable = true;
                                        }
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (reportTable) {
                                            if (tablesOrderedByName == null) {
                                                tablesOrderedByName = new TreeMap();
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            }
                                            tablesOrderedByName.put(results.getString(1), row);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        }
                                    } else if ("system view".equalsIgnoreCase(tableType) && shouldReportSystemTables) {
                                        row[3] = SYSTEM_TABLE_AS_BYTES;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (tablesOrderedByName == null) {
                                            tablesOrderedByName = new TreeMap();
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        }
                                        tablesOrderedByName.put(results.getString(1), row);
                                    } else if ("view".equalsIgnoreCase(tableType) && shouldReportViews) {
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        row[3] = VIEW_AS_BYTES;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (viewsOrderedByName == null) {
                                            viewsOrderedByName = new TreeMap<String, byte[][]>();
                                        }
                                        viewsOrderedByName.put(results.getString(1), row);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else if (!hasTableTypes) {
                                        row[3] = TABLE_AS_BYTES;
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (tablesOrderedByName == null) {
                                            tablesOrderedByName = new TreeMap();
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        }
                                        tablesOrderedByName.put(results.getString(1), row);
                                    }
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    continue;
                                }
                                if (!shouldReportTables) continue;
                                row[3] = TABLE_AS_BYTES;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (tablesOrderedByName == null) {
                                    tablesOrderedByName = new TreeMap<String, byte[][]>();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                                tablesOrderedByName.put(results.getString(1), row);
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (tablesOrderedByName != null) {
                                Iterator tablesIter = tablesOrderedByName.values().iterator();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (tablesIter.hasNext()) {
                                    tuples.add(new ByteArrayRow((byte[][])tablesIter.next(), DatabaseMetaData.this.getExceptionInterceptor()));
                                }
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (viewsOrderedByName != null) {
                                Iterator viewsIter = viewsOrderedByName.values().iterator();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                while (viewsIter.hasNext()) {
                                    tuples.add(new ByteArrayRow((byte[][])viewsIter.next(), DatabaseMetaData.this.getExceptionInterceptor()));
                                }
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            Object var14_8 = null;
                            if (results == null) break block53;
                        }
                        catch (Throwable throwable) {
                            Object var14_9 = null;
                            if (results != null) {
                                try {
                                    results.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                results = null;
                            }
                            throw throwable;
                        }
                        try {
                            results.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        results = null;
                        {
                        }
                    }
                }
            }.doForAll();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Object var11_10 = null;
            if (stmt == null) return this.buildResultSet(fields, tuples);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return this.buildResultSet(fields, tuples);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<ByteArrayRow> tuples = new ArrayList<ByteArrayRow>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] tableTypeRow = new byte[1][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tableTypeRow[0] = TABLE_AS_BYTES;
        tuples.add(new ByteArrayRow(tableTypeRow, this.getExceptionInterceptor()));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        byte[][] sysTableTypeRow = new byte[1][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sysTableTypeRow[0] = SYSTEM_TABLE_AS_BYTES;
        tuples.add(new ByteArrayRow(sysTableTypeRow, this.getExceptionInterceptor()));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.conn.versionMeetsMinimum(8, 0, 0)) {
            byte[][] viewTypeRow = new byte[][]{VIEW_AS_BYTES};
            tuples.add(new ByteArrayRow(viewTypeRow, this.getExceptionInterceptor()));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        byte[][] tempTypeRow = new byte[][]{this.s2b("LOCAL TEMPORARY")};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow(tempTypeRow, this.getExceptionInterceptor()));
        return this.buildResultSet(fields, tuples);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Field[] fields = new Field[18];
        fields[0] = new Field("", "TYPE_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[1] = new Field("", "DATA_TYPE", 4, 5);
        fields[2] = new Field("", "PRECISION", 4, 10);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[3] = new Field("", "LITERAL_PREFIX", 1, 4);
        fields[4] = new Field("", "LITERAL_SUFFIX", 1, 4);
        fields[5] = new Field("", "CREATE_PARAMS", 1, 32);
        fields[6] = new Field("", "NULLABLE", 5, 5);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[7] = new Field("", "CASE_SENSITIVE", 16, 3);
        fields[8] = new Field("", "SEARCHABLE", 5, 3);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[9] = new Field("", "UNSIGNED_ATTRIBUTE", 16, 3);
        fields[10] = new Field("", "FIXED_PREC_SCALE", 16, 3);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[11] = new Field("", "AUTO_INCREMENT", 16, 3);
        fields[12] = new Field("", "LOCAL_TYPE_NAME", 1, 32);
        fields[13] = new Field("", "MINIMUM_SCALE", 5, 5);
        fields[14] = new Field("", "MAXIMUM_SCALE", 5, 5);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[15] = new Field("", "SQL_DATA_TYPE", 4, 10);
        fields[16] = new Field("", "SQL_DATETIME_SUB", 4, 10);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[17] = new Field("", "NUM_PREC_RADIX", 4, 10);
        Object rowVal = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ArrayList<ByteArrayRow> tuples = new ArrayList<ByteArrayRow>();
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIT");
        rowVal[1] = Integer.toString(-7).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("1");
        rowVal[3] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BIT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BOOL");
        rowVal[1] = Integer.toString(-7).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("1");
        rowVal[3] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BOOL");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYINT");
        rowVal[1] = Integer.toString(-6).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("3");
        rowVal[3] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("TINYINT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYINT UNSIGNED");
        rowVal[1] = Integer.toString(-6).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("3");
        rowVal[3] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("TINYINT UNSIGNED");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIGINT");
        rowVal[1] = Integer.toString(-5).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("19");
        rowVal[3] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("BIGINT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIGINT UNSIGNED");
        rowVal[1] = Integer.toString(-5).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("20");
        rowVal[3] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [ZEROFILL]");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("BIGINT UNSIGNED");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONG VARBINARY");
        rowVal[1] = Integer.toString(-4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONG VARBINARY");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("MEDIUMBLOB");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONGBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = Integer.toString(Integer.MAX_VALUE).getBytes();
        rowVal[3] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("LONGBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("BLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("65535");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("BLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("TINYBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("255");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("TINYBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("VARBINARY");
        rowVal[1] = Integer.toString(-3).getBytes();
        rowVal[2] = this.s2b("255");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("VARBINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("BINARY");
        rowVal[1] = Integer.toString(-2).getBytes();
        rowVal[2] = this.s2b("255");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("BINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("LONG VARCHAR");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("16777215");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("LONG VARCHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("MEDIUMTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("16777215");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("MEDIUMTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("LONGTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = Integer.toString(Integer.MAX_VALUE).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("LONGTEXT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("TEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("TEXT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("TINYTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("TINYTEXT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("CHAR");
        rowVal[1] = Integer.toString(1).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("CHAR");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        int decimalPrecision = 254;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.conn.versionMeetsMinimum(8, 0, 0)) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.conn.versionMeetsMinimum(8, 0, 0)) {
                decimalPrecision = 65;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                decimalPrecision = 64;
            }
        }
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("NUMERIC");
        rowVal[1] = Integer.toString(2).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b(String.valueOf(decimalPrecision));
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M[,D])] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("NUMERIC");
        rowVal[13] = this.s2b("-308");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("DECIMAL");
        rowVal[1] = Integer.toString(3).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b(String.valueOf(decimalPrecision));
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M[,D])] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("DECIMAL");
        rowVal[13] = this.s2b("-308");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("INTEGER");
        rowVal[1] = Integer.toString(4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("INTEGER");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("INTEGER UNSIGNED");
        rowVal[1] = Integer.toString(4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("INTEGER UNSIGNED");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("INT");
        rowVal[1] = Integer.toString(4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("INT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("INT UNSIGNED");
        rowVal[1] = Integer.toString(4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("INT UNSIGNED");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("MEDIUMINT");
        rowVal[1] = Integer.toString(4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("7");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("MEDIUMINT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("MEDIUMINT UNSIGNED");
        rowVal[1] = Integer.toString(4).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("8");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("MEDIUMINT UNSIGNED");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("SMALLINT");
        rowVal[1] = Integer.toString(5).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("5");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("SMALLINT");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("SMALLINT UNSIGNED");
        rowVal[1] = Integer.toString(5).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("5");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("SMALLINT UNSIGNED");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("FLOAT");
        rowVal[1] = Integer.toString(7).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("FLOAT");
        rowVal[13] = this.s2b("-38");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("38");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("DOUBLE");
        rowVal[1] = Integer.toString(8).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("DOUBLE");
        rowVal[13] = this.s2b("-308");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("DOUBLE PRECISION");
        rowVal[1] = Integer.toString(8).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("DOUBLE PRECISION");
        rowVal[13] = this.s2b("-308");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("REAL");
        rowVal[1] = Integer.toString(8).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("REAL");
        rowVal[13] = this.s2b("-308");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("VARCHAR");
        rowVal[1] = Integer.toString(12).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("10922");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("VARCHAR");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("ENUM");
        rowVal[1] = Integer.toString(12).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("ENUM");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("SET");
        rowVal[1] = Integer.toString(12).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("64");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("SET");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("DATE");
        rowVal[1] = Integer.toString(91).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("DATE");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("TIME");
        rowVal[1] = Integer.toString(92).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("TIME");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("DATETIME");
        rowVal[1] = Integer.toString(93).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("DATETIME");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        rowVal = new byte[18][];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[0] = this.s2b("TIMESTAMP");
        rowVal[1] = Integer.toString(93).getBytes();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[5] = this.s2b("[(M)]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[12] = this.s2b("TIMESTAMP");
        rowVal[13] = this.s2b("0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        tuples.add(new ByteArrayRow((byte[][])rowVal, this.getExceptionInterceptor()));
        return this.buildResultSet(fields, tuples);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 12, 32), new Field("", "TYPE_SCHEM", 12, 32), new Field("", "TYPE_NAME", 12, 32), new Field("", "CLASS_NAME", 12, 32), new Field("", "DATA_TYPE", 12, 32), new Field("", "REMARKS", 12, 32)};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ArrayList tuples = new ArrayList();
        return this.buildResultSet(fields, tuples);
    }

    @Override
    public String getURL() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.conn.getUseHostsInPrivileges()) {
            Exception ex22;
            String string;
            java.sql.Statement stmt;
            block12: {
                stmt = null;
                ResultSet rs = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    rs = stmt.executeQuery("SELECT USER()");
                    rs.next();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    string = rs.getString(1);
                    Object var5_4 = null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var5_5 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            AssertionFailedException.shouldNotHappen(ex22);
                        }
                        rs = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex22) {
                            AssertionFailedException.shouldNotHappen(ex22);
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    AssertionFailedException.shouldNotHappen(ex22);
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex22) {
                    AssertionFailedException.shouldNotHappen(ex22);
                }
                stmt = null;
            }
            return string;
        }
        return this.conn.getUser();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] fields = new Field[8];
        fields[0] = new Field("", "SCOPE", 5, 5);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[1] = new Field("", "COLUMN_NAME", 1, 32);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[2] = new Field("", "DATA_TYPE", 4, 5);
        fields[3] = new Field("", "TYPE_NAME", 1, 16);
        fields[4] = new Field("", "COLUMN_SIZE", 4, 16);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[5] = new Field("", "BUFFER_LENGTH", 4, 16);
        fields[6] = new Field("", "DECIMAL_DIGITS", 5, 16);
        fields[7] = new Field("", "PSEUDO_COLUMN", 5, 5);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.buildResultSet(fields, new ArrayList());
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.conn.getEmulateLocators();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    private LocalAndReferencedColumns parseTableStatusIntoLocalAndReferencedColumns(String keysComment) throws SQLException {
        String columnsDelimitter = ",";
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        char quoteChar = this.quotedId.length() == 0 ? (char)'\u0000' : this.quotedId.charAt(0);
        int indexOfOpenParenLocalColumns = StringUtils.indexOfIgnoreCase(0, keysComment, "(", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (indexOfOpenParenLocalColumns == -1) {
            throw SQLError.createSQLException("Error parsing foreign keys definition, couldn't find start of local columns list.", "S1000", this.getExceptionInterceptor());
        }
        String constraintName = this.removeQuotedId(keysComment.substring(0, indexOfOpenParenLocalColumns).trim());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        keysComment = keysComment.substring(indexOfOpenParenLocalColumns, keysComment.length());
        String keysCommentTrimmed = keysComment.trim();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int indexOfCloseParenLocalColumns = StringUtils.indexOfIgnoreCase(0, keysCommentTrimmed, ")", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (indexOfCloseParenLocalColumns == -1) {
            throw SQLError.createSQLException("Error parsing foreign keys definition, couldn't find end of local columns list.", "S1000", this.getExceptionInterceptor());
        }
        String localColumnNamesString = keysCommentTrimmed.substring(1, indexOfCloseParenLocalColumns);
        int indexOfRefer = StringUtils.indexOfIgnoreCase(0, keysCommentTrimmed, "REFER ", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (indexOfRefer == -1) {
            throw SQLError.createSQLException("Error parsing foreign keys definition, couldn't find start of referenced tables list.", "S1000", this.getExceptionInterceptor());
        }
        int indexOfOpenParenReferCol = StringUtils.indexOfIgnoreCase(indexOfRefer, keysCommentTrimmed, "(", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__MRK_COM_WS);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (indexOfOpenParenReferCol == -1) {
            throw SQLError.createSQLException("Error parsing foreign keys definition, couldn't find start of referenced columns list.", "S1000", this.getExceptionInterceptor());
        }
        String referCatalogTableString = keysCommentTrimmed.substring(indexOfRefer + "REFER ".length(), indexOfOpenParenReferCol);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int indexOfSlash = StringUtils.indexOfIgnoreCase(0, referCatalogTableString, "/", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__MRK_COM_WS);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (indexOfSlash == -1) {
            throw SQLError.createSQLException("Error parsing foreign keys definition, couldn't find name of referenced catalog.", "S1000", this.getExceptionInterceptor());
        }
        String referCatalog = this.removeQuotedId(referCatalogTableString.substring(0, indexOfSlash));
        String referTable = this.removeQuotedId(referCatalogTableString.substring(indexOfSlash + 1).trim());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int indexOfCloseParenRefer = StringUtils.indexOfIgnoreCase(indexOfOpenParenReferCol, keysCommentTrimmed, ")", this.quotedId, this.quotedId, StringUtils.SEARCH_MODE__ALL);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (indexOfCloseParenRefer == -1) {
            throw SQLError.createSQLException("Error parsing foreign keys definition, couldn't find end of referenced columns list.", "S1000", this.getExceptionInterceptor());
        }
        String referColumnNamesString = keysCommentTrimmed.substring(indexOfOpenParenReferCol + 1, indexOfCloseParenRefer);
        List<String> referColumnsList = StringUtils.split(referColumnNamesString, columnsDelimitter, this.quotedId, this.quotedId, false);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        List<String> localColumnsList = StringUtils.split(localColumnNamesString, columnsDelimitter, this.quotedId, this.quotedId, false);
        return new LocalAndReferencedColumns(localColumnsList, referColumnsList, constraintName, referCatalog, referTable);
    }

    private String removeQuotedId(String s) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (s == null) {
            return null;
        }
        if (this.quotedId.equals("")) {
            return s;
        }
        s = s.trim();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int frontOffset = 0;
        int backOffset = s.length();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int quoteLength = this.quotedId.length();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (s.startsWith(this.quotedId)) {
            frontOffset = quoteLength;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (s.endsWith(this.quotedId)) {
            backOffset -= quoteLength;
        }
        return s.substring(frontOffset, backOffset);
    }

    protected byte[] s2b(String s) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (s == null) {
            return null;
        }
        return StringUtils.getBytes(s, this.conn.getCharacterSetMetadata(), this.conn.getServerCharacterEncoding(), this.conn.parserKnowsUnicode(), this.conn, this.getExceptionInterceptor());
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.conn.storesLowerCaseTableName();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (fromType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.getOverrideSupportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.conn.lowerCaseTableNames();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.conn.lowerCaseTableNames();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1004: {
                if (concurrency == 1007 || concurrency == 1008) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    return true;
                }
                throw SQLError.createSQLException("Illegal arguments to supportsResultSetConcurrency()", "S1009", this.getExceptionInterceptor());
            }
            case 1003: {
                if (concurrency == 1007 || concurrency == 1008) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    return true;
                }
                throw SQLError.createSQLException("Illegal arguments to supportsResultSetConcurrency()", "S1009", this.getExceptionInterceptor());
            }
            case 1005: {
                return false;
            }
        }
        throw SQLError.createSQLException("Illegal arguments to supportsResultSetConcurrency()", "S1009", this.getExceptionInterceptor());
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return holdability == 1;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return type == 1004;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.conn.supportsIsolationLevel()) {
            switch (level) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.supportsTransactions();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.conn.versionMeetsMinimum(8, 0, 0);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        Field[] fields = this.createFunctionColumnsFields();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getProcedureOrFunctionColumns(fields, catalog, schemaPattern, functionNamePattern, columnNamePattern, false, true);
    }

    protected Field[] createFunctionColumnsFields() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT", 12, 0), new Field("", "FUNCTION_SCHEM", 12, 0), new Field("", "FUNCTION_NAME", 12, 0), new Field("", "COLUMN_NAME", 12, 0), new Field("", "COLUMN_TYPE", 12, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 12, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 12, 0), new Field("", "CHAR_OCTET_LENGTH", 4, 0), new Field("", "ORDINAL_POSITION", 4, 0), new Field("", "IS_NULLABLE", 12, 3), new Field("", "SPECIFIC_NAME", 12, 0)};
        return fields;
    }

    public boolean providesQueryObjectGenerator() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", 12, 255), new Field("", "TABLE_CATALOG", 12, 255)};
        return this.buildResultSet(fields, new ArrayList());
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    protected PreparedStatement prepareMetaDataSafeStatement(String sql) throws SQLException {
        PreparedStatement pStmt = this.conn.clientPrepareStatement(sql);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (pStmt.getMaxRows() != 0) {
            pStmt.setMaxRows(0);
        }
        ((Statement)((Object)pStmt)).setHoldResultsOpenOverClose(true);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return pStmt;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, 512), new Field("", "TABLE_SCHEM", 12, 512), new Field("", "TABLE_NAME", 12, 512), new Field("", "COLUMN_NAME", 12, 512), new Field("", "DATA_TYPE", 4, 12), new Field("", "COLUMN_SIZE", 4, 12), new Field("", "DECIMAL_DIGITS", 4, 12), new Field("", "NUM_PREC_RADIX", 4, 12), new Field("", "COLUMN_USAGE", 12, 512), new Field("", "REMARKS", 12, 512), new Field("", "CHAR_OCTET_LENGTH", 4, 12), new Field("", "IS_NULLABLE", 12, 512)};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.buildResultSet(fields, new ArrayList());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return null;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return null;
    }

    static {
        TABLE_AS_BYTES = "TABLE".getBytes();
        SYSTEM_TABLE_AS_BYTES = "SYSTEM TABLE".getBytes();
        VIEW_AS_BYTES = "VIEW".getBytes();
        if (Util.isJdbc4()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                JDBC_4_DBMD_SHOW_CTOR = Class.forName("com.gbase.jdbc.JDBC4DatabaseMetaData").getConstructor(GBaseConnection.class, String.class);
                JDBC_4_DBMD_IS_CTOR = Class.forName("com.gbase.jdbc.JDBC4DatabaseMetaDataUsingInfoSchema").getConstructor(GBaseConnection.class, String.class);
            }
            catch (SecurityException e) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw new CustomRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw new CustomRuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new CustomRuntimeException(e);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            JDBC_4_DBMD_IS_CTOR = null;
            JDBC_4_DBMD_SHOW_CTOR = null;
        }
        ArrayList<String> allGBaseKeywordList = new ArrayList<String>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("ACCESSIBLE", "ADD", "ALL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("FULLTEXT", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("KEY", "KEYS", "KILL", "LEADING", "LEAVE", "LEFT", "LIKE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("LOOP", "LOW_PRIORITY", "MATCH", "MEDIUMBLOB", "MEDIUMINT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("RANGE", "READ", "READS", "READ_ONLY", "READ_WRITE", "REAL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SPATIAL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        allGBaseKeywordList.addAll(Arrays.asList("WRITE", "X509", "XOR", "YEAR_MONTH", "ZEROFILL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String[] allGBaseKeywords = allGBaseKeywordList.toArray(new String[allGBaseKeywordList.size()]);
        ArrayList<String> sql92KeywordList = new ArrayList<String>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("ABSOLUTE", "EXEC", "OVERLAPS"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("ACTION", "EXECUTE", "PAD", "ADA", "EXISTS", "PARTIAL", "ADD"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("EXTERNAL", "PASCAL", "ALL", "EXTRACT", "POSITION", "ALLOCATE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("FALSE", "PRECISION", "ALTER", "FETCH", "PREPARE", "AND"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("FIRST", "PRESERVE", "ANY", "FLOAT", "PRIMARY", "ARE", "FOR"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("PRIOR", "AS", "FOREIGN", "PRIVILEGES", "ASC", "FORTRAN"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("PROCEDURE", "ASSERTION", "FOUND", "PUBLIC", "AT", "FROM"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("READ", "AUTHORIZATION", "FULL", "REAL", "AVG", "GET"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("REFERENCES", "BEGIN", "GLOBAL", "RELATIVE", "BETWEEN", "GO"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("RESTRICT", "BIT", "GOTO", "REVOKE", "BIT_LENGTH", "GRANT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("RIGHT", "BOTH", "GROUP", "ROLLBACK", "BY", "HAVING", "ROWS"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CASCADE", "HOUR", "SCHEMA", "CASCADED", "IDENTITY", "SCROLL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CASE", "IMMEDIATE", "SECOND", "CAST", "IN", "SECTION"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CATALOG", "INCLUDE", "SELECT", "CHAR", "INDEX", "SESSION"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CHAR_LENGTH", "INDICATOR", "SESSION_USER", "CHARACTER"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("INITIALLY", "SET", "CHARACTER_LENGTH", "INNER", "SIZE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CHECK", "INPUT", "SMALLINT", "CLOSE", "INSENSITIVE", "SOME"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("COALESCE", "INSERT", "SPACE", "COLLATE", "INT", "SQL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("COLLATION", "INTEGER", "SQLCA", "COLUMN", "INTERSECT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("SQLCODE", "COMMIT", "INTERVAL", "SQLERROR", "CONNECT", "INTO"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("SQLSTATE", "CONNECTION", "IS", "SQLWARNING", "CONSTRAINT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("ISOLATION", "SUBSTRING", "CONSTRAINTS", "JOIN", "SUM"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CONTINUE", "KEY", "SYSTEM_USER", "CONVERT", "LANGUAGE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("TABLE", "CORRESPONDING", "LAST", "TEMPORARY", "COUNT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("LEADING", "THEN", "CREATE", "LEFT", "TIME", "CROSS", "LEVEL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("TIMESTAMP", "CURRENT", "LIKE", "TIMEZONE_HOUR"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CURRENT_DATE", "LOCAL", "TIMEZONE_MINUTE", "CURRENT_TIME"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("LOWER", "TO", "CURRENT_TIMESTAMP", "MATCH", "TRAILING"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("CURRENT_USER", "MAX", "TRANSACTION", "CURSOR", "MIN"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("TRANSLATE", "DATE", "MINUTE", "TRANSLATION", "DAY", "MODULE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("TRIM", "DEALLOCATE", "MONTH", "TRUE", "DEC", "NAMES", "UNION"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("DECIMAL", "NATIONAL", "UNIQUE", "DECLARE", "NATURAL"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("UNKNOWN", "DEFAULT", "NCHAR", "UPDATE", "DEFERRABLE", "NEXT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("UPPER", "DEFERRED", "NO", "USAGE", "DELETE", "NONE", "USER"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("DESC", "NOT", "USING", "DESCRIBE", "NULL", "VALUE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("DESCRIPTOR", "NULLIF", "VALUES", "DIAGNOSTICS", "NUMERIC"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("VARCHAR", "DISCONNECT", "OCTET_LENGTH", "VARYING", "DISTINCT"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("OF", "VIEW", "DOMAIN", "ON", "WHEN", "DOUBLE", "ONLY"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("WHENEVER", "DROP", "OPEN", "WHERE", "ELSE", "OPTION", "WITH"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("END", "OR", "WORK", "END-EXEC", "ORDER", "WRITE", "ESCAPE"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sql92KeywordList.addAll(Arrays.asList("OUTER", "YEAR", "EXCEPT", "OUTPUT", "ZONE", "EXCEPTION"));
        String[] sql92Keywords = sql92KeywordList.toArray(new String[sql92KeywordList.size()]);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        TreeMap GBaseKeywordMap = new TreeMap();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < allGBaseKeywords.length; ++i) {
            GBaseKeywordMap.put(allGBaseKeywords[i], null);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        HashMap sql92KeywordMap = new HashMap(sql92Keywords.length);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < sql92Keywords.length; ++i) {
            sql92KeywordMap.put(sql92Keywords[i], null);
        }
        Iterator it = sql92KeywordMap.keySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (it.hasNext()) {
            GBaseKeywordMap.remove(it.next());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        StringBuffer keywordBuf = new StringBuffer();
        it = GBaseKeywordMap.keySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (it.hasNext()) {
            keywordBuf.append(it.next().toString());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        while (it.hasNext()) {
            keywordBuf.append(",");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            keywordBuf.append(it.next().toString());
        }
        gbaseKeywordsThatArentSQL92 = keywordBuf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ComparableWrapper<K, V>
    implements Comparable<ComparableWrapper<K, V>> {
        K key;
        V value;

        public ComparableWrapper(K key, V value) {
            this.key = key;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.value = value;
        }

        public K getKey() {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.key;
        }

        public V getValue() {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.value;
        }

        @Override
        public int compareTo(ComparableWrapper<K, V> other) {
            return ((Comparable)this.getKey()).compareTo(other.getKey());
        }

        public boolean equals(Object obj) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!(obj instanceof ComparableWrapper)) {
                return false;
            }
            K otherKey = ((ComparableWrapper)obj).getKey();
            return this.key.equals(otherKey);
        }

        public String toString() {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return "{KEY:" + this.key + "; VALUE:" + this.value + "}";
        }
    }

    class TypeDescriptor {
        int bufferLength;
        int charOctetLength;
        Integer columnSize;
        short dataType;
        Integer decimalDigits;
        String isNullable;
        int nullability;
        int numPrecRadix = 10;
        String typeName;

        TypeDescriptor(String typeInfo, String nullabilityInfo) throws SQLException {
            if (typeInfo == null) {
                throw SQLError.createSQLException("NULL typeinfo not supported.", "S1009", DatabaseMetaData.this.getExceptionInterceptor());
            }
            String gbaseType = "";
            String fullGBaseType = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (typeInfo.indexOf("(") != -1) {
                gbaseType = typeInfo.substring(0, typeInfo.indexOf("("));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                gbaseType = typeInfo;
            }
            int indexOfUnsignedInGBaseType = StringUtils.indexOfIgnoreCase(gbaseType, "unsigned");
            if (indexOfUnsignedInGBaseType != -1) {
                gbaseType = gbaseType.substring(0, indexOfUnsignedInGBaseType - 1);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            boolean isUnsigned = false;
            if (StringUtils.indexOfIgnoreCase(typeInfo, "unsigned") != -1 && StringUtils.indexOfIgnoreCase(typeInfo, "set") != 0 && StringUtils.indexOfIgnoreCase(typeInfo, "enum") != 0) {
                fullGBaseType = gbaseType + " unsigned";
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                isUnsigned = true;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                fullGBaseType = gbaseType;
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (DatabaseMetaData.this.conn.getCapitalizeTypeNames()) {
                fullGBaseType = fullGBaseType.toUpperCase(Locale.ENGLISH);
            }
            this.dataType = (short)GBaseDefs.gbaseToJavaType(gbaseType);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.typeName = fullGBaseType;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (StringUtils.startsWithIgnoreCase(typeInfo, "enum")) {
                String temp = typeInfo.substring(typeInfo.indexOf("("), typeInfo.lastIndexOf(")"));
                StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int maxLength = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                while (tokenizer.hasMoreTokens()) {
                    maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                }
                this.columnSize = Constants.integerValueOf(maxLength);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.decimalDigits = null;
            } else if (StringUtils.startsWithIgnoreCase(typeInfo, "set")) {
                String temp = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.lastIndexOf(")"));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                int maxLength = 0;
                int numElements = tokenizer.countTokens();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (numElements > 0) {
                    maxLength += numElements - 1;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                while (tokenizer.hasMoreTokens()) {
                    String setMember = tokenizer.nextToken().trim();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (setMember.startsWith("'") && setMember.endsWith("'")) {
                        maxLength += setMember.length() - 2;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        continue;
                    }
                    maxLength += setMember.length();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                this.columnSize = Constants.integerValueOf(maxLength);
                this.decimalDigits = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (typeInfo.indexOf(",") != -1) {
                this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")).trim());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.decimalDigits = Integer.valueOf(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")).trim());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                this.columnSize = null;
                this.decimalDigits = null;
                if ((StringUtils.indexOfIgnoreCase(typeInfo, "char") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "text") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "blob") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "binary") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "bit") != -1) && typeInfo.indexOf("(") != -1) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    int endParenIndex = typeInfo.indexOf(")");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (endParenIndex == -1) {
                        endParenIndex = typeInfo.length();
                    }
                    this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, endParenIndex).trim());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (DatabaseMetaData.this.conn.getTinyInt1isBit() && this.columnSize == 1 && StringUtils.startsWithIgnoreCase(typeInfo, 0, "tinyint")) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (DatabaseMetaData.this.conn.getTransformedBitIsBoolean()) {
                            this.dataType = (short)16;
                            this.typeName = "BOOLEAN";
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            this.dataType = (short)-7;
                            this.typeName = "BIT";
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                    }
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "tinyint")) {
                    if (DatabaseMetaData.this.conn.getTinyInt1isBit() && typeInfo.indexOf("(1)") != -1) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (DatabaseMetaData.this.conn.getTransformedBitIsBoolean()) {
                            this.dataType = (short)16;
                            this.typeName = "BOOLEAN";
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            this.dataType = (short)-7;
                            this.typeName = "BIT";
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                    } else {
                        this.columnSize = Constants.integerValueOf(3);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        this.decimalDigits = Constants.integerValueOf(0);
                    }
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "smallint")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(5);
                    this.decimalDigits = Constants.integerValueOf(0);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "mediumint")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(isUnsigned ? 8 : 7);
                    this.decimalDigits = Constants.integerValueOf(0);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "int")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(10);
                    this.decimalDigits = Constants.integerValueOf(0);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "integer")) {
                    this.columnSize = Constants.integerValueOf(10);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.decimalDigits = Constants.integerValueOf(0);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "bigint")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(isUnsigned ? 20 : 19);
                    this.decimalDigits = Constants.integerValueOf(0);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "int24")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(19);
                    this.decimalDigits = Constants.integerValueOf(0);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "real")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(12);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "float")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(12);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "decimal")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.columnSize = Constants.integerValueOf(12);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "numeric")) {
                    this.columnSize = Constants.integerValueOf(12);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "double")) {
                    this.columnSize = Constants.integerValueOf(22);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "char")) {
                    this.columnSize = Constants.integerValueOf(1);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "varchar")) {
                    this.columnSize = Constants.integerValueOf(255);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "timestamp")) {
                    this.columnSize = Constants.integerValueOf(19);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "datetime")) {
                    this.columnSize = Constants.integerValueOf(19);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "date")) {
                    this.columnSize = Constants.integerValueOf(10);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "time")) {
                    this.columnSize = Constants.integerValueOf(8);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "tinyblob")) {
                    this.columnSize = Constants.integerValueOf(255);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "blob")) {
                    this.columnSize = Constants.integerValueOf(65535);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "mediumblob")) {
                    this.columnSize = Constants.integerValueOf(0xFFFFFF);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "longblob")) {
                    this.columnSize = Constants.integerValueOf(Integer.MAX_VALUE);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "tinytext")) {
                    this.columnSize = Constants.integerValueOf(255);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "text")) {
                    this.columnSize = Constants.integerValueOf(65535);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "mediumtext")) {
                    this.columnSize = Constants.integerValueOf(0xFFFFFF);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "longtext")) {
                    this.columnSize = Constants.integerValueOf(Integer.MAX_VALUE);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "enum")) {
                    this.columnSize = Constants.integerValueOf(255);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (StringUtils.startsWithIgnoreCaseAndWs(typeInfo, "set")) {
                    this.columnSize = Constants.integerValueOf(255);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
            this.bufferLength = GBaseIO.getMaxBuf();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.numPrecRadix = 10;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (nullabilityInfo != null) {
                if (nullabilityInfo.equals("YES")) {
                    this.nullability = 1;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.isNullable = "YES";
                } else {
                    this.nullability = 0;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.isNullable = "NO";
                }
            } else {
                this.nullability = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.isNullable = "NO";
            }
        }
    }

    protected class SingleStringIterator
    extends IteratorWithCleanup {
        boolean onFirst;
        String value;

        SingleStringIterator(String s) {
            this.onFirst = true;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.value = s;
        }

        void close() throws SQLException {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }

        boolean hasNext() throws SQLException {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.onFirst;
        }

        Object next() throws SQLException {
            this.onFirst = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.value;
        }
    }

    protected class ResultSetIterator
    extends IteratorWithCleanup {
        int colIndex;
        ResultSet resultSet;

        ResultSetIterator(ResultSet rs, int index) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.resultSet = rs;
            this.colIndex = index;
        }

        void close() throws SQLException {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.resultSet.close();
        }

        boolean hasNext() throws SQLException {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.resultSet.next();
        }

        Object next() throws SQLException {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.resultSet.getObject(this.colIndex);
        }
    }

    class LocalAndReferencedColumns {
        String constraintName;
        List localColumnsList;
        String referencedCatalog;
        List referencedColumnsList;
        String referencedTable;

        LocalAndReferencedColumns(List localColumns, List refColumns, String constName, String refCatalog, String refTable) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.localColumnsList = localColumns;
            this.referencedColumnsList = refColumns;
            this.constraintName = constName;
            this.referencedTable = refTable;
            this.referencedCatalog = refCatalog;
        }
    }

    protected abstract class IteratorWithCleanup {
        protected IteratorWithCleanup() {
        }

        abstract void close() throws SQLException;

        abstract boolean hasNext() throws SQLException;

        abstract Object next() throws SQLException;
    }
}

