/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.EscapeProcessorResult;
import com.gbase.jdbc.EscapeTokenizer;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.TimeUtil;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

class EscapeProcessor {
    private static Map JDBC_CONVERT_TO_GBASE_TYPE_MAP;
    private static Map JDBC_NO_CONVERT_TO_GBASE_EXPRESSION_MAP;

    EscapeProcessor() {
    }

    public static final Object escapeSQL(String sql, boolean serverSupportsConvertFn, GBaseConnection conn) throws SQLException {
        boolean replaceEscapeSequence = false;
        String escapeSequence = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (sql == null) {
            return null;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int beginBrace = sql.indexOf(123);
        int nextEndBrace = beginBrace == -1 ? -1 : sql.indexOf(125, beginBrace);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (nextEndBrace == -1) {
            return sql;
        }
        StringBuffer newSql = new StringBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(sql);
        byte usesVariables = 0;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        boolean callingStoredFunction = false;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (escapeTokenizer.hasMoreTokens()) {
            String token = escapeTokenizer.nextToken();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (token.length() == 0) continue;
            if (token.charAt(0) == '{') {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!token.endsWith("}")) {
                    throw SQLError.createSQLException("Not a valid escape sequence: " + token, conn.getExceptionInterceptor());
                }
                if (token.length() > 2) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    int nestedBrace = token.indexOf(123, 2);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (nestedBrace != -1) {
                        StringBuffer buf = new StringBuffer(token.substring(0, 1));
                        Object remainingResults = EscapeProcessor.escapeSQL(token.substring(1, token.length() - 1), serverSupportsConvertFn, conn);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String remaining = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (remainingResults instanceof String) {
                            remaining = (String)remainingResults;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            remaining = ((EscapeProcessorResult)remainingResults).escapedSql;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (usesVariables != 1) {
                                usesVariables = ((EscapeProcessorResult)remainingResults).usesVariables;
                            }
                        }
                        buf.append(remaining);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        buf.append('}');
                        token = buf.toString();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                }
                String collapsedToken = EscapeProcessor.removeWhitespace(token);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (token != null) {
                    if (StringUtils.startsWithIgnoreCase(collapsedToken, "{escape")) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            StringTokenizer st = new StringTokenizer(token, " '");
                            st.nextToken();
                            escapeSequence = st.nextToken();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (escapeSequence.length() < 3) {
                                newSql.append(token);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                replaceEscapeSequence = true;
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        catch (NoSuchElementException e) {
                            newSql.append(token);
                        }
                    } else if (StringUtils.startsWithIgnoreCase(collapsedToken, "{fn")) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        int startPos = token.toLowerCase().indexOf("fn ") + 3;
                        int endPos = token.length() - 1;
                        String fnToken = token.substring(startPos, endPos);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (StringUtils.startsWithIgnoreCaseAndWs(fnToken, "convert")) {
                            newSql.append(EscapeProcessor.processConvertToken(fnToken, serverSupportsConvertFn, conn));
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            newSql.append(fnToken);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                    } else if (StringUtils.startsWithIgnoreCase(collapsedToken, "{d")) {
                        int startPos = token.indexOf(39) + 1;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        int endPos = token.lastIndexOf(39);
                        if (startPos == -1 || endPos == -1) {
                            newSql.append(token);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            String argument = token.substring(startPos, endPos);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            try {
                                StringTokenizer st = new StringTokenizer(argument, " -");
                                String year4 = st.nextToken();
                                String month2 = st.nextToken();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                String day2 = st.nextToken();
                                String dateString = "'" + year4 + "-" + month2 + "-" + day2 + "'";
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                newSql.append(dateString);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            catch (NoSuchElementException e) {
                                throw SQLError.createSQLException("Syntax error for DATE escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                            }
                        }
                    } else if (StringUtils.startsWithIgnoreCase(collapsedToken, "{ts")) {
                        EscapeProcessor.processTimestampToken(conn, newSql, token);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else if (StringUtils.startsWithIgnoreCase(collapsedToken, "{t")) {
                        EscapeProcessor.processTimeToken(conn, newSql, token);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else if (StringUtils.startsWithIgnoreCase(collapsedToken, "{call") || StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                        int startPos = StringUtils.indexOfIgnoreCase(token, "CALL") + 5;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        int endPos = token.length() - 1;
                        if (StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                            callingStoredFunction = true;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            newSql.append("SELECT ");
                            newSql.append(token.substring(startPos, endPos));
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            callingStoredFunction = false;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            newSql.append("CALL ");
                            newSql.append(token.substring(startPos, endPos));
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        for (int i = endPos - 1; i >= startPos; --i) {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            char c = token.charAt(i);
                            if (Character.isWhitespace(c)) continue;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (c != ')') {
                                newSql.append("()");
                            }
                            break;
                        }
                    } else if (StringUtils.startsWithIgnoreCase(collapsedToken, "{oj")) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        newSql.append(token);
                    }
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                continue;
            }
            newSql.append(token);
        }
        String escapedSql = newSql.toString();
        if (replaceEscapeSequence) {
            String currentSql = escapedSql;
            while (currentSql.indexOf(escapeSequence) != -1) {
                int escapePos = currentSql.indexOf(escapeSequence);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                String lhs = currentSql.substring(0, escapePos);
                String rhs = currentSql.substring(escapePos + 1, currentSql.length());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                currentSql = lhs + "\\" + rhs;
            }
            escapedSql = currentSql;
        }
        EscapeProcessorResult epr = new EscapeProcessorResult();
        epr.escapedSql = escapedSql;
        epr.callingStoredFunction = callingStoredFunction;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (usesVariables != 1) {
            if (escapeTokenizer.sawVariableUse()) {
                epr.usesVariables = 1;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                epr.usesVariables = 0;
            }
        }
        return epr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTimeToken(GBaseConnection conn, StringBuffer newSql, String token) throws SQLException {
        block12: {
            int startPos = token.indexOf(39) + 1;
            int endPos = token.lastIndexOf(39);
            if (startPos == -1 || endPos == -1) {
                newSql.append(token);
            } else {
                String argument = token.substring(startPos, endPos);
                try {
                    StringTokenizer st = new StringTokenizer(argument, " :");
                    String hour = st.nextToken();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    String minute = st.nextToken();
                    String second = st.nextToken();
                    if (!conn.getUseTimezone() || !conn.getUseLegacyDatetimeCode()) {
                        String timeString = "'" + hour + ":" + minute + ":" + second + "'";
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        newSql.append(timeString);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        break block12;
                    }
                    Calendar sessionCalendar = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (conn != null) {
                        sessionCalendar = conn.getCalendarInstanceForSessionOrNew();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        sessionCalendar = new GregorianCalendar();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        int hourInt = Integer.parseInt(hour);
                        int minuteInt = Integer.parseInt(minute);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        int secondInt = Integer.parseInt(second);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        Calendar calendar = sessionCalendar;
                        synchronized (calendar) {
                            Time toBeAdjusted = TimeUtil.fastTimeCreate(sessionCalendar, hourInt, minuteInt, secondInt, conn.getExceptionInterceptor());
                            Time inServerTimezone = TimeUtil.changeTimezone(conn, sessionCalendar, null, toBeAdjusted, sessionCalendar.getTimeZone(), conn.getServerTimezoneTZ(), false);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            newSql.append("'");
                            newSql.append(inServerTimezone.toString());
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            newSql.append("'");
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    catch (NumberFormatException nfe) {
                        throw SQLError.createSQLException("Syntax error in TIMESTAMP escape sequence '" + token + "'.", "S1009", conn.getExceptionInterceptor());
                    }
                }
                catch (NoSuchElementException e) {
                    throw SQLError.createSQLException("Syntax error for escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTimestampToken(GBaseConnection conn, StringBuffer newSql, String token) throws SQLException {
        block16: {
            int startPos = token.indexOf(39) + 1;
            int endPos = token.lastIndexOf(39);
            if (startPos == -1 || endPos == -1) {
                newSql.append(token);
            } else {
                String argument = token.substring(startPos, endPos);
                try {
                    if (!conn.getUseLegacyDatetimeCode()) {
                        Timestamp ts = Timestamp.valueOf(argument);
                        SimpleDateFormat tsdf = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss''", Locale.US);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        tsdf.setTimeZone(conn.getServerTimezoneTZ());
                        newSql.append(tsdf.format(ts));
                        break block16;
                    }
                    StringTokenizer st = new StringTokenizer(argument, " .-:");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        Calendar sessionCalendar;
                        String year4 = st.nextToken();
                        String month2 = st.nextToken();
                        String day2 = st.nextToken();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String hour = st.nextToken();
                        String minute = st.nextToken();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        String second = st.nextToken();
                        if (!conn.getUseTimezone() && !conn.getUseJDBCCompliantTimezoneShift()) {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            newSql.append("'").append(year4).append("-").append(month2).append("-").append(day2).append(" ").append(hour).append(":").append(minute).append(":").append(second).append("'");
                            break block16;
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (conn != null) {
                            sessionCalendar = conn.getCalendarInstanceForSessionOrNew();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            sessionCalendar = new GregorianCalendar();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            sessionCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            int year4Int = Integer.parseInt(year4);
                            int month2Int = Integer.parseInt(month2);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            int day2Int = Integer.parseInt(day2);
                            int hourInt = Integer.parseInt(hour);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            int minuteInt = Integer.parseInt(minute);
                            int secondInt = Integer.parseInt(second);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            Calendar calendar = sessionCalendar;
                            synchronized (calendar) {
                                boolean useGmtMillis = conn.getUseGmtMillisForDatetimes();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                Timestamp toBeAdjusted = TimeUtil.fastTimestampCreate(useGmtMillis, useGmtMillis ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : null, sessionCalendar, year4Int, month2Int, day2Int, hourInt, minuteInt, secondInt, 0);
                                Timestamp inServerTimezone = TimeUtil.changeTimezone(conn, sessionCalendar, null, toBeAdjusted, sessionCalendar.getTimeZone(), conn.getServerTimezoneTZ(), false);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                newSql.append("'");
                                String timezoneLiteral = inServerTimezone.toString();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                int indexOfDot = timezoneLiteral.indexOf(".");
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (indexOfDot != -1) {
                                    timezoneLiteral = timezoneLiteral.substring(0, indexOfDot);
                                }
                                newSql.append(timezoneLiteral);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            newSql.append("'");
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        catch (NumberFormatException nfe) {
                            throw SQLError.createSQLException("Syntax error in TIMESTAMP escape sequence '" + token + "'.", "S1009", conn.getExceptionInterceptor());
                        }
                    }
                    catch (NoSuchElementException e) {
                        throw SQLError.createSQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SQLException sqlEx = SQLError.createSQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    sqlEx.initCause(illegalArgumentException);
                    throw sqlEx;
                }
            }
        }
    }

    private static String processConvertToken(String functionToken, boolean serverSupportsConvertFn, GBaseConnection conn) throws SQLException {
        int firstIndexOfParen = functionToken.indexOf("(");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (firstIndexOfParen == -1) {
            throw SQLError.createSQLException("Syntax error while processing {fn convert (... , ...)} token, missing opening parenthesis in token '" + functionToken + "'.", "42000", conn.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int tokenLength = functionToken.length();
        int indexOfComma = functionToken.lastIndexOf(",");
        if (indexOfComma == -1) {
            throw SQLError.createSQLException("Syntax error while processing {fn convert (... , ...)} token, missing comma in token '" + functionToken + "'.", "42000", conn.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int indexOfCloseParen = functionToken.indexOf(41, indexOfComma);
        if (indexOfCloseParen == -1) {
            throw SQLError.createSQLException("Syntax error while processing {fn convert (... , ...)} token, missing closing parenthesis in token '" + functionToken + "'.", "42000", conn.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String expression = functionToken.substring(firstIndexOfParen + 1, indexOfComma);
        String type = functionToken.substring(indexOfComma + 1, indexOfCloseParen);
        String newType = null;
        String trimmedType = type.trim();
        if (StringUtils.startsWithIgnoreCase(trimmedType, "SQL_")) {
            trimmedType = trimmedType.substring(4, trimmedType.length());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (serverSupportsConvertFn) {
            newType = (String)JDBC_CONVERT_TO_GBASE_TYPE_MAP.get(trimmedType.toUpperCase(Locale.ENGLISH));
        } else {
            newType = (String)JDBC_NO_CONVERT_TO_GBASE_EXPRESSION_MAP.get(trimmedType.toUpperCase(Locale.ENGLISH));
            if (newType == null) {
                throw SQLError.createSQLException("Can't find conversion re-write for type '" + type + "' that is applicable for this server version while processing escape tokens.", "S1000", conn.getExceptionInterceptor());
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (newType == null) {
            throw SQLError.createSQLException("Unsupported conversion type '" + type.trim() + "' found while processing escape token.", "S1000", conn.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int replaceIndex = newType.indexOf("?");
        if (replaceIndex != -1) {
            StringBuffer convertRewrite = new StringBuffer(newType.substring(0, replaceIndex));
            convertRewrite.append(expression);
            convertRewrite.append(newType.substring(replaceIndex + 1, newType.length()));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return convertRewrite.toString();
        }
        StringBuffer castRewrite = new StringBuffer("CAST(");
        castRewrite.append(expression);
        castRewrite.append(" AS ");
        castRewrite.append(newType);
        castRewrite.append(")");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return castRewrite.toString();
    }

    private static String removeWhitespace(String toCollapse) {
        if (toCollapse == null) {
            return null;
        }
        int length = toCollapse.length();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        StringBuffer collapsed = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = toCollapse.charAt(i);
            if (Character.isWhitespace(c)) continue;
            collapsed.append(c);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return collapsed.toString();
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("BIGINT", "0 + ?");
        tempMap.put("BINARY", "BINARY");
        tempMap.put("BIT", "0 + ?");
        tempMap.put("CHAR", "CHAR");
        tempMap.put("DATE", "DATE");
        tempMap.put("DECIMAL", "0.0 + ?");
        tempMap.put("DOUBLE", "0.0 + ?");
        tempMap.put("FLOAT", "0.0 + ?");
        tempMap.put("INTEGER", "0 + ?");
        tempMap.put("LONGVARBINARY", "BINARY");
        tempMap.put("LONGVARCHAR", "CONCAT(?)");
        tempMap.put("REAL", "0.0 + ?");
        tempMap.put("SMALLINT", "CONCAT(?)");
        tempMap.put("TIME", "TIME");
        tempMap.put("TIMESTAMP", "DATETIME");
        tempMap.put("TINYINT", "CONCAT(?)");
        tempMap.put("VARBINARY", "BINARY");
        tempMap.put("VARCHAR", "CONCAT(?)");
        JDBC_CONVERT_TO_GBASE_TYPE_MAP = Collections.unmodifiableMap(tempMap);
        tempMap = new HashMap(JDBC_CONVERT_TO_GBASE_TYPE_MAP);
        tempMap.put("BINARY", "CONCAT(?)");
        tempMap.put("CHAR", "CONCAT(?)");
        tempMap.remove("DATE");
        tempMap.put("LONGVARBINARY", "CONCAT(?)");
        tempMap.remove("TIME");
        tempMap.remove("TIMESTAMP");
        tempMap.put("VARBINARY", "CONCAT(?)");
        JDBC_NO_CONVERT_TO_GBASE_EXPRESSION_MAP = Collections.unmodifiableMap(tempMap);
    }
}

