/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;

public class EscapeTokenizer {
    private int bracesLevel = 0;
    private boolean emittingEscapeCode = false;
    private boolean inComment = false;
    private boolean inQuotes = false;
    private char lastChar = '\u0000';
    private char lastLastChar = '\u0000';
    private int pos = 0;
    private char quoteChar = '\u0000';
    private boolean sawVariableUse = false;
    private String source = null;
    private int sourceLength = 0;

    public EscapeTokenizer(String s) {
        this.source = s;
        this.sourceLength = s.length();
        this.pos = 0;
    }

    public synchronized boolean hasMoreTokens() {
        return this.pos < this.sourceLength;
    }

    public synchronized String nextToken() {
        StringBuffer tokenBuf = new StringBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.emittingEscapeCode) {
            tokenBuf.append("{");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.emittingEscapeCode = false;
        }
        while (this.pos < this.sourceLength) {
            block28: {
                char c;
                block29: {
                    block26: {
                        block27: {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            c = this.source.charAt(this.pos);
                            if (!this.inQuotes && c == '@') {
                                this.sawVariableUse = true;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                            if (c != '\'' && c != '\"' || this.inComment) break block26;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (!this.inQuotes || c != this.quoteChar || this.pos + 1 >= this.sourceLength) break block27;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (this.source.charAt(this.pos + 1) != this.quoteChar || this.lastChar == '\\') break block27;
                            tokenBuf.append(this.quoteChar);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            tokenBuf.append(this.quoteChar);
                            ++this.pos;
                            break block28;
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (this.lastChar != '\\') {
                            if (this.inQuotes) {
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (this.quoteChar == c) {
                                    this.inQuotes = false;
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                this.inQuotes = true;
                                this.quoteChar = c;
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else if (this.lastLastChar == '\\') {
                            if (this.inQuotes) {
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (this.quoteChar == c) {
                                    this.inQuotes = false;
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                this.inQuotes = true;
                                this.quoteChar = c;
                            }
                        }
                        tokenBuf.append(c);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        break block29;
                    }
                    if (c == '-') {
                        if (this.lastChar == '-' && this.lastLastChar != '\\' && !this.inQuotes) {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            this.inComment = true;
                        }
                        tokenBuf.append(c);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else if (c == '\n' || c == '\r') {
                        this.inComment = false;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        tokenBuf.append(c);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else if (c == '{') {
                        if (this.inQuotes || this.inComment) {
                            tokenBuf.append(c);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            ++this.bracesLevel;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (this.bracesLevel == 1) {
                                ++this.pos;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                this.emittingEscapeCode = true;
                                return tokenBuf.toString();
                            }
                            tokenBuf.append(c);
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else if (c == '}') {
                        tokenBuf.append(c);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (!this.inQuotes && !this.inComment) {
                            this.lastChar = c;
                            --this.bracesLevel;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (this.bracesLevel == 0) {
                                ++this.pos;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                return tokenBuf.toString();
                            }
                        }
                    } else {
                        tokenBuf.append(c);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                }
                this.lastLastChar = this.lastChar;
                this.lastChar = c;
            }
            ++this.pos;
        }
        return tokenBuf.toString();
    }

    boolean sawVariableUse() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.sawVariableUse;
    }
}

