/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.GBaseIO;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExportControlled {
    private static final String SQL_STATE_BAD_SSL_PARAMS = "08000";

    protected static boolean enabled() {
        return true;
    }

    protected static void transformSocketToSSLSocket(GBaseIO gbaseIO) throws SQLException {
        SSLSocketFactory sslFact = ExportControlled.getSSLSocketFactoryDefaultOrConfigured(gbaseIO);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            gbaseIO.gbaseConnection = sslFact.createSocket(gbaseIO.gbaseConnection, gbaseIO.host, gbaseIO.port, true);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            ((SSLSocket)gbaseIO.gbaseConnection).setEnabledProtocols(new String[]{"TLSv1"});
            ((SSLSocket)gbaseIO.gbaseConnection).startHandshake();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (gbaseIO.connection.getUseUnbufferedInput()) {
                gbaseIO.gbaseInput = gbaseIO.gbaseConnection.getInputStream();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                gbaseIO.gbaseInput = new BufferedInputStream(gbaseIO.gbaseConnection.getInputStream(), 16384);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            gbaseIO.gbaseOutput = new BufferedOutputStream(gbaseIO.gbaseConnection.getOutputStream(), 16384);
            gbaseIO.gbaseOutput.flush();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IOException ioEx) {
            throw SQLError.createCommunicationsException(gbaseIO.connection, gbaseIO.getLastPacketSentTimeMs(), gbaseIO.getLastPacketReceivedTimeMs(), ioEx, gbaseIO.getExceptionInterceptor());
        }
    }

    private ExportControlled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLSocketFactory getSSLSocketFactoryDefaultOrConfigured(GBaseIO gbaseIO) throws SQLException {
        KeyManagerFactory kmf;
        TrustManagerFactory tmf;
        String clientCertificateKeyStoreUrl;
        block31: {
            char[] password;
            URL ksURL;
            clientCertificateKeyStoreUrl = gbaseIO.connection.getClientCertificateKeyStoreUrl();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String trustCertificateKeyStoreUrl = gbaseIO.connection.getTrustCertificateKeyStoreUrl();
            String clientCertificateKeyStoreType = gbaseIO.connection.getClientCertificateKeyStoreType();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String clientCertificateKeyStorePassword = gbaseIO.connection.getClientCertificateKeyStorePassword();
            String trustCertificateKeyStoreType = gbaseIO.connection.getTrustCertificateKeyStoreType();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String trustCertificateKeyStorePassword = gbaseIO.connection.getTrustCertificateKeyStorePassword();
            if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) && StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (gbaseIO.connection.getVerifyServerCertificate()) {
                    return (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
            }
            tmf = null;
            kmf = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw SQLError.createSQLException("Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
                try {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreType)) {
                        KeyStore clientKeyStore = KeyStore.getInstance(clientCertificateKeyStoreType);
                        ksURL = new URL(clientCertificateKeyStoreUrl);
                        password = clientCertificateKeyStorePassword == null ? new char[]{} : clientCertificateKeyStorePassword.toCharArray();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        clientKeyStore.load(ksURL.openStream(), password);
                        kmf.init(clientKeyStore, password);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (UnrecoverableKeyException uke) {
                    throw SQLError.createSQLException("Could not recover keys from client keystore.  Check password?", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (NoSuchAlgorithmException nsae) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (KeyStoreException kse) {
                    throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (CertificateException nsae) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    throw SQLError.createSQLException("Could not load client" + clientCertificateKeyStoreType + " keystore from " + clientCertificateKeyStoreUrl, gbaseIO.getExceptionInterceptor());
                }
                catch (MalformedURLException mue) {
                    throw SQLError.createSQLException(clientCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                }
                catch (IOException ioe) {
                    SQLException sqlEx = SQLError.createSQLException("Cannot open " + clientCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    sqlEx.initCause(ioe);
                    throw sqlEx;
                }
            }
            if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) break block31;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreType)) break block31;
                KeyStore trustKeyStore = KeyStore.getInstance(trustCertificateKeyStoreType);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                ksURL = new URL(trustCertificateKeyStoreUrl);
                password = trustCertificateKeyStorePassword == null ? new char[]{} : trustCertificateKeyStorePassword.toCharArray();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                InputStream is = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    is = ksURL.openStream();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    trustKeyStore.load(is, password);
                    Object var14_28 = null;
                }
                catch (Throwable throwable) {
                    Object var14_29 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                tmf.init(trustKeyStore);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (NoSuchAlgorithmException nsae) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (KeyStoreException kse) {
                throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (CertificateException nsae) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw SQLError.createSQLException("Could not load trust" + trustCertificateKeyStoreType + " keystore from " + trustCertificateKeyStoreUrl, SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (MalformedURLException mue) {
                throw SQLError.createSQLException(trustCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
            }
            catch (IOException ioe) {
                SQLException sqlEx = SQLError.createSQLException("Cannot open " + trustCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                sqlEx.initCause(ioe);
                throw sqlEx;
            }
        }
        SSLContext sslContext = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            TrustManager[] trustManagerArray;
            sslContext = SSLContext.getInstance("TLS");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            KeyManager[] keyManagerArray = StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) ? null : kmf.getKeyManagers();
            if (gbaseIO.connection.getVerifyServerCertificate()) {
                trustManagerArray = tmf.getTrustManagers();
            } else {
                X509TrustManager[] x509TrustManagerArray = new X509TrustManager[1];
                trustManagerArray = x509TrustManagerArray;
                x509TrustManagerArray[0] = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        return null;
                    }
                };
            }
            sslContext.init(keyManagerArray, trustManagerArray, null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw SQLError.createSQLException("TLS is not a valid SSL protocol.", SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
        }
        catch (KeyManagementException kme) {
            throw SQLError.createSQLException("KeyManagementException: " + kme.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 0, false, gbaseIO.getExceptionInterceptor());
        }
    }
}

