/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.ConnectionPropertiesImpl;
import com.gbase.jdbc.LoadBalancingConnectionProxy;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverConnectionProxy
extends LoadBalancingConnectionProxy {
    boolean failedOver;
    boolean hasTriedMaster;
    private long masterFailTimeMillis;
    boolean preferSlaveDuringFailover;
    private String primaryHostPortSpec;
    private long queriesBeforeRetryMaster;
    long queriesIssuedFailedOver;
    private int secondsBeforeRetryMaster;

    FailoverConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        super(hosts, props);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ConnectionPropertiesImpl connectionProps = new ConnectionPropertiesImpl();
        connectionProps.initializeProperties(props);
        this.queriesBeforeRetryMaster = connectionProps.getQueriesBeforeRetryMaster();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.secondsBeforeRetryMaster = connectionProps.getSecondsBeforeRetryMaster();
        this.preferSlaveDuringFailover = false;
    }

    @Override
    protected LoadBalancingConnectionProxy.ConnectionErrorFiringInvocationHandler createConnectionProxy(Object toProxy) {
        return new FailoverInvocationHandler(toProxy);
    }

    @Override
    void dealWithInvocationException(InvocationTargetException e) throws SQLException, InvocationTargetException {
        Throwable t = e.getTargetException();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (t != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.failedOver) {
                this.createPrimaryConnection();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.currentConn != null) {
                    if (t instanceof SQLException) {
                        throw (SQLException)t;
                    }
                    throw new SQLException(t.getMessage());
                }
            }
            this.failOver();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(t.getMessage());
        }
        throw e;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = method.getName();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if ("setPreferSlaveDuringFailover".equals(methodName)) {
            this.preferSlaveDuringFailover = (Boolean)args[0];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else if ("clearHasTriedMaster".equals(methodName)) {
            this.hasTriedMaster = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            if ("hasTriedMaster".equals(methodName)) {
                return this.hasTriedMaster;
            }
            if ("setReadOnly".equals(methodName)) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.failedOver) {
                    return null;
                }
            } else if ("setAutoCommit".equals(methodName) && this.failedOver && this.shouldFallBack() && Boolean.TRUE.equals(args[0]) && this.failedOver) {
                this.createPrimaryConnection();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return super.invoke(proxy, method, args);
            }
        }
        return super.invoke(proxy, method, args);
    }

    private void createPrimaryConnection() throws SQLException {
        block2: {
            try {
                this.currentConn = this.createConnectionForHost(this.primaryHostPortSpec);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.failedOver = false;
                this.hasTriedMaster = true;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SQLException sqlEx) {
                this.failedOver = true;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.currentConn == null) break block2;
                this.currentConn.getLog().logWarn("Connection to primary host failed", sqlEx);
            }
        }
    }

    @Override
    synchronized void invalidateCurrentConnection() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.failedOver) {
            this.failedOver = true;
            this.queriesIssuedFailedOver = 0L;
            this.masterFailTimeMillis = System.currentTimeMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        super.invalidateCurrentConnection();
    }

    @Override
    protected synchronized void pickNewConnection() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.primaryHostPortSpec == null) {
            this.primaryHostPortSpec = (String)this.hostList.remove(0);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.currentConn == null || this.failedOver && this.shouldFallBack()) {
            this.createPrimaryConnection();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.currentConn != null) {
                return;
            }
        }
        this.failOver();
    }

    private void failOver() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.failedOver) {
            Iterator iter = this.liveConnections.entrySet().iterator();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ((ConnectionImpl)entry.getValue()).close();
            }
            this.liveConnections.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        super.pickNewConnection();
        this.currentConn.setReadOnly(true);
        this.failedOver = true;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    private boolean shouldFallBack() {
        long secondsSinceFailedOver = (System.currentTimeMillis() - this.masterFailTimeMillis) / 1000L;
        boolean tryFallback = secondsSinceFailedOver >= (long)this.secondsBeforeRetryMaster || this.queriesIssuedFailedOver >= this.queriesBeforeRetryMaster;
        return tryFallback;
    }

    class FailoverInvocationHandler
    extends LoadBalancingConnectionProxy.ConnectionErrorFiringInvocationHandler {
        public FailoverInvocationHandler(Object toInvokeOn) {
            super(FailoverConnectionProxy.this, toInvokeOn);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
            String methodName = method.getName();
            if (FailoverConnectionProxy.this.failedOver && methodName.indexOf("execute") != -1) {
                ++FailoverConnectionProxy.this.queriesIssuedFailedOver;
            }
            return super.invoke(proxy, method, args);
        }
    }
}

