/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Constants;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class GBaseDefs {
    static final int COM_BINLOG_DUMP = 18;
    static final int COM_CHANGE_USER = 17;
    static final int COM_CLOSE_STATEMENT = 25;
    static final int COM_CONNECT_OUT = 20;
    static final int COM_END = 29;
    static final int COM_EXECUTE = 23;
    static final int COM_FETCH = 28;
    static final int COM_LONG_DATA = 24;
    static final int COM_PREPARE = 22;
    static final int COM_REGISTER_SLAVE = 21;
    static final int COM_RESET_STMT = 26;
    static final int COM_SET_OPTION = 27;
    static final int COM_TABLE_DUMP = 19;
    static final int CONNECT = 11;
    static final int CREATE_DB = 5;
    static final int DEBUG = 13;
    static final int DELAYED_INSERT = 16;
    static final int DROP_DB = 6;
    static final int FIELD_LIST = 4;
    static final int FIELD_TYPE_BIT = 16;
    public static final int FIELD_TYPE_BLOB = 252;
    static final int FIELD_TYPE_DATE = 10;
    static final int FIELD_TYPE_DATETIME = 12;
    static final int FIELD_TYPE_DECIMAL = 0;
    static final int FIELD_TYPE_DOUBLE = 5;
    static final int FIELD_TYPE_ENUM = 247;
    static final int FIELD_TYPE_FLOAT = 4;
    static final int FIELD_TYPE_GEOMETRY = 255;
    static final int FIELD_TYPE_INT24 = 9;
    static final int FIELD_TYPE_LONG = 3;
    static final int FIELD_TYPE_LONG_BLOB = 251;
    static final int FIELD_TYPE_LONGLONG = 8;
    static final int FIELD_TYPE_MEDIUM_BLOB = 250;
    static final int FIELD_TYPE_NEW_DECIMAL = 246;
    static final int FIELD_TYPE_NEWDATE = 14;
    static final int FIELD_TYPE_NULL = 6;
    static final int FIELD_TYPE_SET = 248;
    static final int FIELD_TYPE_SHORT = 2;
    static final int FIELD_TYPE_STRING = 254;
    static final int FIELD_TYPE_TIME = 11;
    static final int FIELD_TYPE_TIMESTAMP = 7;
    static final int FIELD_TYPE_TINY = 1;
    static final int FIELD_TYPE_TINY_BLOB = 249;
    static final int FIELD_TYPE_VAR_STRING = 253;
    static final int FIELD_TYPE_VARCHAR = 15;
    static final int FIELD_TYPE_YEAR = 13;
    static final int INIT_DB = 2;
    static final long LENGTH_BLOB = 65535L;
    static final long LENGTH_LONGBLOB = 0xFFFFFFFFL;
    static final long LENGTH_MEDIUMBLOB = 0xFFFFFFL;
    static final long LENGTH_TINYBLOB = 255L;
    static final int MAX_ROWS = 50000000;
    public static final int NO_CHARSET_INFO = -1;
    static final byte OPEN_CURSOR_FLAG = 1;
    static final int PING = 14;
    static final int PROCESS_INFO = 10;
    static final int PROCESS_KILL = 12;
    static final int QUERY = 3;
    static final int QUIT = 1;
    static final int RELOAD = 7;
    static final int SHUTDOWN = 8;
    static final int SLEEP = 0;
    static final int STATISTICS = 9;
    static final int TIME = 15;
    private static Map gbaseToJdbcTypesMap = new HashMap();

    static int gbaseToJavaType(int gbaseType) {
        int jdbcType;
        switch (gbaseType) {
            case 0: 
            case 246: {
                jdbcType = 3;
                break;
            }
            case 1: {
                jdbcType = -6;
                break;
            }
            case 2: {
                jdbcType = 5;
                break;
            }
            case 3: {
                jdbcType = 4;
                break;
            }
            case 4: {
                jdbcType = 7;
                break;
            }
            case 5: {
                jdbcType = 8;
                break;
            }
            case 6: {
                jdbcType = 0;
                break;
            }
            case 7: {
                jdbcType = 93;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: {
                jdbcType = 4;
                break;
            }
            case 10: {
                jdbcType = 91;
                break;
            }
            case 11: {
                jdbcType = 92;
                break;
            }
            case 12: {
                jdbcType = 93;
                break;
            }
            case 13: {
                jdbcType = 91;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 247: {
                jdbcType = 1;
                break;
            }
            case 248: {
                jdbcType = 1;
                break;
            }
            case 249: {
                jdbcType = -3;
                break;
            }
            case 250: {
                jdbcType = -4;
                break;
            }
            case 251: {
                jdbcType = -4;
                break;
            }
            case 252: {
                jdbcType = -4;
                break;
            }
            case 15: 
            case 253: {
                jdbcType = 12;
                break;
            }
            case 254: {
                jdbcType = 1;
                break;
            }
            case 255: {
                jdbcType = -2;
                break;
            }
            case 16: {
                jdbcType = -7;
                break;
            }
            default: {
                jdbcType = 12;
            }
        }
        return jdbcType;
    }

    static int gbaseToJavaType(String gbaseType) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gbaseType.equalsIgnoreCase("BIT")) {
            return GBaseDefs.gbaseToJavaType(16);
        }
        if (gbaseType.equalsIgnoreCase("TINYINT")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(1);
        }
        if (gbaseType.equalsIgnoreCase("SMALLINT")) {
            return GBaseDefs.gbaseToJavaType(2);
        }
        if (gbaseType.equalsIgnoreCase("MEDIUMINT")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(9);
        }
        if (gbaseType.equalsIgnoreCase("INT") || gbaseType.equalsIgnoreCase("INTEGER")) {
            return GBaseDefs.gbaseToJavaType(3);
        }
        if (gbaseType.equalsIgnoreCase("BIGINT")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(8);
        }
        if (gbaseType.equalsIgnoreCase("INT24")) {
            return GBaseDefs.gbaseToJavaType(9);
        }
        if (gbaseType.equalsIgnoreCase("REAL")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(5);
        }
        if (gbaseType.equalsIgnoreCase("FLOAT")) {
            return GBaseDefs.gbaseToJavaType(4);
        }
        if (gbaseType.equalsIgnoreCase("DECIMAL")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(0);
        }
        if (gbaseType.equalsIgnoreCase("NUMERIC")) {
            return GBaseDefs.gbaseToJavaType(0);
        }
        if (gbaseType.equalsIgnoreCase("DOUBLE")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(5);
        }
        if (gbaseType.equalsIgnoreCase("CHAR")) {
            return GBaseDefs.gbaseToJavaType(254);
        }
        if (gbaseType.equalsIgnoreCase("VARCHAR")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(253);
        }
        if (gbaseType.equalsIgnoreCase("DATE")) {
            return GBaseDefs.gbaseToJavaType(10);
        }
        if (gbaseType.equalsIgnoreCase("TIME")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(11);
        }
        if (gbaseType.equalsIgnoreCase("YEAR")) {
            return GBaseDefs.gbaseToJavaType(13);
        }
        if (gbaseType.equalsIgnoreCase("TIMESTAMP")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(7);
        }
        if (gbaseType.equalsIgnoreCase("DATETIME")) {
            return GBaseDefs.gbaseToJavaType(12);
        }
        if (gbaseType.equalsIgnoreCase("TINYBLOB")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return -2;
        }
        if (gbaseType.equalsIgnoreCase("BLOB")) {
            return -4;
        }
        if (gbaseType.equalsIgnoreCase("MEDIUMBLOB")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return -4;
        }
        if (gbaseType.equalsIgnoreCase("LONGBLOB")) {
            return -4;
        }
        if (gbaseType.equalsIgnoreCase("TINYTEXT")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return 12;
        }
        if (gbaseType.equalsIgnoreCase("TEXT")) {
            return -1;
        }
        if (gbaseType.equalsIgnoreCase("MEDIUMTEXT")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return -1;
        }
        if (gbaseType.equalsIgnoreCase("LONGTEXT")) {
            return -1;
        }
        if (gbaseType.equalsIgnoreCase("ENUM")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(247);
        }
        if (gbaseType.equalsIgnoreCase("SET")) {
            return GBaseDefs.gbaseToJavaType(248);
        }
        if (gbaseType.equalsIgnoreCase("GEOMETRY")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return GBaseDefs.gbaseToJavaType(255);
        }
        if (gbaseType.equalsIgnoreCase("BINARY")) {
            return -2;
        }
        if (gbaseType.equalsIgnoreCase("VARBINARY")) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return -3;
        }
        if (gbaseType.equalsIgnoreCase("BIT")) {
            return GBaseDefs.gbaseToJavaType(16);
        }
        return 1111;
    }

    public static String typeToName(int gbaseType) {
        switch (gbaseType) {
            case 0: {
                return "FIELD_TYPE_DECIMAL";
            }
            case 1: {
                return "FIELD_TYPE_TINY";
            }
            case 2: {
                return "FIELD_TYPE_SHORT";
            }
            case 3: {
                return "FIELD_TYPE_LONG";
            }
            case 4: {
                return "FIELD_TYPE_FLOAT";
            }
            case 5: {
                return "FIELD_TYPE_DOUBLE";
            }
            case 6: {
                return "FIELD_TYPE_NULL";
            }
            case 7: {
                return "FIELD_TYPE_TIMESTAMP";
            }
            case 8: {
                return "FIELD_TYPE_LONGLONG";
            }
            case 9: {
                return "FIELD_TYPE_INT24";
            }
            case 10: {
                return "FIELD_TYPE_DATE";
            }
            case 11: {
                return "FIELD_TYPE_TIME";
            }
            case 12: {
                return "FIELD_TYPE_DATETIME";
            }
            case 13: {
                return "FIELD_TYPE_YEAR";
            }
            case 14: {
                return "FIELD_TYPE_NEWDATE";
            }
            case 247: {
                return "FIELD_TYPE_ENUM";
            }
            case 248: {
                return "FIELD_TYPE_SET";
            }
            case 249: {
                return "FIELD_TYPE_TINY_BLOB";
            }
            case 250: {
                return "FIELD_TYPE_MEDIUM_BLOB";
            }
            case 251: {
                return "FIELD_TYPE_LONG_BLOB";
            }
            case 252: {
                return "FIELD_TYPE_BLOB";
            }
            case 253: {
                return "FIELD_TYPE_VAR_STRING";
            }
            case 254: {
                return "FIELD_TYPE_STRING";
            }
            case 15: {
                return "FIELD_TYPE_VARCHAR";
            }
            case 255: {
                return "FIELD_TYPE_GEOMETRY";
            }
        }
        return " Unknown GBase Type # " + gbaseType;
    }

    static final void appendJdbcTypeMappingQuery(StringBuilder buf, String gbaseTypeColumnName) {
        buf.append("CASE ");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        HashMap<String, Integer> typesMap = new HashMap<String, Integer>();
        typesMap.putAll(gbaseToJdbcTypesMap);
        typesMap.put("BINARY", Constants.integerValueOf(-2));
        typesMap.put("VARBINARY", Constants.integerValueOf(-3));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Iterator gbaseTypes = typesMap.keySet().iterator();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (gbaseTypes.hasNext()) {
            String gbaseTypeName = (String)gbaseTypes.next();
            buf.append(" WHEN ");
            buf.append(gbaseTypeColumnName);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            buf.append("='");
            buf.append(gbaseTypeName);
            buf.append("' THEN ");
            buf.append(typesMap.get(gbaseTypeName));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!gbaseTypeName.equalsIgnoreCase("DOUBLE") && !gbaseTypeName.equalsIgnoreCase("FLOAT") && !gbaseTypeName.equalsIgnoreCase("DECIMAL") && !gbaseTypeName.equalsIgnoreCase("NUMERIC")) continue;
            buf.append(" WHEN ");
            buf.append(gbaseTypeColumnName);
            buf.append("='");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            buf.append(gbaseTypeName);
            buf.append(" unsigned' THEN ");
            buf.append(typesMap.get(gbaseTypeName));
        }
        buf.append(" ELSE ");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        buf.append(1111);
        buf.append(" END ");
    }

    static {
        gbaseToJdbcTypesMap.put("BIT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(16)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("TINYINT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(1)));
        gbaseToJdbcTypesMap.put("SMALLINT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(2)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("MEDIUMINT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(9)));
        gbaseToJdbcTypesMap.put("INT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(3)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("INTEGER", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(3)));
        gbaseToJdbcTypesMap.put("BIGINT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(8)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("INT24", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(9)));
        gbaseToJdbcTypesMap.put("REAL", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(5)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("FLOAT", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(4)));
        gbaseToJdbcTypesMap.put("DECIMAL", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(0)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("NUMERIC", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(0)));
        gbaseToJdbcTypesMap.put("DOUBLE", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(5)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("CHAR", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(254)));
        gbaseToJdbcTypesMap.put("VARCHAR", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(253)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("DATE", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(10)));
        gbaseToJdbcTypesMap.put("TIME", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(11)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("YEAR", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(13)));
        gbaseToJdbcTypesMap.put("TIMESTAMP", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(7)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("DATETIME", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(12)));
        gbaseToJdbcTypesMap.put("TINYBLOB", Constants.integerValueOf(-2));
        gbaseToJdbcTypesMap.put("BLOB", Constants.integerValueOf(-4));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("MEDIUMBLOB", Constants.integerValueOf(-4));
        gbaseToJdbcTypesMap.put("LONGBLOB", Constants.integerValueOf(-4));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("TINYTEXT", Constants.integerValueOf(12));
        gbaseToJdbcTypesMap.put("TEXT", Constants.integerValueOf(-1));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("MEDIUMTEXT", Constants.integerValueOf(-1));
        gbaseToJdbcTypesMap.put("LONGTEXT", Constants.integerValueOf(-1));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("ENUM", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(247)));
        gbaseToJdbcTypesMap.put("SET", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(248)));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        gbaseToJdbcTypesMap.put("GEOMETRY", Constants.integerValueOf(GBaseDefs.gbaseToJavaType(255)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ClientFlags {
        JDBC,
        STUDIO,
        CLOSE,
        OTHERS;

    }
}

