/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.rmi.server.UID;
import java.sql.SQLException;
import java.sql.Savepoint;

public class GBaseSavepoint
implements Savepoint {
    private String savepointName;
    private ExceptionInterceptor exceptionInterceptor;

    private static String getUniqueId() {
        String uniqueIdStr = new UID().toString();
        int uniqueIdLen = uniqueIdStr.length();
        StringBuffer securityStrBuffer = new StringBuffer(uniqueIdLen);
        for (int index = 0; index < uniqueIdLen; ++index) {
            char charAt = uniqueIdStr.charAt(index);
            if (Character.isLetter(charAt) || Character.isDigit(charAt)) {
                securityStrBuffer.append(charAt);
                continue;
            }
            securityStrBuffer.append('_');
        }
        return securityStrBuffer.toString();
    }

    GBaseSavepoint(ExceptionInterceptor exceptionInterceptor) throws SQLException {
        this(GBaseSavepoint.getUniqueId(), exceptionInterceptor);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    GBaseSavepoint(String name, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (name == null || name.length() == 0) {
            throw SQLError.createSQLException("Savepoint name can not be NULL or empty", "S1009", exceptionInterceptor);
        }
        this.savepointName = name;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.exceptionInterceptor = exceptionInterceptor;
    }

    public int getSavepointId() throws SQLException {
        throw SQLError.createSQLException("Only named savepoints are supported.", "S1C00", this.exceptionInterceptor);
    }

    public String getSavepointName() throws SQLException {
        return this.savepointName;
    }
}

