/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.GBaseErrForCluster;
import com.gbase.jdbc.GcGBaseLoadBalance;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcGBaseLoadBalanceConnection {
    public java.sql.Connection getGcLoadBanceConnection(Properties props, String originalUrl) throws SQLException {
        String gclusterId = (String)props.get("gclusterId");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!GcGBaseLoadBalance.ipQueueTable.containsKey(gclusterId)) {
            GcGBaseLoadBalance.initClusterIpQueue(gclusterId, props, originalUrl);
        }
        return this.getHeighAvailLoadBalanceConnection(gclusterId, props, originalUrl);
    }

    private SQLException createAllHostGoneAwayExecption(String gclusterId, Map<String, SQLException> exceptionHostMap) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, SQLException> entry : exceptionHostMap.entrySet()) {
            sb.append("\n");
            sb.append("[");
            sb.append(gclusterId);
            sb.append(":");
            sb.append(entry.getKey());
            sb.append("]");
            sb.append(" => ");
            sb.append(entry.getValue().getMessage());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        SQLException sqlEx = SQLError.createSQLException(Messages.getString("NonRegisteringDriver.38") + sb.toString() + Messages.getString("NonRegisteringDriver.18"), "08001", null);
        return sqlEx;
    }

    private java.sql.Connection getHeighAvailLoadBalanceConnection(String gclusterId, Properties props, String originalUrl) throws SQLException {
        Connection newConn = null;
        LinkedHashMap<String, SQLException> exceptionHostMap = new LinkedHashMap<String, SQLException>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        do {
            String ip = GcGBaseLoadBalance.getNiceIp(gclusterId);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (ip == null) {
                throw this.createAllHostGoneAwayExecption(gclusterId, exceptionHostMap);
            }
            props.setProperty("HOST", ip);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                newConn = ConnectionImpl.getInstance(GcGBaseLoadBalanceConnection.host(props), GcGBaseLoadBalanceConnection.port(props), props, GcGBaseLoadBalanceConnection.database(props), originalUrl);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SQLException sqlEx) {
                String sqlStatus = sqlEx.getSQLState();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int errorCode = sqlEx.getErrorCode();
                if (GBaseErrForCluster.isNotRetry(errorCode) || "28000".equals(sqlStatus)) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    throw sqlEx;
                }
                exceptionHostMap.put(ip, sqlEx);
                GcGBaseLoadBalance.setBrokenIp(ip, gclusterId);
                if (newConn == null || newConn.isClosed()) continue;
                newConn.close();
                newConn = null;
            }
            catch (Exception ex) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("NonRegisteringDriver.17") + ex.toString() + Messages.getString("NonRegisteringDriver.18"), "08001", null);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                sqlEx.initCause(ex);
                throw sqlEx;
            }
        } while (newConn == null);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return newConn;
    }

    public static String host(Properties props) {
        return props.getProperty("HOST");
    }

    public static int port(Properties props) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Integer.parseInt(props.getProperty("PORT", "5258"));
    }

    public static String database(Properties props) {
        return props.getProperty("DBNAME");
    }
}

