/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.CallableStatement;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.JDBC42Helper;
import com.gbase.jdbc.JDBC4CallableStatement;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.sql.SQLType;

public class JDBC42CallableStatement
extends JDBC4CallableStatement {
    public JDBC42CallableStatement(GBaseConnection conn, CallableStatement.CallableStatementParamInfo paramInfo) throws SQLException {
        super(conn, paramInfo);
    }

    public JDBC42CallableStatement(GBaseConnection conn, String sql, String catalog, boolean isFunctionCall) throws SQLException {
        super(conn, sql, catalog, isFunctionCall);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    private int checkSqlType(int sqlType) throws SQLException {
        return JDBC42Helper.checkSqlType(sqlType, this.getExceptionInterceptor());
    }

    private int translateAndCheckSqlType(SQLType sqlType) throws SQLException {
        return JDBC42Helper.translateAndCheckSqlType(sqlType, this.getExceptionInterceptor());
    }

    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        super.registerOutParameter(parameterIndex, this.translateAndCheckSqlType(sqlType));
    }

    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        super.registerOutParameter(parameterIndex, this.translateAndCheckSqlType(sqlType), scale);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        super.registerOutParameter(parameterIndex, this.translateAndCheckSqlType(sqlType), typeName);
    }

    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        super.registerOutParameter(parameterName, this.translateAndCheckSqlType(sqlType));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        super.registerOutParameter(parameterName, this.translateAndCheckSqlType(sqlType), scale);
    }

    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        super.registerOutParameter(parameterName, this.translateAndCheckSqlType(sqlType), typeName);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterIndex, JDBC42Helper.convertJavaTimeToJavaSql(x));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterIndex, JDBC42Helper.convertJavaTimeToJavaSql(x), this.checkSqlType(targetSqlType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterIndex, JDBC42Helper.convertJavaTimeToJavaSql(x), this.checkSqlType(targetSqlType), scaleOrLength);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterIndex, JDBC42Helper.convertJavaTimeToJavaSql(x), this.translateAndCheckSqlType(targetSqlType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterIndex, JDBC42Helper.convertJavaTimeToJavaSql(x), this.translateAndCheckSqlType(targetSqlType), scaleOrLength);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterName, JDBC42Helper.convertJavaTimeToJavaSql(x), this.translateAndCheckSqlType(targetSqlType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.connection.getMutex();
        synchronized (object) {
            super.setObject(parameterName, JDBC42Helper.convertJavaTimeToJavaSql(x), this.translateAndCheckSqlType(targetSqlType), scaleOrLength);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }
}

