/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class JDBC42Helper {
    static int translateAndCheckSqlType(SQLType sqlType, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        return JDBC42Helper.checkSqlType(sqlType.getVendorTypeNumber(), exceptionInterceptor);
    }

    static Object convertJavaTimeToJavaSql(Object x) {
        if (x instanceof LocalDate) {
            return Date.valueOf((LocalDate)x);
        }
        if (x instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)x);
        }
        if (x instanceof LocalTime) {
            return Time.valueOf((LocalTime)x);
        }
        return x;
    }

    static int checkSqlType(int sqlType, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (JDBC42Helper.isSqlTypeSupported(sqlType)) {
            return sqlType;
        }
        throw SQLError.createSQLFeatureNotSupportedException(Messages.getString("UnsupportedSQLType.0") + JDBCType.valueOf(sqlType), "S1C00", exceptionInterceptor);
    }

    static boolean isSqlTypeSupported(int sqlType) {
        return sqlType != 2012 && sqlType != 2013 && sqlType != 2014;
    }

    public void main(String[] args) {
        JDBC42Helper jdbc42Helper = new JDBC42Helper();
    }
}

