/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.DatabaseMetaData;
import com.gbase.jdbc.Field;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBC4DatabaseMetaData
extends DatabaseMetaData {
    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    public JDBC4DatabaseMetaData(GBaseConnection connToSet, String databaseToSet) {
        super(connToSet, databaseToSet);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.conn.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT", 1, 255), new Field("", "FUNCTION_SCHEM", 1, 255), new Field("", "FUNCTION_NAME", 1, 255), new Field("", "REMARKS", 1, 255), new Field("", "FUNCTION_TYPE", 5, 6), new Field("", "SPECIFIC_NAME", 1, 255)};
        return this.getProceduresAndOrFunctions(fields, catalog, schemaPattern, functionNamePattern, false, true);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Field[] fields = new Field[]{new Field("", "NAME", 12, 255), new Field("", "MAX_LEN", 4, 10), new Field("", "DEFAULT_VALUE", 12, 255), new Field("", "DESCRIPTION", 12, 255)};
        ArrayList tuples = new ArrayList();
        return JDBC4DatabaseMetaData.buildResultSet(fields, tuples, this.conn);
    }

    @Override
    protected int getJDBC4FunctionNoTableConstant() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 1;
    }
}

