/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.BalanceStrategy;
import com.gbase.jdbc.ConnectionGroup;
import com.gbase.jdbc.ConnectionGroupManager;
import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.LoadBalanceExceptionChecker;
import com.gbase.jdbc.LoadBalancedGBaseConnection;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.NonRegisteringDriver;
import com.gbase.jdbc.PingTarget;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    private long totalPhysicalConnections = 0L;
    private long activePhysicalConnections = 0L;
    private String hostToRemove = null;
    private long lastUsed = 0L;
    private long transactionCount = 0L;
    private ConnectionGroup connectionGroup = null;
    public static final String BLACKLIST_TIMEOUT_PROPERTY_KEY = "loadBalanceBlacklistTimeout";
    protected GBaseConnection currentConn;
    protected List<String> hostList;
    protected Map<String, ConnectionImpl> liveConnections;
    private Map<ConnectionImpl, String> connectionsToHostsMap;
    private long[] responseTimes;
    private Map<String, Integer> hostsToListIndexMap;
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private Properties localProps;
    private boolean isClosed = false;
    private BalanceStrategy balancer;
    private int retriesAllDown;
    private static Map<String, Long> globalBlacklist;
    private int globalBlacklistTimeout = 0;
    private long connectionGroupProxyID = 0L;
    private LoadBalanceExceptionChecker exceptionChecker;
    private Map<Class, Boolean> jdbcInterfacesForProxyCache = new HashMap<Class, Boolean>();
    private GBaseConnection thisAsConnection = null;
    private Map<Class, Class[]> allInterfacesToProxy = new HashMap<Class, Class[]>();

    LoadBalancingConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        String group = props.getProperty("loadBalanceConnectionGroup", null);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        boolean enableJMX = false;
        String enableJMXAsString = props.getProperty("loadBalanceEnableJMX", "false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            enableJMX = Boolean.parseBoolean(enableJMXAsString);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (Exception e) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
        }
        if (group != null) {
            this.connectionGroup = ConnectionGroupManager.getConnectionGroupInstance(group);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (enableJMX) {
                ConnectionGroupManager.registerJmx();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            this.connectionGroupProxyID = this.connectionGroup.registerConnectionProxy(this, hosts);
            hosts = new ArrayList<String>(this.connectionGroup.getInitialHosts());
        }
        this.hostList = hosts;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap<String, ConnectionImpl>(numHosts);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.connectionsToHostsMap = new HashMap<ConnectionImpl, String>(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap<String, Integer>(numHosts);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.localProps.remove("PORT");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < numHosts; ++i) {
            this.hostsToListIndexMap.put(this.hostList.get(i), new Integer(i));
            this.localProps.remove("HOST." + (i + 1));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.localProps.remove("PORT." + (i + 1));
        }
        this.localProps.remove("NUM_HOSTS");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        String lbExceptionChecker = this.localProps.getProperty("loadBalanceExceptionChecker", "com.gbase.jdbc.StandardLoadBalanceExceptionChecker");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        String blacklistTimeoutAsString = this.localProps.getProperty(BLACKLIST_TIMEOUT_PROPERTY_KEY, "0");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            this.globalBlacklistTimeout = Integer.parseInt(blacklistTimeoutAsString);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (NumberFormatException nfe) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceBlacklistTimeout", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        if ("random".equals(strategy)) {
            this.balancer = (BalanceStrategy)Util.loadExtensions(null, props, "com.gbase.jdbc.RandomBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else if ("bestResponseTime".equals(strategy)) {
            this.balancer = (BalanceStrategy)Util.loadExtensions(null, props, "com.gbase.jdbc.BestResponseTimeBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            this.balancer = (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy", null).get(0);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        this.balancer.init(null, props);
        this.exceptionChecker = (LoadBalanceExceptionChecker)Util.loadExtensions(null, props, lbExceptionChecker, "InvalidLoadBalanceExceptionChecker", null).get(0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.exceptionChecker.init(null, props);
        this.thisAsConnection = new LoadBalancedGBaseConnection(this);
        this.pickNewConnection();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public synchronized ConnectionImpl createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        String hostName = hostPortPair[0];
        String portNumber = hostPortPair[1];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String dbName = connProps.getProperty("DBNAME");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (hostName == null) {
            throw new SQLException("Could not find a hostname to start a connection to");
        }
        if (portNumber == null) {
            portNumber = "5258";
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        connProps.setProperty("HOST", hostName);
        connProps.setProperty("PORT", portNumber);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        connProps.setProperty("HOST.1", hostName);
        connProps.setProperty("PORT.1", portNumber);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        connProps.setProperty("NUM_HOSTS", "1");
        connProps.setProperty("roundRobinLoadBalance", "false");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ConnectionImpl conn = (ConnectionImpl)ConnectionImpl.getInstance(hostName, Integer.parseInt(portNumber), connProps, dbName, "jdbc:gbase://" + hostName + ":" + portNumber + "/");
        this.liveConnections.put(hostPortSpec, conn);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        ++this.activePhysicalConnections;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ++this.totalPhysicalConnections;
        conn.setProxy(this.thisAsConnection);
        return conn;
    }

    void dealWithInvocationException(InvocationTargetException e) throws SQLException, InvocationTargetException {
        Throwable t = e.getTargetException();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (t != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (t instanceof SQLException && this.shouldExceptionTriggerFailover((SQLException)t)) {
                this.invalidateCurrentConnection();
                this.pickNewConnection();
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(t.getMessage());
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void invalidateCurrentConnection() throws SQLException {
        block9: {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!this.currentConn.isClosed()) {
                    this.currentConn.close();
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var2_1 = null;
                if (!this.isGlobalBlacklistEnabled()) break block9;
                this.addToGlobalBlacklist(this.connectionsToHostsMap.get(this.currentConn));
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.isGlobalBlacklistEnabled()) {
                    this.addToGlobalBlacklist(this.connectionsToHostsMap.get(this.currentConn));
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
                String mappedHost = this.connectionsToHostsMap.remove(this.currentConn);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) throw throwable;
                int hostIndex = this.hostsToListIndexMap.get(mappedHost);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                long[] lArray = this.responseTimes;
                synchronized (this.responseTimes) {
                    this.responseTimes[hostIndex] = 0L;
                    // ** MonitorExit[var5_8] (shouldn't be in output)
                    throw throwable;
                }
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
        String mappedHost = this.connectionsToHostsMap.remove(this.currentConn);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) return;
        int hostIndex = this.hostsToListIndexMap.get(mappedHost);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = 0L;
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator<ConnectionImpl> allConnections = this.liveConnections.values().iterator();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (allConnections.hasNext()) {
                try {
                    --this.activePhysicalConnections;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    allConnections.next().close();
                }
                catch (SQLException sQLException) {}
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!this.isClosed) {
                this.balancer.destroy();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.connectionGroup != null) {
                    this.connectionGroup.closeConnectionProxy(this);
                }
            }
            this.liveConnections.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.connectionsToHostsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = method.getName();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if ("getLoadBalanceSafeProxy".equals(methodName)) {
            return this.currentConn;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if ("equals".equals(methodName) && args.length == 1) {
            if (!(args[0] instanceof Proxy)) return this.equals(args[0]);
            return ((Proxy)args[0]).equals(this);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if ("hashCode".equals(methodName)) {
            return new Integer(this.hashCode());
        }
        if ("close".equals(methodName)) {
            this.closeAllConnections();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.isClosed = true;
            return null;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if ("isClosed".equals(methodName)) {
            return this.isClosed;
        }
        if (this.isClosed) {
            throw SQLError.createSQLException("No operations allowed after connection closed.", "08003", null);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = LoadBalancingConnectionProxy.getLocalTimeBestResolution();
            ++this.transactionCount;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        Object result = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            try {
                this.lastUsed = System.currentTimeMillis();
                result = method.invoke((Object)this.thisAsConnection, args);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (result != null) {
                    if (result instanceof Statement) {
                        ((Statement)result).setPingTarget(this);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    result = this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (InvocationTargetException e) {
                this.dealWithInvocationException(e);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var8_7 = null;
                if (!"commit".equals(methodName)) {
                    if (!"rollback".equals(methodName)) return result;
                }
                this.inTransaction = false;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                String host = this.connectionsToHostsMap.get(this.currentConn);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (host != null) {
                    long[] lArray = this.responseTimes;
                    // MONITORENTER : this.responseTimes
                    int hostIndex = this.hostsToListIndexMap.get(host);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (hostIndex < this.responseTimes.length) {
                        this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    // MONITOREXIT : lArray
                }
                this.pickNewConnection();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return result;
            }
            Object var8_6 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) return result;
            }
            this.inTransaction = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String host = this.connectionsToHostsMap.get(this.currentConn);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                int hostIndex = this.hostsToListIndexMap.get(host);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return result;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) throw throwable;
            }
            this.inTransaction = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String host = this.connectionsToHostsMap.get(this.currentConn);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                int hostIndex = this.hostsToListIndexMap.get(host);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw throwable;
        }
    }

    protected synchronized void pickNewConnection() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            return;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.currentConn.isClosed()) {
            this.invalidateCurrentConnection();
        }
        boolean currentAutoCommit = this.currentConn.getAutoCommit();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int currentTransIsolation = this.currentConn.getTransactionIsolation();
        int pingTimeout = this.currentConn.getLoadBalancePingTimeout();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        boolean pingBeforeReturn = this.currentConn.getLoadBalanceValidateConnectionOnSwapServer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int hostsToTry = this.hostList.size();
        for (int hostsTried = 0; hostsTried <= hostsToTry; ++hostsTried) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                ConnectionImpl newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.currentConn != null) {
                    if (pingBeforeReturn) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (pingTimeout == 0) {
                            newConn.ping();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            newConn.pingInternal(true, pingTimeout);
                        }
                    }
                    newConn.setTransactionIsolation(currentTransIsolation);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    newConn.setAutoCommit(currentAutoCommit);
                }
                this.currentConn = newConn;
                return;
            }
            catch (SQLException e) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!this.shouldExceptionTriggerFailover(e)) continue;
                this.invalidateCurrentConnection();
                continue;
            }
        }
        this.isClosed = true;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    Object proxyIfInterfaceIsJdbc(Object toProxy, Class clazz) {
        if (this.isInterfaceJdbc(clazz)) {
            Class[] interfacesToProxy = this.getAllInterfacesToProxy(clazz);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfacesToProxy, (InvocationHandler)this.createConnectionProxy(toProxy));
        }
        return toProxy;
    }

    private Class[] getAllInterfacesToProxy(Class clazz) {
        Class[] interfacesToProxy = this.allInterfacesToProxy.get(clazz);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (interfacesToProxy != null) {
            return interfacesToProxy;
        }
        LinkedList interfaces = new LinkedList();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Class superClass = clazz;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (!superClass.equals(Object.class)) {
            Class<?>[] declared = superClass.getInterfaces();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (int i = 0; i < declared.length; ++i) {
                interfaces.add(declared[i]);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            superClass = superClass.getSuperclass();
        }
        interfacesToProxy = new Class[interfaces.size()];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        interfaces.toArray(interfacesToProxy);
        this.allInterfacesToProxy.put(clazz, interfacesToProxy);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return interfacesToProxy;
    }

    private boolean isInterfaceJdbc(Class clazz) {
        if (this.jdbcInterfacesForProxyCache.containsKey(clazz)) {
            return this.jdbcInterfacesForProxyCache.get(clazz);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < interfaces.length; ++i) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String packageName = interfaces[i].getPackage().getName();
            if ("java.sql".equals(packageName) || "javax.sql".equals(packageName) || "com.gbase.jdbc".equals(packageName)) {
                this.jdbcInterfacesForProxyCache.put(clazz, new Boolean(true));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return true;
            }
            if (!this.isInterfaceJdbc(interfaces[i])) continue;
            this.jdbcInterfacesForProxyCache.put(clazz, new Boolean(true));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return true;
        }
        this.jdbcInterfacesForProxyCache.put(clazz, new Boolean(false));
        return false;
    }

    protected ConnectionErrorFiringInvocationHandler createConnectionProxy(Object toProxy) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return new ConnectionErrorFiringInvocationHandler(toProxy);
    }

    private static long getLocalTimeBestResolution() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (getLocalTimeMethod != null) {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return (Long)getLocalTimeMethod.invoke(null, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException e) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doPing() throws SQLException {
        SQLException se = null;
        boolean foundHost = false;
        int pingTimeout = this.currentConn.getLoadBalancePingTimeout();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (String host : this.hostList) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                ConnectionImpl conn = this.liveConnections.get(host);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (conn == null) continue;
                try {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (pingTimeout == 0) {
                        conn.ping();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        conn.pingInternal(true, pingTimeout);
                    }
                    foundHost = true;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (SQLException e) {
                    --this.activePhysicalConnections;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (host.equals(this.connectionsToHostsMap.get(this.currentConn))) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        this.closeAllConnections();
                        this.isClosed = true;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        throw e;
                    }
                    if (e.getMessage().equals(Messages.getString("Connection.exceededConnectionLifetime"))) {
                        if (se == null) {
                            se = e;
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        se = e;
                        if (this.isGlobalBlacklistEnabled()) {
                            this.addToGlobalBlacklist(host);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                    }
                    this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                }
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!foundHost) {
            this.closeAllConnections();
            this.isClosed = true;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (se != null) {
                throw se;
            }
            ((ConnectionImpl)this.currentConn).throwConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGlobalBlacklist(String host, long timeout) {
        if (this.isGlobalBlacklistEnabled()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.put(host, new Long(timeout));
            }
        }
    }

    public void addToGlobalBlacklist(String host) {
        this.addToGlobalBlacklist(host, System.currentTimeMillis() + (long)this.globalBlacklistTimeout);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public boolean isGlobalBlacklistEnabled() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.globalBlacklistTimeout > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getGlobalBlacklist() {
        if (!this.isGlobalBlacklistEnabled()) {
            String localHostToRemove = this.hostToRemove;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.hostToRemove != null) {
                HashMap<String, Long> fakedBlacklist = new HashMap<String, Long>();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fakedBlacklist.put(localHostToRemove, new Long(System.currentTimeMillis() + 5000L));
                return fakedBlacklist;
            }
            return new HashMap<String, Long>(1);
        }
        HashMap<String, Long> blacklistClone = new HashMap<String, Long>(globalBlacklist.size());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Map<String, Long> fakedBlacklist = globalBlacklist;
        synchronized (fakedBlacklist) {
            blacklistClone.putAll(globalBlacklist);
        }
        Set keys = blacklistClone.keySet();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        keys.retainAll(this.hostList);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (keys.size() == this.hostList.size()) {
            return new HashMap<String, Long>(1);
        }
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String host = (String)i.next();
            Long timeout = globalBlacklist.get(host);
            if (timeout == null || timeout >= System.currentTimeMillis()) continue;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.remove(host);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            i.remove();
        }
        return blacklistClone;
    }

    public boolean shouldExceptionTriggerFailover(SQLException ex) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.exceptionChecker.shouldExceptionTriggerFailover(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostWhenNotInUse(String host) throws SQLException {
        int timeBetweenChecks = 1000;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long timeBeforeHardFail = 15000L;
        this.addToGlobalBlacklist(host, timeBeforeHardFail + 1000L);
        long cur = System.currentTimeMillis();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (System.currentTimeMillis() - timeBeforeHardFail < cur) {
            LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
            synchronized (loadBalancingConnectionProxy) {
                this.hostToRemove = host;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!host.equals(this.currentConn.getHost())) {
                    this.removeHost(host);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    return;
                }
            }
            try {
                Thread.sleep(timeBetweenChecks);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Thread.interrupted();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
        this.removeHost(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHost(String host) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            if (this.connectionGroup != null) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.connectionGroup.getInitialHosts().size() == 1 && this.connectionGroup.getInitialHosts().contains(host)) {
                    throw SQLError.createSQLException("Cannot remove only configured host.", null);
                }
            }
            this.hostToRemove = host;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (host.equals(this.currentConn.getHost())) {
                this.closeAllConnections();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                this.connectionsToHostsMap.remove(this.liveConnections.remove(host));
                Integer idx = this.hostsToListIndexMap.remove(host);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                long[] newResponseTimes = new long[this.responseTimes.length - 1];
                int newIdx = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Iterator<String> i = this.hostList.iterator();
                while (i.hasNext()) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    String copyHost = i.next();
                    if (idx != null && idx < this.responseTimes.length) {
                        newResponseTimes[newIdx] = this.responseTimes[idx];
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        this.hostsToListIndexMap.put(copyHost, new Integer(newIdx));
                    }
                    ++newIdx;
                }
                this.responseTimes = newResponseTimes;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addHost(String host) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            if (this.hostsToListIndexMap.containsKey(host)) {
                return false;
            }
            long[] newResponseTimes = new long[this.responseTimes.length + 1];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (int i = 0; i < this.responseTimes.length; ++i) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                newResponseTimes[i] = this.responseTimes[i];
            }
            this.responseTimes = newResponseTimes;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.hostList.add(host);
            this.hostsToListIndexMap.put(host, new Integer(this.responseTimes.length - 1));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return true;
    }

    public long getLastUsed() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.lastUsed;
    }

    public boolean inTransaction() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.inTransaction;
    }

    public long getTransactionCount() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.transactionCount;
    }

    public long getActivePhysicalConnectionCount() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.activePhysicalConnections;
    }

    public long getTotalPhysicalConnectionCount() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.totalPhysicalConnections;
    }

    public long getConnectionGroupProxyID() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.connectionGroupProxyID;
    }

    public String getCurrentActiveHost() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        GBaseConnection c = this.currentConn;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (c != null) {
            String o = this.connectionsToHostsMap.get(c);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (o != null) {
                return o.toString();
            }
        }
        return null;
    }

    public long getCurrentTransactionDuration() {
        long st = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.inTransaction && (st = this.transactionStartTime) > 0L) {
            return LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
        }
        return 0L;
    }

    static {
        try {
            getLocalTimeMethod = System.class.getMethod("nanoTime", new Class[0]);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        globalBlacklist = new HashMap<String, Long>();
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
            Object result = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                result = method.invoke(this.invokeOn, args);
                if (result != null) {
                    result = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (InvocationTargetException e) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e);
            }
            return result;
        }
    }
}

