/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.exceptions.CustomRuntimeException;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "com.gbase.jdbc.LocalizedErrorMessages";
    private static final ResourceBundle RESOURCE_BUNDLE;

    public static String getString(String keyStr) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (RESOURCE_BUNDLE == null) {
            throw new CustomRuntimeException("Localized messages from resource bundle 'com.gbase.jdbc.LocalizedErrorMessages' not loaded during initialization of driver.");
        }
        try {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (keyStr == null) {
                throw new IllegalArgumentException("Message keyStr can not be null");
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String message = RESOURCE_BUNDLE.getString(keyStr);
            if (message == null) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                message = "Missing error message for keyStr '" + keyStr + "'";
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return message;
        }
        catch (MissingResourceException e) {
            return '!' + keyStr + '!';
        }
    }

    public static String getString(String keyStr, Object[] argsArr) {
        return MessageFormat.format(Messages.getString(keyStr), argsArr);
    }

    private Messages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        ResourceBundle temp = null;
        try {
            try {
                temp = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault(), Messages.class.getClassLoader());
            }
            catch (Throwable t) {
                try {
                    temp = ResourceBundle.getBundle(BUNDLE_NAME);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (Throwable t2) {
                    RuntimeException rt = new RuntimeException("Can't load resource bundle due to underlying exception " + t.toString());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    rt.initCause(t2);
                    throw rt;
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var5_2 = null;
                RESOURCE_BUNDLE = temp;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return;
            }
            Object var5_1 = null;
            RESOURCE_BUNDLE = temp;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            RESOURCE_BUNDLE = temp;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw throwable;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }
}

