/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.Driver;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.Properties;

public class MiniAdmin {
    private Connection conn;

    public MiniAdmin(java.sql.Connection conn) throws SQLException {
        if (conn == null) {
            conn = new ConnectionImpl();
            if (!conn.isClosed()) {
                conn.close();
            }
            throw SQLError.createSQLException(Messages.getString("MiniAdmin.0"), "S1000", ((ConnectionImpl)conn).getExceptionInterceptor());
        }
        if (!(conn instanceof Connection)) {
            throw SQLError.createSQLException(Messages.getString("MiniAdmin.1"), "S1000", ((ConnectionImpl)conn).getExceptionInterceptor());
        }
        this.conn = (Connection)conn;
    }

    public MiniAdmin(String jdbcUrl) throws SQLException {
        this(jdbcUrl, new Properties());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public MiniAdmin(String jdbcUrl, Properties props) throws SQLException {
        this.conn = (Connection)new Driver().connect(jdbcUrl, props);
    }

    public void shutdown() throws SQLException {
        this.conn.shutdownServer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }
}

