/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.exceptions.CustomRuntimeException;
import com.gbase.jdbc.log.Log;
import com.gbase.jdbc.profiler.ProfilerEventHandler;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ProfilerEventHandlerFactory {
    private Log log = null;
    private Connection ownerConnection = null;
    private static final Map CONNECTIONS_TO_SINKS = new HashMap();

    public static synchronized void removeInstance(Connection conn) {
        ProfilerEventHandler handler = (ProfilerEventHandler)CONNECTIONS_TO_SINKS.remove(conn);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (handler != null) {
            handler.destroy();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    private ProfilerEventHandlerFactory(Connection conn) {
        this.ownerConnection = conn;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            this.log = this.ownerConnection.getLog();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (SQLException sqlEx) {
            throw new CustomRuntimeException("Unable to get logger from connection");
        }
    }

    public static synchronized ProfilerEventHandler getInstance(GBaseConnection conn) throws SQLException {
        ProfilerEventHandler handler = (ProfilerEventHandler)CONNECTIONS_TO_SINKS.get(conn);
        if (handler == null) {
            handler = (ProfilerEventHandler)Util.getInstance(conn.getProfilerEventHandler(), new Class[0], new Object[0], conn.getExceptionInterceptor());
            conn.initializeExtension(handler);
            CONNECTIONS_TO_SINKS.put(conn, handler);
        }
        return handler;
    }
}

