/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.CharsetMapping;
import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.Field;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    Field[] fields;
    boolean useOldAliasBehavior = false;
    boolean treatYearAsDate = true;
    int caseSensitiveFlag = 0;
    private ExceptionInterceptor exceptionInterceptor;

    private static int clampedGetLength(Field f) {
        long fieldLength = f.getLength();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (fieldLength > Integer.MAX_VALUE) {
            fieldLength = Integer.MAX_VALUE;
        }
        return (int)fieldLength;
    }

    private static final boolean isDecimalType(int sqlType) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (sqlType) {
            case -7: {
                return true;
            }
            case -6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 4: {
                return true;
            }
            case -5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public ResultSetMetaData(Field[] fields, boolean useOldAliasBehavior, boolean treatYearAsDate, int caseSensitiveFlag, ExceptionInterceptor exceptionInterceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.fields = fields;
        this.useOldAliasBehavior = useOldAliasBehavior;
        this.treatYearAsDate = treatYearAsDate;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.caseSensitiveFlag = caseSensitiveFlag;
        this.exceptionInterceptor = exceptionInterceptor;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public String getColumnCharacterEncoding(int column) throws SQLException {
        String gbaseName = this.getColumnCharacterSet(column);
        String javaName = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gbaseName != null) {
            javaName = CharsetMapping.getJavaEncodingForGBaseEncoding(gbaseName, null);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return javaName;
    }

    public String getCatalogName(int column) throws SQLException {
        Field f = this.getField(column);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String database = f.getDatabaseName();
        return database == null ? "" : database;
    }

    public String getColumnClassName(int column) throws SQLException {
        Field f = this.getField(column);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return ResultSetMetaData.getClassNameForJavaType(f.getSQLType(), f.isUnsigned(), f.getGBaseType(), f.isBinary() || f.isBlob(), f.isOpaqueBinary(), this.treatYearAsDate);
    }

    public int getColumnCount() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.fields.length;
    }

    public String getColumnCharacterSet(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getField(column).getCharacterSet();
    }

    public String getColumnLabel(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        String name = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.useOldAliasBehavior) {
            name = this.getColumnName(column);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            name = this.getField(column).getColumnLabel();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        if (name != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.caseSensitiveFlag == 1) {
                name = name.toLowerCase();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (this.caseSensitiveFlag == 2) {
                name = name.toUpperCase();
            }
        }
        return name;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        Field f = this.getField(column);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int lengthInBytes = ResultSetMetaData.clampedGetLength(f);
        return lengthInBytes / f.getMaxBytesPerCharacter();
    }

    public int getColumnType(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getField(column).getSQLType();
    }

    public String getColumnName(int column) throws SQLException {
        String name = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.useOldAliasBehavior) {
            name = this.getField(column).getName();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            name = this.getField(column).getNameNoAliases();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (name != null && name.length() == 0) {
                name = this.getField(column).getName();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
        if (name != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.caseSensitiveFlag == 1) {
                name = name.toLowerCase();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (this.caseSensitiveFlag == 2) {
                name = name.toUpperCase();
            }
        }
        return name;
    }

    protected Field getField(int columnIndex) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw SQLError.createSQLException(Messages.getString("ResultSetMetaData.46"), "S1002", this.exceptionInterceptor);
        }
        return this.fields[columnIndex - 1];
    }

    public int getScale(int column) throws SQLException {
        Field f = this.getField(column);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (ResultSetMetaData.isDecimalType(f.getSQLType())) {
            return f.getDecimals();
        }
        return 0;
    }

    public String getColumnTypeName(int column) throws SQLException {
        Field field = this.getField(column);
        int gbaseType = field.getGBaseType();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int jdbcType = field.getSQLType();
        switch (gbaseType) {
            case 16: {
                return "BIT";
            }
            case 0: 
            case 246: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "DECIMAL UNSIGNED" : "DECIMAL";
            }
            case 1: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "TINYINT UNSIGNED" : "TINYINT";
            }
            case 2: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "SMALLINT UNSIGNED" : "SMALLINT";
            }
            case 3: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "INT UNSIGNED" : "INT";
            }
            case 4: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "FLOAT UNSIGNED" : "FLOAT";
            }
            case 5: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "DOUBLE UNSIGNED" : "DOUBLE";
            }
            case 6: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "NULL";
            }
            case 7: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "TIMESTAMP";
            }
            case 8: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "BIGINT UNSIGNED" : "BIGINT";
            }
            case 9: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return field.isUnsigned() ? "MEDIUMINT UNSIGNED" : "MEDIUMINT";
            }
            case 10: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "DATE";
            }
            case 11: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "TIME";
            }
            case 12: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "DATETIME";
            }
            case 249: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "TINYBLOB";
            }
            case 250: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "MEDIUMBLOB";
            }
            case 251: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "LONGBLOB";
            }
            case 252: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.getField(column).isBinary()) {
                    return "BLOB";
                }
                return "TEXT";
            }
            case 15: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "VARCHAR";
            }
            case 253: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (jdbcType == -3) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case 254: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (jdbcType == -2) {
                    return "BINARY";
                }
                return "CHAR";
            }
            case 247: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "ENUM";
            }
            case 13: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "YEAR";
            }
            case 248: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "SET";
            }
            case 255: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "GEOMETRY";
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "UNKNOWN";
    }

    public String getSchemaName(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        Field f = this.getField(column);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (ResultSetMetaData.isDecimalType(f.getSQLType())) {
            if (f.getDecimals() > 0) {
                return ResultSetMetaData.clampedGetLength(f) - 1 + f.getPrecisionAdjustFactor();
            }
            return ResultSetMetaData.clampedGetLength(f) + f.getPrecisionAdjustFactor();
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (f.getGBaseType()) {
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return ResultSetMetaData.clampedGetLength(f);
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return ResultSetMetaData.clampedGetLength(f) / f.getMaxBytesPerCharacter();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        Field f = this.getField(column);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return f.isAutoIncrement();
    }

    public String getTableName(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.useOldAliasBehavior) {
            return this.getField(column).getTableName();
        }
        return this.getField(column).getTableNameNoAliases();
    }

    public boolean isCurrency(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (field.isBinary()) {
                    return true;
                }
                String collationName = field.getCollation();
                return collationName != null && !collationName.endsWith("_ci");
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    public int isNullable(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.getField(column).isNotNull()) {
            return 1;
        }
        return 0;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.isWritable(column);
    }

    public boolean isSearchable(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return true;
    }

    public boolean isReadOnly(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getField(column).isReadOnly();
    }

    public boolean isWritable(int column) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return !this.isReadOnly(column);
    }

    public boolean isSigned(int column) throws SQLException {
        Field f = this.getField(column);
        int sqlType = f.getSQLType();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return !f.isUnsigned();
            }
            case 91: 
            case 92: 
            case 93: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return false;
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    static String getClassNameForJavaType(int javaType, boolean isUnsigned, int gbaseTypeIfKnown, boolean isBinaryOrBlob, boolean isOpaqueBinary, boolean treatYearAsDate) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (javaType) {
            case -7: 
            case 16: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "java.lang.Boolean";
            }
            case -6: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (isUnsigned) {
                    return "java.lang.Integer";
                }
                return "java.lang.Integer";
            }
            case 5: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (isUnsigned) {
                    return "java.lang.Integer";
                }
                return "java.lang.Integer";
            }
            case 4: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!isUnsigned || gbaseTypeIfKnown == 9) {
                    return "java.lang.Integer";
                }
                return "java.lang.Long";
            }
            case -5: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!isUnsigned) {
                    return "java.lang.Long";
                }
                return "java.math.BigInteger";
            }
            case 2: 
            case 3: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "java.math.BigDecimal";
            }
            case 7: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!isOpaqueBinary) {
                    return "java.lang.String";
                }
                return "[B";
            }
            case -4: 
            case -3: 
            case -2: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (gbaseTypeIfKnown == 255) {
                    return "[B";
                }
                if (isBinaryOrBlob) {
                    return "[B";
                }
                return "java.lang.String";
            }
            case 91: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return treatYearAsDate || gbaseTypeIfKnown != 13 ? "java.sql.Date" : "java.lang.Short";
            }
            case 92: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "java.sql.Time";
            }
            case 93: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return "java.sql.Timestamp";
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return "java.lang.Object";
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append(super.toString());
        toStringBuf.append(" - Field level information: ");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < this.fields.length; ++i) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            toStringBuf.append("\n\t");
            toStringBuf.append(this.fields[i].toString());
        }
        return toStringBuf.toString();
    }

    public Object unwrap(Class iface) throws SQLException {
        try {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return Util.cast(iface, this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.exceptionInterceptor);
        }
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return iface.isInstance(this);
    }
}

