/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.CommunicationsException;
import com.gbase.jdbc.Connection;
import com.gbase.jdbc.Constants;
import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseDataTruncation;
import com.gbase.jdbc.GBaseErrorNumbers;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.NotImplemented;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.exceptions.CustomRuntimeException;
import com.gbase.jdbc.exceptions.GBaseDataException;
import com.gbase.jdbc.exceptions.GBaseIntegrityConstraintViolationException;
import com.gbase.jdbc.exceptions.GBaseNonTransientConnectionException;
import com.gbase.jdbc.exceptions.GBaseQueryInterruptedException;
import com.gbase.jdbc.exceptions.GBaseSyntaxErrorException;
import com.gbase.jdbc.exceptions.GBaseTransactionRollbackException;
import com.gbase.jdbc.exceptions.GBaseTransientConnectionException;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.BindException;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SQLError {
    static final int ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    private static Map gbaseToSql99State;
    private static Map gbaseToSqlState;
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = "S0001";
    public static final String SQL_STATE_BASE_TABLE_NOT_FOUND = "S0002";
    public static final String SQL_STATE_COLUMN_ALREADY_EXISTS = "S0021";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = "42S02";
    public static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    public static final String SQL_STATE_COLUMN_NOT_FOUND = "S0022";
    public static final String SQL_STATE_CONNECTION_IN_USE = "08002";
    public static final String SQL_STATE_CONNECTION_FAIL_DURING_TX = "08007";
    public static final String SQL_STATE_CONNECTION_REJECTED = "08004";
    public static final String SQL_STATE_CONNECTION_NOT_OPEN = "08003";
    public static final String SQL_STATE_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String SQL_STATE_DATE_TRUNCATED = "01004";
    public static final String SQL_STATE_DISCONNECT_ERROR = "01002";
    public static final String SQL_STATE_DEADLOCK = "41000";
    public static final String SQL_STATE_DRIVER_NOT_CAPABLE = "S1C00";
    public static final String SQL_STATE_DIVISION_BY_ZERO = "22012";
    public static final String SQL_STATE_GENERAL_ERROR = "S1000";
    public static final String SQL_STATE_ERROR_IN_ROW = "01S01";
    public static final String SQL_STATE_INDEX_ALREADY_EXISTS = "S0011";
    public static final String SQL_STATE_ILLEGAL_ARGUMENT = "S1009";
    public static final String SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = "21S01";
    public static final String SQL_STATE_INDEX_NOT_FOUND = "S0012";
    public static final String SQL_STATE_INVALID_CHARACTER_VALUE_FOR_CAST = "22018";
    public static final String SQL_STATE_INVALID_AUTH_SPEC = "28000";
    public static final String SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = "01S00";
    public static final String SQL_STATE_INVALID_COLUMN_NUMBER = "S1002";
    public static final String SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = "01S04";
    public static final String SQL_STATE_MEMORY_ALLOCATION_FAILURE = "S1001";
    public static final String SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = "01S03";
    public static final String SQL_STATE_NO_DEFAULT_FOR_COLUMN = "S0023";
    public static final String SQL_STATE_PRIVILEGE_NOT_REVOKED = "01006";
    public static final String SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String SQL_STATE_TIMEOUT_EXPIRED = "S1T00";
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";
    public static final String SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = "08001";
    public static final String SQL_STATE_TRANSACTION_RESOLUTION_UNKNOWN = "08007";
    public static final String SQL_STATE_INVALID_TRANSACTION_TERMINATION = "2D000";
    public static final String SQL_STATE_WRONG_NO_OF_PARAMETERS = "07001";
    private static final long DEFAULT_WAIT_TIMEOUT_SECONDS = 28800L;
    private static Map sqlStateMessages;
    private static final int DUE_TO_TIMEOUT_FALSE = 0;
    private static final int DUE_TO_TIMEOUT_MAYBE = 2;
    private static final int DUE_TO_TIMEOUT_TRUE = 1;
    private static final Constructor JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR;

    static SQLWarning convertShowWarningsToSQLWarnings(Connection connection) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.convertShowWarningsToSQLWarnings(connection, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLWarning convertShowWarningsToSQLWarnings(Connection connection, int warningCountIfKnown, boolean forTruncationOnly) throws SQLException {
        SQLException sqlEx22;
        SQLException reThrow2;
        GBaseDataTruncation gBaseDataTruncation;
        Statement stmt = null;
        ResultSet warnRs = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        SQLWarning currentWarning = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            if (warningCountIfKnown < 100) {
                stmt = connection.createStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (stmt.getMaxRows() != 0) {
                    stmt.setMaxRows(0);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            } else {
                stmt = connection.createStatement(1003, 1007);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            warnRs = stmt.executeQuery("SHOW WARNINGS");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (warnRs.next()) {
                int code = warnRs.getInt("Code");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (forTruncationOnly) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (code == 1265 || code == 1264) {
                        GBaseDataTruncation newTruncation = new GBaseDataTruncation(warnRs.getString("Message"), 0, false, false, 0, 0, code);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (currentWarning == null) {
                            currentWarning = newTruncation;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            currentWarning.setNextWarning(newTruncation);
                        }
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue;
                }
                String level = warnRs.getString("Level");
                String message = warnRs.getString("Message");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                SQLWarning newWarning = new SQLWarning(message, SQLError.gbaseToSqlState(code, connection.getUseSqlStateCodes()), code);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (currentWarning == null) {
                    currentWarning = newWarning;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    continue;
                }
                currentWarning.setNextWarning(newWarning);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (forTruncationOnly && currentWarning != null) {
                throw currentWarning;
            }
            gBaseDataTruncation = currentWarning;
            Object var11_11 = null;
            reThrow2 = null;
        }
        catch (Throwable throwable) {
            SQLException sqlEx22;
            Object var11_12 = null;
            SQLException reThrow2 = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (warnRs != null) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    warnRs.close();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (SQLException sqlEx22) {
                    reThrow2 = sqlEx22;
                }
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (stmt != null) {
                try {
                    stmt.close();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (SQLException sqlEx22) {
                    reThrow2 = sqlEx22;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
            if (reThrow2 != null) {
                throw reThrow2;
            }
            throw throwable;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (warnRs != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                warnRs.close();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SQLException sqlEx22) {
                reThrow2 = sqlEx22;
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (stmt != null) {
            try {
                stmt.close();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SQLException sqlEx22) {
                reThrow2 = sqlEx22;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
        if (reThrow2 != null) {
            throw reThrow2;
        }
        return gBaseDataTruncation;
    }

    public static void dumpSqlStatesMappingsAsXml() throws IllegalAccessException {
        TreeMap<Integer, Integer> allErrorNumbers = new TreeMap<Integer, Integer>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        HashMap<Object, String> gbaseErrorNumbersToNames = new HashMap<Object, String>();
        Integer errorNumber = null;
        Iterator gbaseErrorNumbers = gbaseToSql99State.keySet().iterator();
        while (gbaseErrorNumbers.hasNext()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            errorNumber = (Integer)gbaseErrorNumbers.next();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            allErrorNumbers.put(errorNumber, errorNumber);
        }
        gbaseErrorNumbers = gbaseToSqlState.keySet().iterator();
        while (gbaseErrorNumbers.hasNext()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            errorNumber = (Integer)gbaseErrorNumbers.next();
            allErrorNumbers.put(errorNumber, errorNumber);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        Field[] possibleFields = GBaseErrorNumbers.class.getDeclaredFields();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < possibleFields.length; ++i) {
            String fieldName = possibleFields[i].getName();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!fieldName.startsWith("ER_")) continue;
            gbaseErrorNumbersToNames.put(possibleFields[i].get(null), fieldName);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        System.out.println("<ErrorMappings>");
        Iterator allErrorNumbersIter = allErrorNumbers.keySet().iterator();
        while (allErrorNumbersIter.hasNext()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            errorNumber = (Integer)allErrorNumbersIter.next();
            String sql92State = SQLError.gbaseToSql99(errorNumber);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String oldSqlState = SQLError.gbaseToXOpen(errorNumber);
            System.out.println("   <ErrorMapping gbaseErrorNumber=\"" + errorNumber + "\" gbaseErrorName=\"" + gbaseErrorNumbersToNames.get(errorNumber) + "\" legacySqlState=\"" + (oldSqlState == null ? "" : oldSqlState) + "\" sql92SqlState=\"" + (sql92State == null ? "" : sql92State) + "\"/>");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        System.out.println("</ErrorMappings>");
    }

    static String get(String stateCode) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return (String)sqlStateMessages.get(stateCode);
    }

    private static String gbaseToSql99(int errno) {
        Integer err = Constants.integerValueOf(errno);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gbaseToSql99State.containsKey(err)) {
            return (String)gbaseToSql99State.get(err);
        }
        return "HY000";
    }

    static String gbaseToSqlState(int errno, boolean useSql92States) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (useSql92States) {
            return SQLError.gbaseToSql99(errno);
        }
        return SQLError.gbaseToXOpen(errno);
    }

    private static String gbaseToXOpen(int errno) {
        Integer err = Constants.integerValueOf(errno);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gbaseToSqlState.containsKey(err)) {
            return (String)gbaseToSqlState.get(err);
        }
        return SQL_STATE_GENERAL_ERROR;
    }

    public static SQLException createSQLException(String message, String sqlState, ExceptionInterceptor interceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.createSQLException(message, sqlState, 0, interceptor);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.createSQLException(message, interceptor, null);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor, Connection conn) {
        SQLException sqlEx = new SQLException(message);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.runThroughExceptionInterceptor(interceptor, sqlEx, conn);
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.createSQLException(message, sqlState, cause, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor, Connection conn) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        SQLException sqlEx = SQLError.createSQLException(message, sqlState, interceptor);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        sqlEx.initCause(cause);
        return SQLError.runThroughExceptionInterceptor(interceptor, sqlEx, conn);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, ExceptionInterceptor interceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor, Connection conn) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            SQLException sqlEx = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (sqlState != null) {
                if (sqlState.startsWith("08")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (isTransient) {
                        if (!Util.isJdbc4()) {
                            sqlEx = new GBaseTransientConnectionException(message, sqlState, vendorErrorCode);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseTransientConnectionException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor);
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else if (!Util.isJdbc4()) {
                        sqlEx = new GBaseNonTransientConnectionException(message, sqlState, vendorErrorCode);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseNonTransientConnectionException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                } else if (sqlState.startsWith("22")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!Util.isJdbc4()) {
                        sqlEx = new GBaseDataException(message, sqlState, vendorErrorCode);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseDataException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                } else if (sqlState.startsWith("23")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!Util.isJdbc4()) {
                        sqlEx = new GBaseIntegrityConstraintViolationException(message, sqlState, vendorErrorCode);
                    } else {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseIntegrityConstraintViolationException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                } else if (sqlState.startsWith("42")) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!Util.isJdbc4()) {
                        sqlEx = new GBaseSyntaxErrorException(message, sqlState, vendorErrorCode);
                    } else {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseSyntaxErrorException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (sqlState.startsWith("40")) {
                    if (!Util.isJdbc4()) {
                        sqlEx = new GBaseTransactionRollbackException(message, sqlState, vendorErrorCode);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseTransactionRollbackException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, Constants.integerValueOf(vendorErrorCode)}, interceptor);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (sqlState.startsWith("70100")) {
                    if (!Util.isJdbc4()) {
                        sqlEx = new GBaseQueryInterruptedException(message, sqlState, vendorErrorCode);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        sqlEx = (SQLException)Util.getInstance("com.gbase.jdbc.exceptions.jdbc4.GBaseQueryInterruptedException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                } else {
                    sqlEx = new SQLException(message, sqlState, vendorErrorCode);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            } else {
                sqlEx = new SQLException(message, sqlState, vendorErrorCode);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return SQLError.runThroughExceptionInterceptor(interceptor, sqlEx, conn);
        }
        catch (SQLException sqlEx) {
            SQLException unexpectedEx = new SQLException("Unable to create correct SQLException class instance, error class/codes may be incorrect. Reason: " + Util.stackTraceToString(sqlEx), SQL_STATE_GENERAL_ERROR);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return SQLError.runThroughExceptionInterceptor(interceptor, unexpectedEx, conn);
        }
    }

    public static SQLException createCommunicationsException(GBaseConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, ExceptionInterceptor interceptor) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        SQLException exToReturn = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!Util.isJdbc4()) {
            exToReturn = new CommunicationsException(conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                exToReturn = (SQLException)Util.handleNewInstance(JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR, new Object[]{conn, Constants.longValueOf(lastPacketSentTimeMs), Constants.longValueOf(lastPacketReceivedTimeMs), underlyingException}, interceptor);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SQLException sqlEx) {
                return sqlEx;
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return SQLError.runThroughExceptionInterceptor(interceptor, exToReturn, conn);
    }

    public static String createLinkFailureMessageBasedOnHeuristics(GBaseConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, boolean streamingResultSetInPlay) {
        Object[] timingInfo;
        long serverTimeoutSeconds = 0L;
        boolean isInteractiveClient = false;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (conn != null) {
            isInteractiveClient = conn.getInteractiveClient();
            String serverTimeoutSecondsStr = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (isInteractiveClient) {
                serverTimeoutSecondsStr = conn.getServerVariable("interactive_timeout");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                serverTimeoutSecondsStr = conn.getServerVariable("wait_timeout");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (serverTimeoutSecondsStr != null) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    serverTimeoutSeconds = Long.parseLong(serverTimeoutSecondsStr);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (NumberFormatException nfe) {
                    serverTimeoutSeconds = 0L;
                }
            }
        }
        StringBuffer exceptionMessageBuf = new StringBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (lastPacketSentTimeMs == 0L) {
            lastPacketSentTimeMs = System.currentTimeMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        long timeSinceLastPacket = (System.currentTimeMillis() - lastPacketSentTimeMs) / 1000L;
        long timeSinceLastPacketMs = System.currentTimeMillis() - lastPacketSentTimeMs;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long timeSinceLastPacketReceivedMs = System.currentTimeMillis() - lastPacketReceivedTimeMs;
        int dueToTimeout = 0;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        StringBuffer timeoutMessageBuf = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (streamingResultSetInPlay) {
            exceptionMessageBuf.append(Messages.getString("CommunicationsException.ClientWasStreaming"));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            if (serverTimeoutSeconds != 0L) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (timeSinceLastPacket > serverTimeoutSeconds) {
                    dueToTimeout = 1;
                    timeoutMessageBuf = new StringBuffer();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    timeoutMessageBuf.append(Messages.getString("CommunicationsException.2"));
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (!isInteractiveClient) {
                        timeoutMessageBuf.append(Messages.getString("CommunicationsException.3"));
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        timeoutMessageBuf.append(Messages.getString("CommunicationsException.4"));
                    }
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (timeSinceLastPacket > 28800L) {
                dueToTimeout = 2;
                timeoutMessageBuf = new StringBuffer();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.5"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.6"));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.7"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.8"));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (dueToTimeout == 1 || dueToTimeout == 2) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (lastPacketReceivedTimeMs != 0L) {
                    timingInfo = new Object[]{new Long(timeSinceLastPacketReceivedMs), new Long(timeSinceLastPacketMs)};
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfo", timingInfo));
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfoNoRecv", new Object[]{new Long(timeSinceLastPacketMs)}));
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (timeoutMessageBuf != null) {
                    exceptionMessageBuf.append(timeoutMessageBuf);
                }
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.11"));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.12"));
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.13"));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (underlyingException instanceof BindException) {
                    if (conn.getLocalSocketAddress() != null && !Util.interfaceExists(conn.getLocalSocketAddress())) {
                        exceptionMessageBuf.append(Messages.getString("CommunicationsException.LocalSocketAddressNotAvailable"));
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        exceptionMessageBuf.append(Messages.getString("CommunicationsException.TooManyClientConnections"));
                    }
                }
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (exceptionMessageBuf.length() == 0) {
            exceptionMessageBuf.append(Messages.getString("CommunicationsException.20"));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (conn != null && conn.getMaintainTimeStats() && !conn.getParanoid()) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                exceptionMessageBuf.append("\n\n");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (lastPacketReceivedTimeMs != 0L) {
                    timingInfo = new Object[]{new Long(timeSinceLastPacketReceivedMs), new Long(timeSinceLastPacketMs)};
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfo", timingInfo));
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfoNoRecv", new Object[]{new Long(timeSinceLastPacketMs)}));
                }
            }
        }
        return exceptionMessageBuf.toString();
    }

    public static SQLException notImplemented() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (Util.isJdbc4()) {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return (SQLException)Class.forName("java.sql.SQLFeatureNotSupportedException").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new NotImplemented();
    }

    private static SQLException runThroughExceptionInterceptor(ExceptionInterceptor exInterceptor, SQLException sqlEx, Connection conn) {
        if (exInterceptor != null) {
            SQLException interceptedEx = exInterceptor.interceptException(sqlEx, conn);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (interceptedEx != null) {
                return interceptedEx;
            }
        }
        return sqlEx;
    }

    public static SQLException createBatchUpdateException(SQLException underlyingEx, long[] updateCounts, ExceptionInterceptor interceptor) throws SQLException {
        SQLException newEx;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (Util.isJdbc42()) {
            newEx = (SQLException)Util.getInstance("java.sql.BatchUpdateException", new Class[]{String.class, String.class, Integer.TYPE, long[].class, Throwable.class}, new Object[]{underlyingEx.getMessage(), underlyingEx.getSQLState(), underlyingEx.getErrorCode(), updateCounts, underlyingEx}, interceptor);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            newEx = new BatchUpdateException(underlyingEx.getMessage(), underlyingEx.getSQLState(), underlyingEx.getErrorCode(), Util.truncateAndConvertToInt(updateCounts));
            newEx.initCause(underlyingEx);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return SQLError.runThroughExceptionInterceptor(interceptor, newEx, null);
    }

    public static SQLException createSQLFeatureNotSupportedException(String message, String sqlState, ExceptionInterceptor interceptor) throws SQLException {
        SQLException newEx;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (Util.isJdbc4()) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            newEx = (SQLException)Util.getInstance("java.sql.SQLFeatureNotSupportedException", new Class[]{String.class, String.class}, new Object[]{message, sqlState}, interceptor);
        } else {
            newEx = new NotImplemented();
        }
        return SQLError.runThroughExceptionInterceptor(interceptor, newEx, null);
    }

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR = Class.forName("com.gbase.jdbc.exceptions.jdbc4.CommunicationsException").getConstructor(GBaseConnection.class, Long.TYPE, Long.TYPE, Exception.class);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SecurityException e) {
                throw new CustomRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new CustomRuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new CustomRuntimeException(e);
            }
        } else {
            JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR = null;
        }
        sqlStateMessages = new HashMap();
        sqlStateMessages.put(SQL_STATE_DISCONNECT_ERROR, Messages.getString("SQLError.35"));
        sqlStateMessages.put(SQL_STATE_DATE_TRUNCATED, Messages.getString("SQLError.36"));
        sqlStateMessages.put(SQL_STATE_PRIVILEGE_NOT_REVOKED, Messages.getString("SQLError.37"));
        sqlStateMessages.put(SQL_STATE_INVALID_CONNECTION_ATTRIBUTE, Messages.getString("SQLError.38"));
        sqlStateMessages.put(SQL_STATE_ERROR_IN_ROW, Messages.getString("SQLError.39"));
        sqlStateMessages.put(SQL_STATE_NO_ROWS_UPDATED_OR_DELETED, Messages.getString("SQLError.40"));
        sqlStateMessages.put(SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED, Messages.getString("SQLError.41"));
        sqlStateMessages.put(SQL_STATE_WRONG_NO_OF_PARAMETERS, Messages.getString("SQLError.42"));
        sqlStateMessages.put(SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE, Messages.getString("SQLError.43"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_IN_USE, Messages.getString("SQLError.44"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_NOT_OPEN, Messages.getString("SQLError.45"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_REJECTED, Messages.getString("SQLError.46"));
        sqlStateMessages.put("08007", Messages.getString("SQLError.47"));
        sqlStateMessages.put(SQL_STATE_COMMUNICATION_LINK_FAILURE, Messages.getString("SQLError.48"));
        sqlStateMessages.put(SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST, Messages.getString("SQLError.49"));
        sqlStateMessages.put(SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE, Messages.getString("SQLError.50"));
        sqlStateMessages.put(SQL_STATE_DATETIME_FIELD_OVERFLOW, Messages.getString("SQLError.51"));
        sqlStateMessages.put(SQL_STATE_DIVISION_BY_ZERO, Messages.getString("SQLError.52"));
        sqlStateMessages.put(SQL_STATE_DEADLOCK, Messages.getString("SQLError.53"));
        sqlStateMessages.put(SQL_STATE_INVALID_AUTH_SPEC, Messages.getString("SQLError.54"));
        sqlStateMessages.put(SQL_STATE_SYNTAX_ERROR, Messages.getString("SQLError.55"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND, Messages.getString("SQLError.56"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS, Messages.getString("SQLError.57"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_NOT_FOUND, Messages.getString("SQLError.58"));
        sqlStateMessages.put(SQL_STATE_INDEX_ALREADY_EXISTS, Messages.getString("SQLError.59"));
        sqlStateMessages.put(SQL_STATE_INDEX_NOT_FOUND, Messages.getString("SQLError.60"));
        sqlStateMessages.put(SQL_STATE_COLUMN_ALREADY_EXISTS, Messages.getString("SQLError.61"));
        sqlStateMessages.put(SQL_STATE_COLUMN_NOT_FOUND, Messages.getString("SQLError.62"));
        sqlStateMessages.put(SQL_STATE_NO_DEFAULT_FOR_COLUMN, Messages.getString("SQLError.63"));
        sqlStateMessages.put(SQL_STATE_GENERAL_ERROR, Messages.getString("SQLError.64"));
        sqlStateMessages.put(SQL_STATE_MEMORY_ALLOCATION_FAILURE, Messages.getString("SQLError.65"));
        sqlStateMessages.put(SQL_STATE_INVALID_COLUMN_NUMBER, Messages.getString("SQLError.66"));
        sqlStateMessages.put(SQL_STATE_ILLEGAL_ARGUMENT, Messages.getString("SQLError.67"));
        sqlStateMessages.put(SQL_STATE_DRIVER_NOT_CAPABLE, Messages.getString("SQLError.68"));
        sqlStateMessages.put(SQL_STATE_TIMEOUT_EXPIRED, Messages.getString("SQLError.69"));
        gbaseToSqlState = new Hashtable();
        gbaseToSqlState.put(Constants.integerValueOf(1040), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1042), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1043), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1047), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1129), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1130), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSqlState.put(Constants.integerValueOf(1045), SQL_STATE_INVALID_AUTH_SPEC);
        gbaseToSqlState.put(Constants.integerValueOf(1037), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1038), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        gbaseToSqlState.put(Constants.integerValueOf(1064), SQL_STATE_SYNTAX_ERROR);
        gbaseToSqlState.put(Constants.integerValueOf(1065), SQL_STATE_SYNTAX_ERROR);
        gbaseToSqlState.put(Constants.integerValueOf(1055), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1056), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1057), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1059), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1060), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1061), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1062), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1063), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1066), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1067), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1068), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1069), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1070), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1071), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1072), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1073), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1074), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1075), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1082), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1083), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1084), SQL_STATE_ILLEGAL_ARGUMENT);
        gbaseToSqlState.put(Constants.integerValueOf(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        gbaseToSqlState.put(Constants.integerValueOf(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSqlState.put(Constants.integerValueOf(1054), SQL_STATE_COLUMN_NOT_FOUND);
        gbaseToSqlState.put(Constants.integerValueOf(1205), SQL_STATE_DEADLOCK);
        gbaseToSqlState.put(Constants.integerValueOf(1213), SQL_STATE_DEADLOCK);
        gbaseToSql99State = new HashMap();
        gbaseToSql99State.put(Constants.integerValueOf(1205), SQL_STATE_DEADLOCK);
        gbaseToSql99State.put(Constants.integerValueOf(1213), SQL_STATE_DEADLOCK);
        gbaseToSql99State.put(Constants.integerValueOf(1022), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1037), "HY001");
        gbaseToSql99State.put(Constants.integerValueOf(1038), "HY001");
        gbaseToSql99State.put(Constants.integerValueOf(1040), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSql99State.put(Constants.integerValueOf(1042), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1043), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1044), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1045), SQL_STATE_INVALID_AUTH_SPEC);
        gbaseToSql99State.put(Constants.integerValueOf(1050), "42S01");
        gbaseToSql99State.put(Constants.integerValueOf(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSql99State.put(Constants.integerValueOf(1052), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1053), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1054), "42S22");
        gbaseToSql99State.put(Constants.integerValueOf(1055), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1056), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1057), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        gbaseToSql99State.put(Constants.integerValueOf(1059), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1060), "42S21");
        gbaseToSql99State.put(Constants.integerValueOf(1061), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1062), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1063), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1064), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1065), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1066), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1067), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1068), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1069), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1070), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1071), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1072), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1073), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1074), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1075), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1080), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1082), "42S12");
        gbaseToSql99State.put(Constants.integerValueOf(1083), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1084), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1090), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1091), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1101), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1102), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1103), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1104), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1106), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1107), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1109), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSql99State.put(Constants.integerValueOf(1110), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1112), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1113), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1115), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1118), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1120), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1121), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1131), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1132), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1133), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1136), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        gbaseToSql99State.put(Constants.integerValueOf(1138), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1139), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1140), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1141), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1142), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1143), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1144), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1145), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1146), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        gbaseToSql99State.put(Constants.integerValueOf(1147), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1148), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1149), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1152), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1153), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1154), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1155), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1156), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1157), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1158), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1159), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1160), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1161), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1162), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1163), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1164), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1166), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1167), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1169), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1170), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1171), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1172), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1173), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1177), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1178), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1179), "25000");
        gbaseToSql99State.put(Constants.integerValueOf(1184), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1189), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1190), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1203), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1207), "25000");
        gbaseToSql99State.put(Constants.integerValueOf(1211), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1213), "40001");
        gbaseToSql99State.put(Constants.integerValueOf(1216), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1217), "23000");
        gbaseToSql99State.put(Constants.integerValueOf(1218), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        gbaseToSql99State.put(Constants.integerValueOf(1222), "21000");
        gbaseToSql99State.put(Constants.integerValueOf(1226), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1230), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1231), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1232), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1234), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1235), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1239), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1241), "21000");
        gbaseToSql99State.put(Constants.integerValueOf(1242), "21000");
        gbaseToSql99State.put(Constants.integerValueOf(1247), "42S22");
        gbaseToSql99State.put(Constants.integerValueOf(1248), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1249), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1250), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1251), SQL_STATE_CONNECTION_REJECTED);
        gbaseToSql99State.put(Constants.integerValueOf(1252), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1253), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1261), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1262), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1263), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1264), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1265), "01000");
        gbaseToSql99State.put(Constants.integerValueOf(1280), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1281), SQL_STATE_SYNTAX_ERROR);
        gbaseToSql99State.put(Constants.integerValueOf(1286), SQL_STATE_SYNTAX_ERROR);
    }
}

