/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.SocketFactory;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;

public class StandardSocketFactory
implements SocketFactory {
    public static final String TCP_NO_DELAY_PROPERTY_NAME = "tcpNoDelay";
    public static final String TCP_KEEP_ALIVE_DEFAULT_VALUE = "true";
    public static final String TCP_KEEP_ALIVE_PROPERTY_NAME = "tcpKeepAlive";
    public static final String TCP_RCV_BUF_PROPERTY_NAME = "tcpRcvBuf";
    public static final String TCP_SND_BUF_PROPERTY_NAME = "tcpSndBuf";
    public static final String TCP_TRAFFIC_CLASS_PROPERTY_NAME = "tcpTrafficClass";
    public static final String TCP_RCV_BUF_DEFAULT_VALUE = "0";
    public static final String TCP_SND_BUF_DEFAULT_VALUE = "0";
    public static final String TCP_TRAFFIC_CLASS_DEFAULT_VALUE = "0";
    public static final String TCP_NO_DELAY_DEFAULT_VALUE = "true";
    private static Method setTraficClassMethod;
    protected String host = null;
    protected int port = 5258;
    protected Socket rawSocket = null;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    private void configureSocket(Socket sock, Properties props) throws SocketException, IOException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            sock.setTcpNoDelay(Boolean.valueOf(props.getProperty(TCP_NO_DELAY_PROPERTY_NAME, "true")));
            String keepAlive = props.getProperty(TCP_KEEP_ALIVE_PROPERTY_NAME, "true");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (keepAlive != null && keepAlive.length() > 0) {
                sock.setKeepAlive(Boolean.valueOf(keepAlive));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            int receiveBufferSize = Integer.parseInt(props.getProperty(TCP_RCV_BUF_PROPERTY_NAME, "0"));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (receiveBufferSize > 0) {
                sock.setReceiveBufferSize(receiveBufferSize);
            }
            int sendBufferSize = Integer.parseInt(props.getProperty(TCP_SND_BUF_PROPERTY_NAME, "0"));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (sendBufferSize > 0) {
                sock.setSendBufferSize(sendBufferSize);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            int trafficClass = Integer.parseInt(props.getProperty(TCP_TRAFFIC_CLASS_PROPERTY_NAME, "0"));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (trafficClass > 0 && setTraficClassMethod != null) {
                setTraficClassMethod.invoke((Object)sock, new Integer(trafficClass));
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (Throwable t) {
            this.unwrapExceptionToProperClassAndThrowIt(t);
        }
    }

    public Socket connect(String hostname, int portNumber, Properties props) throws SocketException, IOException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (props != null) {
            this.host = hostname;
            this.port = portNumber;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Method connectWithTimeoutMethod = null;
            Method socketBindMethod = null;
            Class<?> socketAddressClass = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String localSocketHostname = props.getProperty("localSocketAddress");
            String connectTimeoutStr = props.getProperty("connectTimeout");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            int connectTimeout = 0;
            boolean wantsTimeout = connectTimeoutStr != null && connectTimeoutStr.length() > 0 && !connectTimeoutStr.equals("0");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            boolean wantsLocalBind = localSocketHostname != null && localSocketHostname.length() > 0;
            boolean needsConfigurationBeforeConnect = this.socketNeedsConfigurationBeforeConnect(props);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (wantsTimeout || wantsLocalBind || needsConfigurationBeforeConnect) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (connectTimeoutStr != null) {
                    try {
                        connectTimeout = Integer.parseInt(connectTimeoutStr);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    catch (NumberFormatException nfe) {
                        throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                    }
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    socketAddressClass = Class.forName("java.net.SocketAddress");
                    connectWithTimeoutMethod = Socket.class.getMethod("connect", socketAddressClass, Integer.TYPE);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    socketBindMethod = Socket.class.getMethod("bind", socketAddressClass);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (NoClassDefFoundError nfe) {
                }
                catch (NoSuchMethodException noSuchMethodEx) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (Throwable noSuchMethodEx) {
                    // empty catch block
                }
                if (wantsLocalBind && socketBindMethod == null) {
                    throw new SocketException("Can't specify \"localSocketAddress\" on JVMs older than 1.4");
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (wantsTimeout && connectWithTimeoutMethod == null) {
                    throw new SocketException("Can't specify \"connectTimeout\" on JVMs older than 1.4");
                }
            }
            if (this.host != null) {
                InetAddress[] possibleAddresses;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!(wantsLocalBind || wantsTimeout || needsConfigurationBeforeConnect)) {
                    possibleAddresses = InetAddress.getAllByName(this.host);
                    Exception caughtWhileConnecting = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    for (int i = 0; i < possibleAddresses.length; ++i) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            this.rawSocket = new Socket(possibleAddresses[i], this.port);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            this.configureSocket(this.rawSocket, props);
                            break;
                        }
                        catch (Exception ex) {
                            caughtWhileConnecting = ex;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            continue;
                        }
                    }
                    if (this.rawSocket == null) {
                        this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                } else {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        possibleAddresses = InetAddress.getAllByName(this.host);
                        Exception caughtWhileConnecting = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        Object localSockAddr = null;
                        Class<?> inetSocketAddressClass = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        Constructor<?> addrConstructor = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                            addrConstructor = inetSocketAddressClass.getConstructor(InetAddress.class, Integer.TYPE);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (wantsLocalBind) {
                                localSockAddr = addrConstructor.newInstance(InetAddress.getByName(localSocketHostname), new Integer(0));
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            }
                        }
                        catch (Throwable ex) {
                            this.unwrapExceptionToProperClassAndThrowIt(ex);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        for (int i = 0; i < possibleAddresses.length; ++i) {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            try {
                                this.rawSocket = new Socket();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                this.configureSocket(this.rawSocket, props);
                                Object sockAddr = addrConstructor.newInstance(possibleAddresses[i], new Integer(this.port));
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                socketBindMethod.invoke((Object)this.rawSocket, localSockAddr);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                                break;
                            }
                            catch (Exception ex) {
                                this.rawSocket = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                caughtWhileConnecting = ex;
                                continue;
                            }
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (this.rawSocket == null) {
                            this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    catch (Throwable t) {
                        this.unwrapExceptionToProperClassAndThrowIt(t);
                    }
                }
                return this.rawSocket;
            }
        }
        throw new SocketException("Unable to create socket");
    }

    private boolean socketNeedsConfigurationBeforeConnect(Properties props) {
        int receiveBufferSize = Integer.parseInt(props.getProperty(TCP_RCV_BUF_PROPERTY_NAME, "0"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (receiveBufferSize > 0) {
            return true;
        }
        int sendBufferSize = Integer.parseInt(props.getProperty(TCP_SND_BUF_PROPERTY_NAME, "0"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (sendBufferSize > 0) {
            return true;
        }
        int trafficClass = Integer.parseInt(props.getProperty(TCP_TRAFFIC_CLASS_PROPERTY_NAME, "0"));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return trafficClass > 0 && setTraficClassMethod != null;
    }

    private void unwrapExceptionToProperClassAndThrowIt(Throwable caughtWhileConnecting) throws SocketException, IOException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (caughtWhileConnecting instanceof InvocationTargetException) {
            caughtWhileConnecting = ((InvocationTargetException)caughtWhileConnecting).getTargetException();
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (caughtWhileConnecting instanceof SocketException) {
            throw (SocketException)caughtWhileConnecting;
        }
        if (caughtWhileConnecting instanceof IOException) {
            throw (IOException)caughtWhileConnecting;
        }
        throw new SocketException(caughtWhileConnecting.toString());
    }

    static {
        try {
            setTraficClassMethod = Socket.class.getMethod("setTrafficClass", Integer.TYPE);
        }
        catch (SecurityException e) {
            setTraficClassMethod = null;
        }
        catch (NoSuchMethodException e) {
            setTraficClassMethod = null;
        }
    }
}

