/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.AssertionFailedException;
import com.gbase.jdbc.ByteArrayRow;
import com.gbase.jdbc.CachedResultSetMetaData;
import com.gbase.jdbc.CharsetMapping;
import com.gbase.jdbc.Connection;
import com.gbase.jdbc.Constants;
import com.gbase.jdbc.DatabaseMetaData;
import com.gbase.jdbc.EscapeProcessor;
import com.gbase.jdbc.EscapeProcessorResult;
import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.Field;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseIO;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.PingTarget;
import com.gbase.jdbc.PreparedStatement;
import com.gbase.jdbc.ProfilerEventHandlerFactory;
import com.gbase.jdbc.ResultSetImpl;
import com.gbase.jdbc.ResultSetInternalMethods;
import com.gbase.jdbc.ResultSetRow;
import com.gbase.jdbc.RowDataStatic;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.SingleByteCharsetConverter;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.exceptions.CustomRuntimeException;
import com.gbase.jdbc.exceptions.GBaseStatementCancelledException;
import com.gbase.jdbc.exceptions.GBaseTimeoutException;
import com.gbase.jdbc.profiler.ProfilerEvent;
import com.gbase.jdbc.profiler.ProfilerEventHandler;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementImpl
implements Statement {
    protected static final String PING_MARKER = "/* ping */";
    protected Object cancelTimeoutMutex = new Object();
    protected static int statementCounter = 1;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected boolean wasCancelled = false;
    protected boolean wasCancelledByTimeout = false;
    protected List batchedArgs;
    protected SingleByteCharsetConverter charConverter = null;
    protected String charEncoding = null;
    protected GBaseConnection connection = null;
    protected long connectionId = 0L;
    protected String currentCatalog = null;
    protected boolean doEscapeProcessing = true;
    protected ProfilerEventHandler eventSink = null;
    private int fetchSize = 0;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = GBaseIO.getMaxBuf();
    protected int maxRows = -1;
    protected boolean maxRowsChanged = false;
    protected Set openResults = new HashSet();
    protected boolean pedantic = false;
    protected Throwable pointOfOrigin;
    protected boolean profileSQL = false;
    protected ResultSetInternalMethods results = null;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected int statementId;
    protected int timeoutInMillis = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    protected SQLWarning warningChain = null;
    protected boolean holdResultsOpenOverClose = false;
    protected ArrayList batchedGeneratedKeys = null;
    protected boolean retrieveGeneratedKeys = false;
    protected boolean continueBatchOnError = false;
    protected PingTarget pingTarget = null;
    protected boolean useLegacyDatetimeCode;
    private ExceptionInterceptor exceptionInterceptor;
    protected boolean lastQueryIsOnDupKeyUpdate = false;
    protected boolean clearWarningsCalled = false;
    private long skippedLines = -1L;
    private long loadTaskID = -1L;
    private int originalResultSetType = 0;
    private int originalFetchSize = 0;
    private boolean isPoolable = true;
    private InputStream localInfileInputStream;
    private boolean closeOnCompletion;

    public long getSkippedLines() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.skippedLines;
    }

    public void setSkippedLines(long skiplines) {
        this.skippedLines = skiplines;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public long getLoadTaskID() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.loadTaskID;
    }

    public void setLoadTaskID(long loadTaskID) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.loadTaskID = loadTaskID;
    }

    public StatementImpl(GBaseConnection c, String catalog) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (c == null || c.isClosed()) {
            throw SQLError.createSQLException(Messages.getString("Statement.0"), "08003", null);
        }
        this.connection = c;
        this.connectionId = this.connection.getId();
        this.exceptionInterceptor = this.connection.getExceptionInterceptor();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.currentCatalog = catalog;
        this.pedantic = this.connection.getPedantic();
        this.continueBatchOnError = this.connection.getContinueBatchOnError();
        this.useLegacyDatetimeCode = this.connection.getUseLegacyDatetimeCode();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.doEscapeProcessing = this.connection.getEnableEscapeProcessing();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.connection.getDontTrackOpenResources()) {
            this.connection.registerStatement(this);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
            int defaultFetchSize = this.connection.getDefaultFetchSize();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (defaultFetchSize != 0) {
                this.setFetchSize(defaultFetchSize);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (this.connection.getUseUnicode()) {
                this.charEncoding = this.connection.getEncoding();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
            }
            boolean profiling = this.connection.getProfileSql() || this.connection.getUseUsageAdvisor() || this.connection.getLogSlowQueries();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.connection.getAutoGenerateTestcaseScript() || profiling) {
                this.statementId = statementCounter++;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (profiling) {
                this.pointOfOrigin = new Throwable();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.profileSQL = this.connection.getProfileSql();
                this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
            }
            int maxRowsConn = this.connection.getMaxRows();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (maxRowsConn != -1) {
                this.setMaxRows(maxRowsConn);
            }
            this.holdResultsOpenOverClose = this.connection.getHoldResultsOpenOverStatementClose();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        if (!this.isClosed && this.connection != null && this.connection.versionMeetsMinimum(8, 0, 0)) {
            Connection cancelConn;
            block6: {
                cancelConn = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                java.sql.Statement cancelStmt = null;
                try {
                    cancelConn = this.connection.duplicate();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    cancelStmt = cancelConn.createStatement();
                    cancelStmt.execute("KILL QUERY " + this.connection.getIO().getThreadId());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    this.wasCancelled = true;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    Object var4_3 = null;
                    if (cancelStmt == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (cancelStmt != null) {
                        cancelStmt.close();
                    }
                    if (cancelConn != null) {
                        cancelConn.close();
                    }
                    throw throwable;
                }
                cancelStmt.close();
            }
            if (cancelConn != null) {
                cancelConn.close();
            }
        }
    }

    protected void checkClosed() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isClosed) {
            throw SQLError.createSQLException(Messages.getString("Statement.49"), "08003", this.getExceptionInterceptor());
        }
    }

    protected void checkForDml(String sql, char firstStatementChar) throws SQLException {
        if (firstStatementChar == 'I' || firstStatementChar == 'U' || firstStatementChar == 'D' || firstStatementChar == 'A' || firstStatementChar == 'T' || firstStatementChar == 'C') {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String noCommentSql = StringUtils.stripComments(sql, "'\"", "'\"", true, false, true, true);
            if (StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "TRUNCATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "ALTER")) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw SQLError.createSQLException(Messages.getString("Statement.57"), "S1009", this.getExceptionInterceptor());
            }
        }
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw SQLError.createSQLException(Messages.getString("Statement.59"), "S1009", this.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (sql.length() == 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.61"), "S1009", this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.warningChain = null;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.realClose(true, true);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    protected synchronized void closeAllOpenResults() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.openResults != null) {
            Iterator iter = this.openResults.iterator();
            while (iter.hasNext()) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                ResultSetInternalMethods element = (ResultSetInternalMethods)iter.next();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    element.realClose(false);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    @Override
    public synchronized void removeOpenResultSet(ResultSet rs) {
        if (this.openResults != null) {
            this.openResults.remove(rs);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    @Override
    public synchronized int getOpenResultSetCount() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.openResults != null) {
            return this.openResults.size();
        }
        return 0;
    }

    private ResultSetInternalMethods createResultSetUsingServerFetch(String sql) throws SQLException {
        java.sql.PreparedStatement pStmt = this.connection.prepareStatement(sql, this.resultSetType, this.resultSetConcurrency);
        pStmt.setFetchSize(this.fetchSize);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.maxRows > -1) {
            pStmt.setMaxRows(this.maxRows);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        pStmt.execute();
        ResultSetInternalMethods rs = ((StatementImpl)((Object)pStmt)).getResultSetInternal();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rs.setStatementUsedForFetchingRows((PreparedStatement)pStmt);
        this.results = rs;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return rs;
    }

    protected boolean createStreamingResultSet() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
    }

    @Override
    public void enableStreamingResults() throws SQLException {
        this.originalResultSetType = this.resultSetType;
        this.originalFetchSize = this.fetchSize;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.setFetchSize(Integer.MIN_VALUE);
        this.setResultSetType(1003);
    }

    @Override
    public void disableStreamingResults() throws SQLException {
        if (this.fetchSize == Integer.MIN_VALUE && this.resultSetType == 1003) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.setFetchSize(this.originalFetchSize);
            this.setResultSetType(this.originalResultSetType);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeInternal(sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String sql, boolean returnGeneratedKeys) throws SQLException {
        this.checkClosed();
        GBaseConnection locallyScopedConn = this.connection;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            this.retrieveGeneratedKeys = returnGeneratedKeys;
            this.lastQueryIsOnDupKeyUpdate = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (returnGeneratedKeys) {
                this.lastQueryIsOnDupKeyUpdate = this.containsOnDuplicateKeyInString(sql);
            }
            this.resetCancelledState();
            this.checkNullOrEmptyQuery(sql);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.checkClosed();
            char firstNonWsChar = StringUtils.firstAlphaCharUc(sql, this.findStartOfStatement(sql));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            boolean isSelect = true;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (firstNonWsChar != 'S') {
                isSelect = false;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (locallyScopedConn.isReadOnly()) {
                    throw SQLError.createSQLException(Messages.getString("Statement.27") + Messages.getString("Statement.28"), "S1009", this.getExceptionInterceptor());
                }
            }
            boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (returnGeneratedKeys) {
                locallyScopedConn.setReadInfoMsgEnabled(true);
            }
            boolean doStreaming = this.createStreamingResultSet();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (doStreaming && !this.connection.getUseIMConnection() && locallyScopedConn.getNetTimeoutForStreamingResults() > 0) {
                this.executeSimpleNonQuery(locallyScopedConn, "SET net_write_timeout=" + locallyScopedConn.getNetTimeoutForStreamingResults());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (this.doEscapeProcessing) {
                Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, locallyScopedConn.serverSupportsConvertFn(), locallyScopedConn);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (escapedSqlResult instanceof String) {
                    sql = (String)escapedSqlResult;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    sql = ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
            if (this.results != null) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                    this.results.realClose(false);
                }
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                this.doPingInstead();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return true;
            }
            CachedResultSetMetaData cachedMetaData = null;
            ResultSetInternalMethods rs = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.batchedGeneratedKeys = null;
            if (this.useServerFetch()) {
                rs = this.createResultSetUsingServerFetch(sql);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                String oldCatalog;
                block46: {
                    TimerTask timeoutTask = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    oldCatalog = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(8, 0, 0)) {
                            timeoutTask = new CancelTask(this);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            locallyScopedConn.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                            oldCatalog = locallyScopedConn.getCatalog();
                            locallyScopedConn.setCatalog(this.currentCatalog);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        Field[] cachedFields = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (locallyScopedConn.getCacheResultSetMetadata()) {
                            cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (cachedMetaData != null) {
                                cachedFields = cachedMetaData.fields;
                            }
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (locallyScopedConn.useMaxRows()) {
                            int rowLimit = -1;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (isSelect) {
                                if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                                    rowLimit = this.maxRows;
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                } else {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    if (this.maxRows <= 0) {
                                        this.executeSimpleNonQuery(locallyScopedConn, "SET SQL_SELECT_LIMIT=DEFAULT");
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    } else {
                                        this.executeSimpleNonQuery(locallyScopedConn, "SET SQL_SELECT_LIMIT=" + this.maxRows);
                                    }
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            } else {
                                this.executeSimpleNonQuery(locallyScopedConn, "SET SQL_SELECT_LIMIT=DEFAULT");
                            }
                            rs = locallyScopedConn.execSQL(this, sql, rowLimit, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            rs = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        if (timeoutTask != null) {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                                throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                            }
                            timeoutTask.cancel();
                            timeoutTask = null;
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        Object object2 = this.cancelTimeoutMutex;
                        synchronized (object2) {
                            if (this.wasCancelled) {
                                SQLException cause = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (this.wasCancelledByTimeout) {
                                    cause = new GBaseTimeoutException();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                } else {
                                    cause = new GBaseStatementCancelledException();
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                }
                                this.resetCancelledState();
                                throw cause;
                            }
                        }
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        Object var18_18 = null;
                        if (timeoutTask == null) break block46;
                    }
                    catch (Throwable throwable) {
                        Object var18_19 = null;
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            locallyScopedConn.getCancelTimer().purge();
                        }
                        if (oldCatalog != null) {
                            locallyScopedConn.setCatalog(oldCatalog);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                    timeoutTask.cancel();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.getCancelTimer().purge();
                }
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                {
                }
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (rs != null) {
                this.lastInsertId = rs.getUpdateID();
                this.results = rs;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rs.setFirstCharOfQuery(firstNonWsChar);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (rs.reallyResult()) {
                    if (cachedMetaData != null) {
                        locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (this.connection.getCacheResultSetMetadata()) {
                            locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                        }
                    }
                }
            }
            return rs != null && rs.reallyResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void resetCancelledState() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.cancelTimeoutMutex == null) {
            return;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = this.cancelTimeoutMutex;
        synchronized (object) {
            this.wasCancelled = false;
            this.wasCancelledByTimeout = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    @Override
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeInternal(sql, returnGeneratedKeys == 1);
    }

    @Override
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeInternal(sql, generatedKeyIndices != null && generatedKeyIndices.length > 0);
    }

    @Override
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeInternal(sql, generatedKeyNames != null && generatedKeyNames.length > 0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Util.truncateAndConvertToInt(this.executeBatchInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long[] executeBatchInternal() throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        GBaseConnection locallyScopedConn = this.connection;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (locallyScopedConn.isReadOnly()) {
            throw SQLError.createSQLException(Messages.getString("Statement.34") + Messages.getString("Statement.35"), "S1009", this.getExceptionInterceptor());
        }
        if (this.results != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                this.results.realClose(false);
            }
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            long[] lArray;
            TimerTask timeoutTask;
            int individualStatementTimeout;
            block26: {
                long[] lArray2;
                block24: {
                    block25: {
                        if (this.batchedArgs == null) return new long[0];
                        if (this.batchedArgs.size() == 0) {
                            return new long[0];
                        }
                        individualStatementTimeout = this.timeoutInMillis;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        this.timeoutInMillis = 0;
                        timeoutTask = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            this.resetCancelledState();
                            this.retrieveGeneratedKeys = true;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            long[] updateCounts = null;
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (this.batchedArgs != null) {
                                int nbrCommands = this.batchedArgs.size();
                                this.batchedGeneratedKeys = new ArrayList(this.batchedArgs.size());
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                boolean multiQueriesEnabled = locallyScopedConn.getAllowMultiQueries();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                if (locallyScopedConn.versionMeetsMinimum(8, 0, 0) && (multiQueriesEnabled || locallyScopedConn.getRewriteBatchedStatements() && nbrCommands > 4)) {
                                    lArray2 = this.executeBatchUsingMultiQueries(multiQueriesEnabled, nbrCommands, individualStatementTimeout);
                                    Object var14_12 = null;
                                    if (timeoutTask == null) break block24;
                                    break block25;
                                }
                                if (locallyScopedConn.getEnableQueryTimeouts() && individualStatementTimeout != 0 && locallyScopedConn.versionMeetsMinimum(8, 0, 0)) {
                                    timeoutTask = new CancelTask(this);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    locallyScopedConn.getCancelTimer().schedule(timeoutTask, individualStatementTimeout);
                                }
                                updateCounts = new long[nbrCommands];
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                for (int i = 0; i < nbrCommands; ++i) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    updateCounts[i] = -3L;
                                }
                                SQLException sqlEx = null;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                int commandIndex = 0;
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                    try {
                                        String sql = (String)this.batchedArgs.get(commandIndex);
                                        updateCounts[commandIndex] = this.executeUpdateInternal(sql, true, true);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        this.getBatchedGeneratedKeys(this.containsOnDuplicateKeyInString(sql) ? 1 : 0);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        continue;
                                    }
                                    catch (SQLException ex) {
                                        updateCounts[commandIndex] = -3L;
                                        if (this.continueBatchOnError && !(ex instanceof GBaseTimeoutException) && !(ex instanceof GBaseStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            sqlEx = ex;
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            continue;
                                        }
                                        long[] newUpdateCounts = new long[commandIndex];
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                        if (!this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.getExceptionInterceptor());
                                        }
                                        int i = 0;
                                        while (i < newUpdateCounts.length) {
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                            newUpdateCounts[i] = -3L;
                                            ++i;
                                        }
                                        throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.getExceptionInterceptor());
                                    }
                                }
                                if (sqlEx != null) {
                                    throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.getExceptionInterceptor());
                                }
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (timeoutTask != null) {
                                if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                                    throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                                }
                                timeoutTask.cancel();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                locallyScopedConn.getCancelTimer().purge();
                                timeoutTask = null;
                            }
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            lArray = updateCounts != null ? updateCounts : new long[]{};
                            break block26;
                        }
                        catch (Throwable throwable) {
                            Object var14_14 = null;
                            if (timeoutTask != null) {
                                timeoutTask.cancel();
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                locallyScopedConn.getCancelTimer().purge();
                            }
                            this.resetCancelledState();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            this.timeoutInMillis = individualStatementTimeout;
                            this.clearBatch();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            throw throwable;
                        }
                    }
                    timeoutTask.cancel();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.getCancelTimer().purge();
                }
                this.resetCancelledState();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.timeoutInMillis = individualStatementTimeout;
                this.clearBatch();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return lArray2;
            }
            Object var14_13 = null;
            if (timeoutTask != null) {
                timeoutTask.cancel();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                locallyScopedConn.getCancelTimer().purge();
            }
            this.resetCancelledState();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.timeoutInMillis = individualStatementTimeout;
            this.clearBatch();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return lArray;
        }
    }

    protected final boolean hasDeadlockOrTimeoutRolledBackTx(SQLException ex) {
        int vendorCode = ex.getErrorCode();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (vendorCode) {
            case 1206: 
            case 1213: {
                return true;
            }
            case 1205: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                try {
                    return !this.connection.versionMeetsMinimum(8, 0, 0);
                }
                catch (SQLException sqlEx) {
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] executeBatchUsingMultiQueries(boolean multiQueriesEnabled, int nbrCommands, int individualStatementTimeout) throws SQLException {
        Object v1;
        long[] lArray;
        java.sql.Statement batchStmt;
        GBaseConnection locallyScopedConn;
        block26: {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            locallyScopedConn = this.connection;
            if (!multiQueriesEnabled) {
                locallyScopedConn.getIO().enableMultiQueries();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            batchStmt = null;
            TimerTask timeoutTask = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                long[] updateCounts = new long[nbrCommands];
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                for (int i = 0; i < nbrCommands; ++i) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    updateCounts[i] = -3L;
                }
                int commandIndex = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                StringBuffer queryBuf = new StringBuffer();
                batchStmt = locallyScopedConn.createStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (locallyScopedConn.getEnableQueryTimeouts() && individualStatementTimeout != 0 && locallyScopedConn.versionMeetsMinimum(8, 0, 0)) {
                    timeoutTask = new CancelTask((StatementImpl)batchStmt);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.getCancelTimer().schedule(timeoutTask, individualStatementTimeout);
                }
                int counter = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int numberOfBytesPerChar = 1;
                String connectionEncoding = locallyScopedConn.getEncoding();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (StringUtils.startsWithIgnoreCase(connectionEncoding, "utf")) {
                    numberOfBytesPerChar = 3;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else if (CharsetMapping.isMultibyteCharset(connectionEncoding)) {
                    numberOfBytesPerChar = 2;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                int escapeAdjust = 1;
                batchStmt.setEscapeProcessing(this.doEscapeProcessing);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.doEscapeProcessing) {
                    escapeAdjust = 2;
                }
                SQLException sqlEx = null;
                int argumentSetsInBatchSoFar = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    String nextQuery = (String)this.batchedArgs.get(commandIndex);
                    if (((queryBuf.length() + nextQuery.length()) * numberOfBytesPerChar + 1 + 4) * escapeAdjust + 32 > this.connection.getMaxAllowedPacket()) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        try {
                            batchStmt.execute(queryBuf.toString(), 1);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(commandIndex, argumentSetsInBatchSoFar, updateCounts, ex);
                        }
                        counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        queryBuf = new StringBuffer();
                        argumentSetsInBatchSoFar = 0;
                    }
                    queryBuf.append(nextQuery);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    queryBuf.append(";");
                    ++argumentSetsInBatchSoFar;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                if (queryBuf.length() > 0) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    try {
                        batchStmt.execute(queryBuf.toString(), 1);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    catch (SQLException ex) {
                        sqlEx = this.handleExceptionForBatch(commandIndex - 1, argumentSetsInBatchSoFar, updateCounts, ex);
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                }
                if (timeoutTask != null) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask.cancel();
                    locallyScopedConn.getCancelTimer().purge();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    timeoutTask = null;
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (sqlEx != null) {
                    throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.getExceptionInterceptor());
                }
                lArray = updateCounts != null ? updateCounts : new long[]{};
                Object var19_19 = null;
                if (timeoutTask == null) break block26;
            }
            catch (Throwable throwable) {
                block28: {
                    Object v0;
                    Object var19_20 = null;
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                        locallyScopedConn.getCancelTimer().purge();
                    }
                    this.resetCancelledState();
                    try {
                        if (batchStmt != null) {
                            batchStmt.close();
                        }
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var21_24;
                        v0 = var21_24 = null;
                    }
                    if (multiQueriesEnabled) break block28;
                    locallyScopedConn.getIO().disableMultiQueries();
                }
                throw throwable;
            }
            timeoutTask.cancel();
            locallyScopedConn.getCancelTimer().purge();
        }
        this.resetCancelledState();
        try {
            if (batchStmt != null) {
                batchStmt.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var21_23;
            v1 = var21_23 = null;
        }
        if (!multiQueriesEnabled) {
            locallyScopedConn.getIO().disableMultiQueries();
        }
        return lArray;
    }

    protected int processMultiCountsAndKeys(StatementImpl batchedStatement, int updateCountCounter, long[] updateCounts) throws SQLException {
        long generatedKey;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        updateCounts[updateCountCounter++] = batchedStatement.getLargeUpdateCount();
        boolean doGenKeys = this.batchedGeneratedKeys != null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object row = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (doGenKeys) {
            generatedKey = batchedStatement.getLastInsertID();
            row = new byte[1][];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            row[0] = Long.toString(generatedKey).getBytes();
            this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        while (batchedStatement.getMoreResults() || batchedStatement.getLargeUpdateCount() != -1L) {
            updateCounts[updateCountCounter++] = batchedStatement.getLargeUpdateCount();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!doGenKeys) continue;
            generatedKey = batchedStatement.getLastInsertID();
            row = new byte[1][];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            row[0] = Long.toString(generatedKey).getBytes();
            this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
        }
        return updateCountCounter;
    }

    protected SQLException handleExceptionForBatch(int endOfBatchIndex, int numValuesPerBatch, long[] updateCounts, SQLException ex) throws BatchUpdateException, SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int j = endOfBatchIndex; j > endOfBatchIndex - numValuesPerBatch; --j) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            updateCounts[j] = -3L;
        }
        if (this.continueBatchOnError && !(ex instanceof GBaseTimeoutException) && !(ex instanceof GBaseStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return ex;
        }
        long[] newUpdateCounts = new long[endOfBatchIndex];
        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, endOfBatchIndex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.getExceptionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        GBaseConnection locallyScopedConn = this.connection;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            this.retrieveGeneratedKeys = false;
            this.resetCancelledState();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.checkNullOrEmptyQuery(sql);
            boolean doStreaming = this.createStreamingResultSet();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (doStreaming && !this.connection.getUseIMConnection() && this.connection.getNetTimeoutForStreamingResults() > 0) {
                this.executeSimpleNonQuery(locallyScopedConn, "SET net_write_timeout=" + this.connection.getNetTimeoutForStreamingResults());
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (this.doEscapeProcessing) {
                Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, locallyScopedConn.serverSupportsConvertFn(), this.connection);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (escapedSqlResult instanceof String) {
                    sql = (String)escapedSqlResult;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    sql = ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
            char firstStatementChar = StringUtils.firstNonWsCharUc(sql, this.findStartOfStatement(sql));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                this.doPingInstead();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return this.results;
            }
            this.checkForDml(sql, firstStatementChar);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                this.results.realClose(false);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            CachedResultSetMetaData cachedMetaData = null;
            if (this.useServerFetch()) {
                this.results = this.createResultSetUsingServerFetch(sql);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return this.results;
            }
            TimerTask timeoutTask = null;
            String oldCatalog = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(8, 0, 0)) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    timeoutTask = new CancelTask(this);
                    locallyScopedConn.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                    oldCatalog = locallyScopedConn.getCatalog();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.setCatalog(this.currentCatalog);
                }
                Field[] cachedFields = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (locallyScopedConn.getCacheResultSetMetadata()) {
                    cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (cachedMetaData != null) {
                        cachedFields = cachedMetaData.fields;
                    }
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (locallyScopedConn.useMaxRows()) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1 && this.maxRows != -1) {
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        this.results = locallyScopedConn.execSQL(this, sql, this.maxRows, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        if (this.maxRows <= 0) {
                            this.executeSimpleNonQuery(locallyScopedConn, "SET SQL_SELECT_LIMIT=DEFAULT");
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            this.executeSimpleNonQuery(locallyScopedConn, "SET SQL_SELECT_LIMIT=" + this.maxRows);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        }
                        this.results = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (oldCatalog != null) {
                            locallyScopedConn.setCatalog(oldCatalog);
                        }
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    this.results = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (timeoutTask != null) {
                    if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask.cancel();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.getCancelTimer().purge();
                    timeoutTask = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                Object object2 = this.cancelTimeoutMutex;
                synchronized (object2) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (this.wasCancelled) {
                        SQLException cause = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (this.wasCancelledByTimeout) {
                            cause = new GBaseTimeoutException();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            cause = new GBaseStatementCancelledException();
                        }
                        this.resetCancelledState();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        throw cause;
                    }
                }
                Object var14_14 = null;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                    locallyScopedConn.getCancelTimer().purge();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                throw throwable;
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (timeoutTask != null) {
                timeoutTask.cancel();
                locallyScopedConn.getCancelTimer().purge();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (oldCatalog != null) {
                locallyScopedConn.setCatalog(oldCatalog);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            this.lastInsertId = this.results.getUpdateID();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (cachedMetaData != null) {
                locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else if (this.connection.getCacheResultSetMetadata()) {
                locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            return this.results;
        }
    }

    protected void doPingInstead() throws SQLException {
        if (this.pingTarget != null) {
            this.pingTarget.doPing();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            this.connection.ping();
        }
        ResultSetInternalMethods fakeSelectOneResultSet = this.generatePingResultSet();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.results = fakeSelectOneResultSet;
    }

    protected ResultSetInternalMethods generatePingResultSet() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Field[] fields = new Field[]{new Field(null, "1", -5, 1)};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
        byte[] colVal = new byte[]{49};
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rows.add(new ByteArrayRow(new byte[][]{colVal}, this.getExceptionInterceptor()));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return (ResultSetInternalMethods)DatabaseMetaData.buildResultSet(fields, rows, this.connection);
    }

    protected void executeSimpleNonQuery(GBaseConnection c, String nonQuery) throws SQLException {
        c.execSQL(this, nonQuery, -1, null, 1003, 1007, false, this.currentCatalog, null, false).close();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long executeUpdateInternal(String sql, boolean isBatch, boolean returnGeneratedKeys) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.checkClosed();
        GBaseConnection locallyScopedConn = this.connection;
        char firstStatementChar = StringUtils.firstAlphaCharUc(sql, this.findStartOfStatement(sql));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ResultSetInternalMethods rs = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            this.retrieveGeneratedKeys = returnGeneratedKeys;
            this.resetCancelledState();
            this.checkNullOrEmptyQuery(sql);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.doEscapeProcessing) {
                Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn(), this.connection);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (escapedSqlResult instanceof String) {
                    sql = (String)escapedSqlResult;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    sql = ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
            if (locallyScopedConn.isReadOnly()) {
                throw SQLError.createSQLException(Messages.getString("Statement.42") + Messages.getString("Statement.43"), "S1009", this.getExceptionInterceptor());
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
                throw SQLError.createSQLException(Messages.getString("Statement.46"), "01S03", this.getExceptionInterceptor());
            }
            if (this.results != null) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                    this.results.realClose(false);
                }
            }
            TimerTask timeoutTask = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String oldCatalog = null;
            boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (returnGeneratedKeys) {
                locallyScopedConn.setReadInfoMsgEnabled(true);
            }
            try {
                if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(8, 0, 0)) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    timeoutTask = new CancelTask(this);
                    locallyScopedConn.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                    oldCatalog = locallyScopedConn.getCatalog();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.setCatalog(this.currentCatalog);
                }
                if (locallyScopedConn.useMaxRows()) {
                    this.executeSimpleNonQuery(locallyScopedConn, "SET SQL_SELECT_LIMIT=DEFAULT");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                rs = locallyScopedConn.execSQL(this, sql, -1, null, 1003, 1007, false, this.currentCatalog, null, isBatch);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (timeoutTask != null) {
                    if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask.cancel();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.getCancelTimer().purge();
                    timeoutTask = null;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                Object object2 = this.cancelTimeoutMutex;
                synchronized (object2) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (this.wasCancelled) {
                        SQLException cause = null;
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        if (this.wasCancelledByTimeout) {
                            cause = new GBaseTimeoutException();
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        } else {
                            cause = new GBaseStatementCancelledException();
                        }
                        this.resetCancelledState();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        throw cause;
                    }
                }
                Object var15_14 = null;
                locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    locallyScopedConn.getCancelTimer().purge();
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                }
                throw throwable;
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (timeoutTask != null) {
                timeoutTask.cancel();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                locallyScopedConn.getCancelTimer().purge();
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (oldCatalog != null) {
                locallyScopedConn.setCatalog(oldCatalog);
            }
        }
        this.results = rs;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        rs.setFirstCharOfQuery(firstStatementChar);
        this.updateCount = rs.getUpdateCount();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.lastInsertId = rs.getUpdateID();
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, autoGeneratedKeys));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, columnIndexes));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, columnNames));
    }

    protected Calendar getCalendarInstanceForSessionOrNew() {
        if (this.connection != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return this.connection.getCalendarInstanceForSessionOrNew();
        }
        return new GregorianCalendar();
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.fetchSize;
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        if (!this.retrieveGeneratedKeys) {
            throw SQLError.createSQLException(Messages.getString("Statement.GeneratedKeysNotRequested"), "S1009", this.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.batchedGeneratedKeys == null) {
            if (this.lastQueryIsOnDupKeyUpdate) {
                return this.getGeneratedKeysInternal(1L);
            }
            return this.getGeneratedKeysInternal();
        }
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 20)};
        fields[0].setConnection(this.connection);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return ResultSetImpl.getInstance(this.currentCatalog, fields, new RowDataStatic(this.batchedGeneratedKeys), this.connection, this, false);
    }

    protected ResultSet getGeneratedKeysInternal() throws SQLException {
        long numKeys = this.getLargeUpdateCount();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getGeneratedKeysInternal(numKeys);
    }

    protected synchronized ResultSet getGeneratedKeysInternal(long numKeys) throws SQLException {
        Field[] fields = new Field[1];
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[0] = new Field("", "GENERATED_KEY", -5, 20);
        fields[0].setConnection(this.connection);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        fields[0].setUseOldNameMetadata(true);
        ArrayList<ResultSetRow> rowSet = new ArrayList<ResultSetRow>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long beginAt = this.getLastInsertID();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (beginAt < 0L) {
            fields[0].setUnsigned();
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.results != null) {
            String serverInfo = this.results.getServerInfo();
            if (numKeys > 0L && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
                numKeys = this.getRecordCountFromInfo(serverInfo);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (beginAt != 0L && numKeys > 0L) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int i = 0;
                while ((long)i < numKeys) {
                    byte[][] row = new byte[1][];
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (beginAt > 0L) {
                        row[0] = Long.toString(beginAt).getBytes();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    } else {
                        byte[] asBytes = new byte[8];
                        asBytes[7] = (byte)(beginAt & 0xFFL);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        asBytes[6] = (byte)(beginAt >>> 8);
                        asBytes[5] = (byte)(beginAt >>> 16);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        asBytes[4] = (byte)(beginAt >>> 24);
                        asBytes[3] = (byte)(beginAt >>> 32);
                        asBytes[2] = (byte)(beginAt >>> 40);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        asBytes[1] = (byte)(beginAt >>> 48);
                        asBytes[0] = (byte)(beginAt >>> 56);
                        BigInteger val = new BigInteger(1, asBytes);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                        row[0] = val.toString().getBytes();
                    }
                    rowSet.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    beginAt += (long)this.connection.getAutoIncrementIncrement();
                    ++i;
                }
            }
        }
        ResultSetImpl gkRs = ResultSetImpl.getInstance(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection, this, false);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.openResults.add(gkRs);
        return gkRs;
    }

    protected int getId() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.statementId;
    }

    public long getLastInsertID() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.lastInsertId;
    }

    public long getLongUpdateCount() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.results == null) {
            return -1L;
        }
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.results.getUpdateCount();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getMoreResults(1);
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.results == null) {
            return false;
        }
        boolean streamingMode = this.createStreamingResultSet();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (streamingMode) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.results.reallyResult()) {
                while (this.results.next()) {
                }
            }
        }
        ResultSetInternalMethods nextResultSet = this.results.getNextResultSet();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (current) {
            case 1: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.results == null) break;
                if (!streamingMode) {
                    this.results.close();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                this.results.clearNextResult();
                break;
            }
            case 3: {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.results != null) {
                    if (!streamingMode) {
                        this.results.close();
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    this.results.clearNextResult();
                }
                this.closeAllOpenResults();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                break;
            }
            case 2: {
                if (!this.connection.getDontTrackOpenResources()) {
                    this.openResults.add(this.results);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                this.results.clearNextResult();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("Statement.19"), "S1009", this.getExceptionInterceptor());
            }
        }
        this.results = nextResultSet;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.results == null) {
            this.updateCount = -1L;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.lastInsertId = -1L;
        } else if (this.results.reallyResult()) {
            this.updateCount = -1L;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.lastInsertId = -1L;
        } else {
            this.updateCount = this.results.getUpdateCount();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.lastInsertId = this.results.getUpdateID();
        }
        return this.results != null && this.results.reallyResult();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.timeoutInMillis / 1000;
    }

    private long getRecordCountFromInfo(String serverInfo) {
        int i;
        StringBuffer recordsBuf = new StringBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long recordsCount = 0L;
        long duplicatesCount = 0L;
        char c = '\u0000';
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int length = serverInfo.length();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (i = 0; i < length; ++i) {
            c = serverInfo.charAt(i);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (Character.isDigit(c)) break;
        }
        recordsBuf.append(c);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ++i;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i < length) {
            c = serverInfo.charAt(i);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!Character.isDigit(c)) break;
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Long.parseLong(recordsBuf.toString());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        StringBuffer duplicatesBuf = new StringBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i < length) {
            c = serverInfo.charAt(i);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (Character.isDigit(c)) break;
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        while (i < length) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            c = serverInfo.charAt(i);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!Character.isDigit(c)) break;
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Long.parseLong(duplicatesBuf.toString());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return recordsCount - duplicatesCount;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 1;
    }

    protected ResultSetInternalMethods getResultSetInternal() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.results;
    }

    @Override
    public int getResultSetType() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return Util.truncateAndConvertToInt(this.getLargeUpdateCount());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.connection != null && !this.connection.isClosed() && this.connection.versionMeetsMinimum(8, 0, 0)) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            SQLWarning pendingWarningsFromServer = SQLError.convertShowWarningsToSQLWarnings(this.connection);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.warningChain != null) {
                this.warningChain.setNextWarning(pendingWarningsFromServer);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                this.warningChain = pendingWarningsFromServer;
            }
            return this.warningChain;
        }
        return this.warningChain;
    }

    protected synchronized void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        GBaseConnection locallyScopedConn = this.connection;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.isClosed) {
            return;
        }
        if (!locallyScopedConn.getDontTrackOpenResources()) {
            locallyScopedConn.unregisterStatement(this);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        if (this.useUsageAdvisor) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (!calledExplicitly) {
                String message = Messages.getString("Statement.63") + Messages.getString("Statement.64");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.currentCatalog, this.connectionId, this.getId(), -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, message));
            }
        }
        if (closeOpenResults) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            closeOpenResults = !this.holdResultsOpenOverClose && !this.connection.getDontTrackOpenResources();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        if (closeOpenResults) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (this.results != null) {
                try {
                    this.results.close();
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.closeAllOpenResults();
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.connection != null) {
            if (this.maxRowsChanged) {
                this.connection.unsetMaxRows(this);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            if (!this.connection.getDontTrackOpenResources()) {
                this.connection.unregisterStatement(this);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
        this.isClosed = true;
        this.results = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.connection = null;
        this.warningChain = null;
        this.openResults = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.batchedGeneratedKeys = null;
        this.localInfileInputStream = null;
        this.pingTarget = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("Statement.5"), "S1009", this.getExceptionInterceptor());
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw SQLError.createSQLException(Messages.getString("Statement.7"), "S1009", this.getExceptionInterceptor());
        }
        this.fetchSize = rows;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setHoldResultsOpenOverClose(boolean holdResultsOpenOverClose) {
        this.holdResultsOpenOverClose = holdResultsOpenOverClose;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (max < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.11"), "S1009", this.getExceptionInterceptor());
        }
        int maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : GBaseIO.getMaxBuf();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (max > maxBuf) {
            throw SQLError.createSQLException(Messages.getString("Statement.13", new Object[]{Constants.longValueOf(maxBuf)}), "S1009", this.getExceptionInterceptor());
        }
        this.maxFieldSize = max;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (seconds < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.21"), "S1009", this.getExceptionInterceptor());
        }
        this.timeoutInMillis = seconds * 1000;
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getBatchedGeneratedKeys(java.sql.Statement batchedStatement) throws SQLException {
        if (!this.retrieveGeneratedKeys) return;
        ResultSet rs = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            rs = batchedStatement.getGeneratedKeys();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            while (rs.next()) {
                this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getBatchedGeneratedKeys(int maxKeys) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (!this.retrieveGeneratedKeys) return;
        ResultSet rs = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            if (maxKeys == 0) {
                rs = this.getGeneratedKeysInternal();
            } else {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rs = this.getGeneratedKeysInternal(maxKeys);
            }
            while (rs.next()) {
                this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    private boolean useServerFetch() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.connection.isCursorFetchEnabled() && this.fetchSize > 0 && this.resultSetConcurrency == 1007 && this.resultSetType == 1003;
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.isPoolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.isPoolable = poolable;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return iface.isInstance(this);
    }

    public Object unwrap(Class iface) throws SQLException {
        try {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return Util.cast(iface, this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.getExceptionInterceptor());
        }
    }

    protected int findStartOfStatement(String sql) {
        ArrayList<Integer> startPosList = new ArrayList<Integer>();
        this.findStartOfStatementInternal(sql, startPosList);
        int statementStartPos = 0;
        for (int i = 0; i < startPosList.size(); ++i) {
            statementStartPos += ((Integer)startPosList.get(i)).intValue();
        }
        return statementStartPos;
    }

    protected void findStartOfStatementInternal(String sql, List<Integer> startPosList) {
        int index;
        int startPos = 0;
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "/*")) {
            index = sql.indexOf("/*");
            startPos = sql.indexOf("*/", index);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (startPos == -1) {
                startPos = 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            } else {
                startPos += 2;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        } else if (StringUtils.startsWithIgnoreCaseAndWs(sql, "--") || StringUtils.startsWithIgnoreCaseAndWs(sql, "#")) {
            index = 0;
            if (StringUtils.startsWithIgnoreCaseAndWs(sql, "--")) {
                index = sql.indexOf("--");
            } else if (StringUtils.startsWithIgnoreCaseAndWs(sql, "#")) {
                index = sql.indexOf("#");
            }
            startPos = sql.indexOf(10, index);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (startPos == -1) {
                startPos = sql.indexOf(13, index);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (startPos == -1) {
                    startPos = 0;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            }
        }
        if (startPos > 0) {
            String subSql = sql.substring(startPos);
            startPosList.add(startPos);
            this.findStartOfStatementInternal(subSql, startPosList);
        }
    }

    @Override
    public synchronized InputStream getLocalInfileInputStream() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.localInfileInputStream;
    }

    @Override
    public synchronized void setLocalInfileInputStream(InputStream stream) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.localInfileInputStream = stream;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public synchronized void setPingTarget(PingTarget pingTarget) {
        this.pingTarget = pingTarget;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.exceptionInterceptor;
    }

    protected boolean containsOnDuplicateKeyInString(String sql) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getOnDuplicateKeyLocation(sql) != -1;
    }

    protected int getOnDuplicateKeyLocation(String sql) {
        return StringUtils.indexOfIgnoreCase(0, sql, new String[]{"ON", "DUPLICATE", "KEY", "UPDATE"}, "\"'`", "\"'`", this.connection.isNoBackslashEscapesSet() ? StringUtils.SEARCH_MODE__MRK_COM_WS : StringUtils.SEARCH_MODE__ALL);
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.closeOnCompletion;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeBatchInternal();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeUpdateInternal(sql, false, false);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeUpdateInternal(sql, false, autoGeneratedKeys == 1);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeUpdateInternal(sql, false, columnIndexes != null && columnIndexes.length > 0);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.executeUpdateInternal(sql, false, columnNames != null && columnNames.length > 0);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.getMaxRows();
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.checkClosed();
        if (this.results == null) {
            return -1L;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.results.getUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long max) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.checkClosed();
        if (max > 50000000L || max < 0L) {
            throw SQLError.createSQLException(Messages.getString("Statement.15") + max + " > " + 50000000 + ".", "S1009", this.getExceptionInterceptor());
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (max == 0L) {
            max = -1L;
        }
        this.maxRows = (int)max;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.maxRowsChanged = false;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            this.connection.maxRowsChanged(this);
        }
    }

    class CancelTask
    extends TimerTask {
        long connectionId = 0L;
        SQLException caughtWhileCancelling = null;
        StatementImpl toCancel;

        CancelTask(StatementImpl cancellee) throws SQLException {
            this.connectionId = StatementImpl.this.connection.getIO().getThreadId();
            this.toCancel = cancellee;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }

        public void run() {
            Thread cancelThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block30: {
                        java.sql.Connection cancelConn;
                        block33: {
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                            if (StatementImpl.this.connection.getQueryTimeoutKillsConnection()) {
                                try {
                                    CancelTask.this.toCancel.wasCancelled = true;
                                    CancelTask.this.toCancel.wasCancelledByTimeout = true;
                                    StatementImpl.this.connection.realClose(false, false, true, new GBaseStatementCancelledException(Messages.getString("Statement.ConnectionKilledDueToTimeout")));
                                }
                                catch (NullPointerException nullPointerException) {
                                }
                                catch (SQLException sqlEx) {
                                    CancelTask.this.caughtWhileCancelling = sqlEx;
                                }
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                                return;
                            }
                            cancelConn = null;
                            java.sql.Statement cancelStmt = null;
                            try {
                                try {
                                    Object object = StatementImpl.this.cancelTimeoutMutex;
                                    synchronized (object) {
                                        cancelConn = StatementImpl.this.connection.duplicate();
                                        cancelStmt = cancelConn.createStatement();
                                        cancelStmt.execute("KILL QUERY " + CancelTask.this.connectionId);
                                        CancelTask.this.toCancel.wasCancelled = true;
                                        CancelTask.this.toCancel.wasCancelledByTimeout = true;
                                    }
                                }
                                catch (SQLException sqlEx) {
                                    CancelTask.this.caughtWhileCancelling = sqlEx;
                                    Object var6_9 = null;
                                    if (cancelStmt != null) {
                                        try {
                                            cancelStmt.close();
                                        }
                                        catch (SQLException sqlEx2) {
                                            throw new CustomRuntimeException(sqlEx2.toString());
                                        }
                                    }
                                    if (cancelConn != null) {
                                        try {
                                            cancelConn.close();
                                        }
                                        catch (SQLException sqlEx3) {
                                            throw new CustomRuntimeException(sqlEx3.toString());
                                        }
                                    }
                                    CancelTask.this.toCancel = null;
                                    break block30;
                                }
                                catch (NullPointerException nullPointerException) {
                                    Object var6_10 = null;
                                    if (cancelStmt != null) {
                                        try {}
                                        catch (SQLException sqlEx2) {
                                            throw new CustomRuntimeException(sqlEx2.toString());
                                        }
                                        cancelStmt.close();
                                    }
                                    if (cancelConn != null) {
                                        try {}
                                        catch (SQLException sqlEx3) {
                                            throw new CustomRuntimeException(sqlEx3.toString());
                                        }
                                        cancelConn.close();
                                    }
                                    CancelTask.this.toCancel = null;
                                    break block30;
                                }
                                Object var6_8 = null;
                                if (cancelStmt == null) break block33;
                            }
                            catch (Throwable throwable) {
                                Object var6_11 = null;
                                if (cancelStmt != null) {
                                    try {}
                                    catch (SQLException sqlEx2) {
                                        throw new CustomRuntimeException(sqlEx2.toString());
                                    }
                                    cancelStmt.close();
                                }
                                if (cancelConn != null) {
                                    try {}
                                    catch (SQLException sqlEx3) {
                                        throw new CustomRuntimeException(sqlEx3.toString());
                                    }
                                    cancelConn.close();
                                }
                                CancelTask.this.toCancel = null;
                                throw throwable;
                            }
                            try {}
                            catch (SQLException sqlEx2) {
                                throw new CustomRuntimeException(sqlEx2.toString());
                            }
                            cancelStmt.close();
                        }
                        if (cancelConn != null) {
                            try {}
                            catch (SQLException sqlEx3) {
                                throw new CustomRuntimeException(sqlEx3.toString());
                            }
                            cancelConn.close();
                        }
                        CancelTask.this.toCancel = null;
                    }
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
            };
            cancelThread.start();
        }
    }
}

