/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.GBaseServerVersionProperties;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SystemDataBase {
    public static final String GBASE_Server_VERSION_SPLIT_REGEX = ",";
    public static final String GBASE_8A_SERVER_VERSION_KEY = "gbase.8a.Server.version";
    public static final String GBASE_8G_SYSTEM_VSERSION_KEY = "gbase.8g.system.vsersion";
    private static Map gbase8aServerVersion;
    private static Map gbase8gSystemServerVersion;
    private static String sysDataBaseName;
    private static final String SYSTEM_DATABASE_NAME = "system";
    private static final String GBASE_DATABASE_NAME = "gbase";

    private SystemDataBase() {
    }

    public static String getSystemDataBaseName(GBaseConnection con) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gbase8gSystemServerVersion.containsKey(con.getServerVersion().trim())) {
            sysDataBaseName = SYSTEM_DATABASE_NAME;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            sysDataBaseName = GBASE_DATABASE_NAME;
        }
        return sysDataBaseName;
    }

    private static void initSystem8aServerVersion(Map versionMap) {
        String[] gbase8gSystemServerVersions = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Object in = null;
        String gbase8gSystemServerVersion = GBaseServerVersionProperties.getProperty(GBASE_8G_SYSTEM_VSERSION_KEY);
        gbase8gSystemServerVersions = gbase8gSystemServerVersion.split(GBASE_Server_VERSION_SPLIT_REGEX);
        SystemDataBase.setVersionMap(gbase8gSystemServerVersions, versionMap);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    private static void initGbase8aServerVersion(Map versionMap) {
        String[] gbase8aServerVesions = null;
        String gbase8aServerVersion = GBaseServerVersionProperties.getProperty(GBASE_8A_SERVER_VERSION_KEY);
        gbase8aServerVesions = gbase8aServerVersion.split(GBASE_Server_VERSION_SPLIT_REGEX);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        SystemDataBase.setVersionMap(gbase8aServerVesions, versionMap);
    }

    public static boolean isGBase8a(GBaseConnection con) {
        boolean isGBase8a = false;
        if (gbase8aServerVersion.containsKey(con.getServerVersion().trim())) {
            isGBase8a = true;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return isGBase8a;
    }

    private static void setVersionMap(String[] versions, Map versionMap) {
        if (versions != null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (String versionItem : versions) {
                if (versionItem == null) continue;
                versionMap.put(versionItem.trim(), null);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
    }

    static {
        sysDataBaseName = null;
        gbase8aServerVersion = new HashMap();
        SystemDataBase.initGbase8aServerVersion(gbase8aServerVersion);
        gbase8gSystemServerVersion = new HashMap();
        SystemDataBase.initSystem8aServerVersion(gbase8gSystemServerVersion);
    }
}

