/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.TimeZoneUtil;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class TimeUtil {
    static final Map ABBREVIATED_TIMEZONES;
    static final TimeZone GMT_TIMEZONE;
    static final Map TIMEZONE_MAPPINGS;

    public static Time changeTimezone(GBaseConnection conn, Calendar sessionCalendar, Calendar targetCalendar, Time t, TimeZone fromTz, TimeZone toTz, boolean rollForward) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (conn != null) {
            if (conn.getUseTimezone() && !conn.getNoTimezoneConversionForTimeType()) {
                Calendar fromCal = Calendar.getInstance(fromTz);
                fromCal.setTime(t);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int fromOffset = fromCal.get(15) + fromCal.get(16);
                Calendar toCal = Calendar.getInstance(toTz);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                toCal.setTime(t);
                int toOffset = toCal.get(15) + toCal.get(16);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int offsetDiff = fromOffset - toOffset;
                long toTime = toCal.getTime().getTime();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (rollForward || conn.isServerTzUTC() && !conn.isClientTzUTC()) {
                    toTime += (long)offsetDiff;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    toTime -= (long)offsetDiff;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                Time changedTime = new Time(toTime);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return changedTime;
            }
            if (conn.getUseJDBCCompliantTimezoneShift() && targetCalendar != null) {
                Time adjustedTime = new Time(TimeUtil.jdbcCompliantZoneShift(sessionCalendar, targetCalendar, t));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return adjustedTime;
            }
        }
        return t;
    }

    public static Timestamp changeTimezone(GBaseConnection conn, Calendar sessionCalendar, Calendar targetCalendar, Timestamp tstamp, TimeZone fromTz, TimeZone toTz, boolean rollForward) {
        if (conn != null) {
            if (conn.getUseTimezone()) {
                Calendar fromCal = Calendar.getInstance(fromTz);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                fromCal.setTime(tstamp);
                int fromOffset = fromCal.get(15) + fromCal.get(16);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Calendar toCal = Calendar.getInstance(toTz);
                toCal.setTime(tstamp);
                int toOffset = toCal.get(15) + toCal.get(16);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                int offsetDiff = fromOffset - toOffset;
                long toTime = toCal.getTime().getTime();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (rollForward || conn.isServerTzUTC() && !conn.isClientTzUTC()) {
                    toTime += (long)offsetDiff;
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    toTime -= (long)offsetDiff;
                }
                Timestamp changedTimestamp = new Timestamp(toTime);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return changedTimestamp;
            }
            if (conn.getUseJDBCCompliantTimezoneShift()) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (targetCalendar != null) {
                    Timestamp adjustedTimestamp = new Timestamp(TimeUtil.jdbcCompliantZoneShift(sessionCalendar, targetCalendar, tstamp));
                    adjustedTimestamp.setNanos(tstamp.getNanos());
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    return adjustedTimestamp;
                }
            } else if (targetCalendar != null && conn.getIsUseDateConvert()) {
                Timestamp adjustedTimestamp = new Timestamp(TimeUtil.jdbcCompliantZoneShift(sessionCalendar, targetCalendar, tstamp));
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return adjustedTimestamp;
            }
        }
        return tstamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long jdbcCompliantZoneShift(Calendar sessionCalendar, Calendar targetCalendar, java.util.Date dt) {
        if (sessionCalendar == null) {
            sessionCalendar = new GregorianCalendar();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        java.util.Date origCalDate = targetCalendar.getTime();
        java.util.Date origSessionDate = sessionCalendar.getTime();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            sessionCalendar.setTime(dt);
            targetCalendar.set(1, sessionCalendar.get(1));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            targetCalendar.set(2, sessionCalendar.get(2));
            targetCalendar.set(5, sessionCalendar.get(5));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            targetCalendar.set(11, sessionCalendar.get(11));
            targetCalendar.set(12, sessionCalendar.get(12));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            targetCalendar.set(13, sessionCalendar.get(13));
            targetCalendar.set(14, sessionCalendar.get(14));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            long l = targetCalendar.getTime().getTime();
            Object var8_6 = null;
            sessionCalendar.setTime(origSessionDate);
            targetCalendar.setTime(origCalDate);
            return l;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            sessionCalendar.setTime(origSessionDate);
            targetCalendar.setTime(origCalDate);
            throw throwable;
        }
    }

    static final Date fastDateCreate(boolean useGmtConversion, Calendar gmtCalIfNeeded, Calendar cal, int year, int month, int day) {
        Calendar dateCal = cal;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (useGmtConversion) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (gmtCalIfNeeded == null) {
                gmtCalIfNeeded = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
            gmtCalIfNeeded.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            dateCal = gmtCalIfNeeded;
        }
        dateCal.clear();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        dateCal.set(14, 0);
        dateCal.set(year, month - 1, day, 0, 0, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long dateAsMillis = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            dateAsMillis = dateCal.getTimeInMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IllegalAccessError iae) {
            dateAsMillis = dateCal.getTime().getTime();
        }
        return new Date(dateAsMillis);
    }

    static final Date fastDateCreate(int year, int month, int day, Calendar targetCalendar) {
        Calendar dateCal = targetCalendar == null ? new GregorianCalendar() : targetCalendar;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        dateCal.clear();
        dateCal.set(year, month - 1, day, 0, 0, 0);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        dateCal.set(14, 0);
        long dateAsMillis = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            dateAsMillis = dateCal.getTimeInMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IllegalAccessError iae) {
            dateAsMillis = dateCal.getTime().getTime();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return new Date(dateAsMillis);
    }

    static final Time fastTimeCreate(Calendar cal, int hour, int minute, int second, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (hour < 0 || hour > 24) {
            throw SQLError.createSQLException("Illegal hour value '" + hour + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (minute < 0 || minute > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + minute + "'' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        if (second < 0 || second > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + second + "'' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        cal.clear();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        cal.set(1970, 0, 1, hour, minute, second);
        long timeAsMillis = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            timeAsMillis = cal.getTimeInMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IllegalAccessError iae) {
            timeAsMillis = cal.getTime().getTime();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return new Time(timeAsMillis);
    }

    static final Time fastTimeCreate(int hour, int minute, int second, Calendar targetCalendar, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (hour < 0 || hour > 23) {
            throw SQLError.createSQLException("Illegal hour value '" + hour + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (minute < 0 || minute > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + minute + "'' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        if (second < 0 || second > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + second + "'' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        Calendar cal = targetCalendar == null ? new GregorianCalendar() : targetCalendar;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        cal.clear();
        cal.set(1970, 0, 1, hour, minute, second);
        long timeAsMillis = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            timeAsMillis = cal.getTimeInMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IllegalAccessError iae) {
            timeAsMillis = cal.getTime().getTime();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return new Time(timeAsMillis);
    }

    static final Timestamp fastTimestampCreate(boolean useGmtConversion, Calendar gmtCalIfNeeded, Calendar cal, int year, int month, int day, int hour, int minute, int seconds, int secondsPart) {
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, seconds);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int offsetDiff = 0;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (useGmtConversion) {
            int fromOffset = cal.get(15) + cal.get(16);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (gmtCalIfNeeded == null) {
                gmtCalIfNeeded = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
            gmtCalIfNeeded.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            gmtCalIfNeeded.setTimeInMillis(cal.getTimeInMillis());
            int toOffset = gmtCalIfNeeded.get(15) + gmtCalIfNeeded.get(16);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            offsetDiff = fromOffset - toOffset;
        }
        if (secondsPart != 0) {
            cal.set(14, secondsPart / 1000000);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        long tsAsMillis = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            tsAsMillis = cal.getTimeInMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IllegalAccessError iae) {
            tsAsMillis = cal.getTime().getTime();
        }
        Timestamp ts = new Timestamp(tsAsMillis + (long)offsetDiff);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ts.setNanos(secondsPart);
        return ts;
    }

    static final Timestamp fastTimestampCreate(TimeZone tz, int year, int month, int day, int hour, int minute, int seconds, int secondsPart) {
        GregorianCalendar cal = tz == null ? new GregorianCalendar() : new GregorianCalendar(tz);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, seconds);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        long tsAsMillis = 0L;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            tsAsMillis = cal.getTimeInMillis();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        catch (IllegalAccessError iae) {
            tsAsMillis = cal.getTime().getTime();
        }
        Timestamp ts = new Timestamp(tsAsMillis);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        ts.setNanos(secondsPart);
        return ts;
    }

    public static String getCanoncialTimezone(String timezoneStr, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (timezoneStr == null) {
            return null;
        }
        timezoneStr = timezoneStr.trim();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (timezoneStr.length() > 2) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if ((timezoneStr.charAt(0) == '+' || timezoneStr.charAt(0) == '-') && Character.isDigit(timezoneStr.charAt(1))) {
                return "GMT" + timezoneStr;
            }
        }
        int daylightIndex = StringUtils.indexOfIgnoreCase(timezoneStr, "DAYLIGHT");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (daylightIndex != -1) {
            StringBuffer timezoneBuf = new StringBuffer();
            timezoneBuf.append(timezoneStr.substring(0, daylightIndex));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            timezoneBuf.append("Standard");
            timezoneBuf.append(timezoneStr.substring(daylightIndex + "DAYLIGHT".length(), timezoneStr.length()));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            timezoneStr = timezoneBuf.toString();
        }
        String canonicalTz = (String)TIMEZONE_MAPPINGS.get(timezoneStr);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (canonicalTz == null) {
            String[] abbreviatedTimezone = (String[])ABBREVIATED_TIMEZONES.get(timezoneStr);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            if (abbreviatedTimezone != null) {
                if (abbreviatedTimezone.length == 1) {
                    canonicalTz = abbreviatedTimezone[0];
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                } else {
                    StringBuffer possibleTimezones = new StringBuffer(128);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    possibleTimezones.append(abbreviatedTimezone[0]);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    for (int i = 1; i < abbreviatedTimezone.length; ++i) {
                        possibleTimezones.append(", ");
                        possibleTimezones.append(abbreviatedTimezone[i]);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    }
                    throw SQLError.createSQLException(Messages.getString("TimeUtil.TooGenericTimezoneId", new Object[]{timezoneStr, possibleTimezones}), "01S00", exceptionInterceptor);
                }
            }
        }
        return canonicalTz;
    }

    private static String timeFormattedString(int hours, int minutes, int seconds) {
        StringBuffer buf = new StringBuffer(8);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (hours < 10) {
            buf.append("0");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        buf.append(hours);
        buf.append(":");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (minutes < 10) {
            buf.append("0");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        buf.append(minutes);
        buf.append(":");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (seconds < 10) {
            buf.append("0");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        buf.append(seconds);
        return buf.toString();
    }

    public static SimpleDateFormat getSimpleDateFormat(SimpleDateFormat cachedSimpleDateFormat, String pattern, Calendar cal, TimeZone tz) {
        SimpleDateFormat sdf = cachedSimpleDateFormat != null ? cachedSimpleDateFormat : new SimpleDateFormat(pattern, Locale.US);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (cal != null) {
            sdf.setCalendar((Calendar)cal.clone());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        if (tz != null) {
            sdf.setTimeZone(tz);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return sdf;
    }

    static {
        GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
        TIMEZONE_MAPPINGS = Collections.unmodifiableMap(TimeZoneUtil.getTimezoneMap());
        ABBREVIATED_TIMEZONES = Collections.unmodifiableMap(TimeZoneUtil.getAbbreviatedTimezonesMap());
    }
}

