/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.StringUtils;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.List;

class VersionedStringProperty {
    int majorVersion;
    int minorVersion;
    int subminorVersion;
    boolean preferredValue = false;
    String propertyInfo;

    VersionedStringProperty(String property) {
        property = property.trim();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (property.startsWith("*")) {
            property = property.substring(1);
            this.preferredValue = true;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (property.startsWith(">")) {
            char c;
            property = property.substring(1);
            int charPos = 0;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (charPos = 0; charPos < property.length() && (Character.isWhitespace(c = property.charAt(charPos)) || Character.isDigit(c) || c == '.'); ++charPos) {
            }
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            String versionInfo = property.substring(0, charPos);
            List<String> versionParts = StringUtils.split(versionInfo, ".", true);
            this.majorVersion = Integer.parseInt(versionParts.get(0).toString());
            this.minorVersion = versionParts.size() > 1 ? Integer.parseInt(versionParts.get(1).toString()) : 0;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.subminorVersion = versionParts.size() > 2 ? Integer.parseInt(versionParts.get(2).toString()) : 0;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.propertyInfo = property.substring(charPos);
        } else {
            this.subminorVersion = 0;
            this.minorVersion = 0;
            this.majorVersion = 0;
            this.propertyInfo = property;
        }
    }

    VersionedStringProperty(String property, int major, int minor, int subminor) {
        this.propertyInfo = property;
        this.majorVersion = major;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.minorVersion = minor;
        this.subminorVersion = subminor;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    boolean isOkayForVersion(Connection conn) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return conn.versionMeetsMinimum(this.majorVersion, this.minorVersion, this.subminorVersion);
    }

    public String toString() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this.propertyInfo;
    }
}

