/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.interceptors;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.ResultSetInternalMethods;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.StatementInterceptor;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResultSetScannerInterceptor
implements StatementInterceptor {
    private Pattern regexP;

    public void init(Connection conn, Properties props) throws SQLException {
        String regexFromUser = props.getProperty("resultSetScannerRegex");
        if (regexFromUser == null || regexFromUser.length() == 0) {
            throw new SQLException("resultSetScannerRegex must be configured, and must be > 0 characters");
        }
        try {
            this.regexP = Pattern.compile(regexFromUser);
        }
        catch (Throwable t) {
            SQLException sqlEx = new SQLException("Can't use configured regex due to underlying exception.");
            sqlEx.initCause(t);
            throw sqlEx;
        }
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection) throws SQLException {
        final ResultSetInternalMethods finalResultSet = originalResultSet;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return (ResultSetInternalMethods)Proxy.newProxyInstance(originalResultSet.getClass().getClassLoader(), new Class[]{ResultSetInternalMethods.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object invocationResult = method.invoke((Object)finalResultSet, args);
                String methodName = method.getName();
                if (invocationResult instanceof String || "getString".equals(methodName) || "getObject".equals(methodName) || "getObjectStoredProc".equals(methodName)) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    if (invocationResult == null) {
                        return null;
                    }
                    Matcher matcher = ResultSetScannerInterceptor.this.regexP.matcher(invocationResult.toString());
                    if (matcher.matches()) {
                        throw new SQLException("value disallowed by filter");
                    }
                }
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                return invocationResult;
            }
        });
    }

    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) throws SQLException {
        return null;
    }

    public boolean executeTopLevelOnly() {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    public void destroy() {
    }
}

