/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.interceptors;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.ResultSetInternalMethods;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.StatementInterceptor;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServerStatusDiffInterceptor
implements StatementInterceptor {
    private Map preExecuteValues = new HashMap();
    private Map postExecuteValues = new HashMap();

    public void init(Connection conn, Properties props) throws SQLException {
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (connection.versionMeetsMinimum(8, 0, 0)) {
            this.populateMapWithSessionStatusValues(connection, this.postExecuteValues);
            connection.getLog().logInfo("Server status change for statement:\n" + Util.calculateDifferences(this.preExecuteValues, this.postExecuteValues));
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMapWithSessionStatusValues(Connection connection, Map toPopulate) throws SQLException {
        java.sql.Statement stmt;
        block6: {
            stmt = null;
            ResultSet rs = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                toPopulate.clear();
                stmt = connection.createStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rs = stmt.executeQuery("SHOW SESSION STATUS");
                while (rs.next()) {
                    toPopulate.put(rs.getString(1), rs.getString(2));
                }
                Object var6_5 = null;
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
    }

    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (connection.versionMeetsMinimum(8, 0, 0)) {
            this.populateMapWithSessionStatusValues(connection, this.preExecuteValues);
        }
        return null;
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public void destroy() {
    }
}

