/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.interceptors;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.ResultSetInternalMethods;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.StatementInterceptor;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class SessionAssociationInterceptor
implements StatementInterceptor {
    protected static ThreadLocal sessionLocal = new ThreadLocal();
    protected String currentSessionKey;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) throws SQLException {
        String key = SessionAssociationInterceptor.getSessionKey();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (key != null && !key.equals(this.currentSessionKey)) {
            PreparedStatement pstmt = connection.clientPrepareStatement("SET @gbase_proxy_session=?");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                pstmt.setString(1, key);
                pstmt.execute();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            this.currentSessionKey = key;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return null;
    }

    public static final void resetSessionKey() {
        sessionLocal.set(null);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection) throws SQLException {
        return null;
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public static final void setSessionKey(String key) {
        sessionLocal.set(key);
    }

    public void init(Connection conn, Properties props) throws SQLException {
    }

    public static final String getSessionKey() {
        return (String)sessionLocal.get();
    }
}

