/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.jdbc2.optional;

import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.Constants;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.exceptions.CustomRuntimeException;
import com.gbase.jdbc.jdbc2.optional.GBasePooledConnection;
import com.gbase.jdbc.jdbc2.optional.GBaseXAException;
import com.gbase.jdbc.jdbc2.optional.GBaseXid;
import com.gbase.jdbc.log.Log;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class GBaseXAConnection
extends GBasePooledConnection
implements XAConnection,
XAResource {
    private ConnectionImpl underlyingConnection;
    private static final Map GBASE_ERROR_CODES_TO_XA_ERROR_CODES;
    private Log log;
    protected boolean logXaCommands;
    private static final Constructor JDBC_4_XA_CONNECTION_WRAPPER_CTOR;

    protected static GBaseXAConnection getInstance(ConnectionImpl gbaseConnection, boolean logXaCommands) throws SQLException {
        if (!Util.isJdbc4()) {
            return new GBaseXAConnection(gbaseConnection, logXaCommands);
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return (GBaseXAConnection)Util.handleNewInstance(JDBC_4_XA_CONNECTION_WRAPPER_CTOR, new Object[]{gbaseConnection, logXaCommands}, gbaseConnection.getExceptionInterceptor());
    }

    public GBaseXAConnection(ConnectionImpl connection, boolean logXaCommands) throws SQLException {
        super(connection);
        this.underlyingConnection = connection;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.log = connection.getLog();
        this.logXaCommands = logXaCommands;
    }

    public XAResource getXAResource() throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return this;
    }

    public int getTransactionTimeout() throws XAException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return 0;
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (xares instanceof GBaseXAConnection) {
            return this.underlyingConnection.isSameResource(((GBaseXAConnection)xares).underlyingConnection);
        }
        return false;
    }

    public Xid[] recover(int flag) throws XAException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return GBaseXAConnection.recover(this.underlyingConnection, flag);
    }

    /*
     * Loose catch block
     */
    protected static Xid[] recover(Connection c, int flag) throws XAException {
        ArrayList<GBaseXid> recoveredXidList;
        block19: {
            Statement stmt;
            ResultSet rs;
            block18: {
                boolean startRscan = (flag & 0x1000000) > 0;
                boolean endRscan = (flag & 0x800000) > 0;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (!startRscan && !endRscan && flag != 0) {
                    throw new GBaseXAException(-5, "Invalid flag, must use TMNOFLAGS, or any combination of TMSTARTRSCAN and TMENDRSCAN", null);
                }
                if (!startRscan) {
                    return new Xid[0];
                }
                rs = null;
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                stmt = null;
                recoveredXidList = new ArrayList<GBaseXid>();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                stmt = c.createStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                rs = stmt.executeQuery("XA RECOVER");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                while (rs.next()) {
                    int formatId = rs.getInt(1);
                    int gtridLength = rs.getInt(2);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    int bqualLength = rs.getInt(3);
                    byte[] gtridAndBqual = rs.getBytes(4);
                    byte[] gtrid = new byte[gtridLength];
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    byte[] bqual = new byte[bqualLength];
                    if (gtridAndBqual.length != gtridLength + bqualLength) {
                        throw new GBaseXAException(105, "Error while recovering XIDs from RM. GTRID and BQUAL are wrong sizes", null);
                    }
                    System.arraycopy(gtridAndBqual, 0, gtrid, 0, gtridLength);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    System.arraycopy(gtridAndBqual, gtridLength, bqual, 0, bqualLength);
                    recoveredXidList.add(new GBaseXid(gtrid, bqual, formatId));
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                Object var14_17 = null;
                if (rs == null) break block18;
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlEx) {
                    throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
                }
            }
            break block19;
            {
                catch (SQLException sqlEx) {
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                    throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx) {
                        throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
                    }
                }
                throw throwable;
            }
        }
        int numXids = recoveredXidList.size();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Xid[] asXids = new Xid[numXids];
        Object[] asObjects = recoveredXidList.toArray();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        for (int i = 0; i < numXids; ++i) {
            asXids[i] = (Xid)asObjects[i];
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
        return asXids;
    }

    public int prepare(Xid xid) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA PREPARE ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.dispatchCommand(commandBuf.toString());
        return 0;
    }

    public void forget(Xid xid) throws XAException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA ROLLBACK ");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        try {
            this.dispatchCommand(commandBuf.toString());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Object var4_3 = null;
            this.underlyingConnection.setInGlobalTx(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.underlyingConnection.setInGlobalTx(false);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw throwable;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public void end(Xid xid, int flags) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA END ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x2000000: {
                commandBuf.append(" SUSPEND");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                break;
            }
            case 0x20000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.dispatchCommand(commandBuf.toString());
    }

    public void start(Xid xid, int flags) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        commandBuf.append("XA START ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        switch (flags) {
            case 0x200000: {
                commandBuf.append(" JOIN");
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                break;
            }
            case 0x8000000: {
                commandBuf.append(" RESUME");
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.dispatchCommand(commandBuf.toString());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.underlyingConnection.setInGlobalTx(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA COMMIT ");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (onePhase) {
            commandBuf.append(" ONE PHASE");
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            this.dispatchCommand(commandBuf.toString());
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            Object var5_4 = null;
            this.underlyingConnection.setInGlobalTx(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.underlyingConnection.setInGlobalTx(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSet dispatchCommand(String command) throws XAException {
        ResultSet resultSet;
        Statement stmt = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        try {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (this.logXaCommands) {
                    this.log.logDebug("Executing XA statement: " + command);
                }
                stmt = this.underlyingConnection.createStatement();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                stmt.execute(command);
                ResultSet rs = stmt.getResultSet();
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                resultSet = rs;
                Object var6_6 = null;
                if (stmt == null) return resultSet;
            }
            catch (SQLException sqlEx) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return resultSet;
        }
        stmt.close();
        return resultSet;
    }

    protected static XAException mapXAExceptionFromSQLException(SQLException sqlEx) {
        Integer xaCode = (Integer)GBASE_ERROR_CODES_TO_XA_ERROR_CODES.get(Constants.integerValueOf(sqlEx.getErrorCode()));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (xaCode != null) {
            return new GBaseXAException(xaCode, sqlEx.getMessage(), null);
        }
        return new GBaseXAException(sqlEx.getMessage(), null);
    }

    private static String xidToString(Xid xid) {
        String asHex;
        int i;
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] btrid = xid.getBranchQualifier();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        int lengthAsString = 6;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gtrid != null) {
            lengthAsString += 2 * gtrid.length;
        }
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (btrid != null) {
            lengthAsString += 2 * btrid.length;
        }
        String formatIdInHex = Integer.toHexString(xid.getFormatId());
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        lengthAsString += formatIdInHex.length();
        StringBuffer asString = new StringBuffer(lengthAsString += 3);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        asString.append("0x");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (gtrid != null) {
            for (i = 0; i < gtrid.length; ++i) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                asHex = Integer.toHexString(gtrid[i] & 0xFF);
                if (asHex.length() == 1) {
                    asString.append("0");
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                    RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                }
                asString.append(asHex);
            }
        }
        asString.append(",");
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (btrid != null) {
            asString.append("0x");
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            for (i = 0; i < btrid.length; ++i) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                asHex = Integer.toHexString(btrid[i] & 0xFF);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                if (asHex.length() == 1) {
                    asString.append("0");
                }
                asString.append(asHex);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
        asString.append(",0x");
        asString.append(formatIdInHex);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return asString.toString();
    }

    public synchronized Connection getConnection() throws SQLException {
        Connection connToWrap = this.getConnection(false, true);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        return connToWrap;
    }

    static {
        HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        temp.put(Constants.integerValueOf(1397), Constants.integerValueOf(-4));
        temp.put(Constants.integerValueOf(1398), Constants.integerValueOf(-5));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        temp.put(Constants.integerValueOf(1399), Constants.integerValueOf(-7));
        temp.put(Constants.integerValueOf(1400), Constants.integerValueOf(-9));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        temp.put(Constants.integerValueOf(1401), Constants.integerValueOf(-3));
        temp.put(Constants.integerValueOf(1402), Constants.integerValueOf(100));
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        temp.put(1440, -8);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        GBASE_ERROR_CODES_TO_XA_ERROR_CODES = Collections.unmodifiableMap(temp);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (Util.isJdbc4()) {
            try {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                JDBC_4_XA_CONNECTION_WRAPPER_CTOR = Class.forName("com.gbase.jdbc.jdbc2.optional.JDBC4GBaseXAConnection").getConstructor(ConnectionImpl.class, Boolean.TYPE);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
            catch (SecurityException e) {
                throw new CustomRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                throw new CustomRuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new CustomRuntimeException(e);
            }
        } else {
            JDBC_4_XA_CONNECTION_WRAPPER_CTOR = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }
}

