/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.jdbc2.optional;

import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.jdbc2.optional.SuspendableXAConnection;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class JDBC4SuspendableXAConnection
extends SuspendableXAConnection {
    private Map<StatementEventListener, StatementEventListener> statementEventListeners;

    public JDBC4SuspendableXAConnection(ConnectionImpl connection) throws SQLException {
        super(connection);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        this.statementEventListeners = new HashMap<StatementEventListener, StatementEventListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatementEventListener(StatementEventListener listener) {
        Map<StatementEventListener, StatementEventListener> map = this.statementEventListeners;
        synchronized (map) {
            this.statementEventListeners.remove(listener);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }

    public synchronized void close() throws SQLException {
        super.close();
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (this.statementEventListeners != null) {
            this.statementEventListeners.clear();
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            this.statementEventListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStatementEvent(StatementEvent event) throws SQLException {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        Map<StatementEventListener, StatementEventListener> map = this.statementEventListeners;
        synchronized (map) {
            for (StatementEventListener listener : this.statementEventListeners.keySet()) {
                listener.statementClosed(event);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatementEventListener(StatementEventListener listener) {
        Map<StatementEventListener, StatementEventListener> map = this.statementEventListeners;
        synchronized (map) {
            this.statementEventListeners.put(listener, listener);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        }
    }
}

