/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.log;

import com.gbase.jdbc.ExceptionInterceptor;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.log.Log;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class LogFactory {
    public static Log getLogger(String className, String instanceName, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (className == null) {
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw SQLError.createSQLException("Logger class can not be NULL", "S1009", exceptionInterceptor);
        }
        if (instanceName == null) {
            throw SQLError.createSQLException("Logger instance name can not be NULL", "S1009", exceptionInterceptor);
        }
        try {
            Class<?> loggerClass = null;
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            try {
                loggerClass = Class.forName(className);
            }
            catch (ClassNotFoundException nfe) {
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
                RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
                loggerClass = Class.forName(Log.class.getPackage().getName() + "." + className);
            }
            Constructor<?> constructor = loggerClass.getConstructor(String.class);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            return (Log)constructor.newInstance(instanceName);
        }
        catch (ClassNotFoundException cnfe) {
            SQLException sqlEx = SQLError.createSQLException("Unable to load class for logger '" + className + "'", "S1009", exceptionInterceptor);
            sqlEx.initCause(cnfe);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw sqlEx;
        }
        catch (NoSuchMethodException nsme) {
            SQLException sqlEx = SQLError.createSQLException("Logger class does not have a single-arg constructor that takes an instance name", "S1009", exceptionInterceptor);
            sqlEx.initCause(nsme);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw sqlEx;
        }
        catch (InstantiationException inse) {
            SQLException sqlEx = SQLError.createSQLException("Unable to instantiate logger class '" + className + "', exception in constructor?", "S1009", exceptionInterceptor);
            sqlEx.initCause(inse);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw sqlEx;
        }
        catch (InvocationTargetException ite) {
            SQLException sqlEx = SQLError.createSQLException("Unable to instantiate logger class '" + className + "', exception in constructor?", "S1009", exceptionInterceptor);
            sqlEx.initCause(ite);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw sqlEx;
        }
        catch (IllegalAccessException iae) {
            SQLException sqlEx = SQLError.createSQLException("Unable to instantiate logger class '" + className + "', constructor not public", "S1009", exceptionInterceptor);
            sqlEx.initCause(iae);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw sqlEx;
        }
        catch (ClassCastException cce) {
            SQLException sqlEx = SQLError.createSQLException("Logger class '" + className + "' does not implement the '" + Log.class.getName() + "' interface", "S1009", exceptionInterceptor);
            sqlEx.initCause(cce);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
            throw sqlEx;
        }
    }
}

