/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.profiler;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.log.Log;
import com.gbase.jdbc.profiler.ProfilerEvent;
import com.gbase.jdbc.profiler.ProfilerEventHandler;
import com.gbase.jdbc.util.RuntimeInfoCollector;
import com.gbase.jdbc.util.RuntimeInfoEnum;
import java.sql.SQLException;
import java.util.Properties;

public class LoggingProfilerEventHandler
implements ProfilerEventHandler {
    private Log log;

    public void consumeEvent(ProfilerEvent evt) {
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        if (evt.eventType == 0) {
            this.log.logWarn(evt);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
            RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
        } else {
            this.log.logInfo(evt);
        }
    }

    public void destroy() {
        this.log = null;
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.MEMORY);
        RuntimeInfoCollector.printRuntimeInfo(RuntimeInfoEnum.THREAD);
    }

    public void init(Connection conn, Properties props) throws SQLException {
        this.log = conn.getLog();
    }
}

